/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.net.InetAddresses;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slice;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.Description;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class IpAddressFunctions {
    private IpAddressFunctions() {
    }

    @Description(value="Determines whether given IP address exists in the CIDR")
    @ScalarFunction
    @SqlType(value="boolean")
    public static boolean contains(@SqlType(value="varchar") Slice network, @SqlType(value="ipaddress") Slice address) {
        byte[] ipAddress;
        boolean isIpv4;
        byte[] base;
        String cidr = network.toStringUtf8();
        int separator = cidr.indexOf("/");
        if (separator == -1) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Invalid CIDR");
        }
        try {
            InetAddress inetAddress = InetAddresses.forString((String)cidr.substring(0, separator));
            base = inetAddress.getAddress();
            isIpv4 = inetAddress instanceof Inet4Address;
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Invalid network IP address");
        }
        int prefixLength = Integer.parseInt(cidr.substring(separator + 1));
        if (prefixLength < 0) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Invalid prefix length");
        }
        int baseLength = base.length * 8;
        if (prefixLength > baseLength) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Prefix length exceeds address length");
        }
        if (isIpv4 && !IpAddressFunctions.isValidIpV4Cidr(base, prefixLength)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Invalid CIDR");
        }
        if (!isIpv4 && !IpAddressFunctions.isValidIpV6Cidr(prefixLength)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Invalid CIDR");
        }
        try {
            ipAddress = InetAddress.getByAddress(address.getBytes()).getAddress();
        }
        catch (UnknownHostException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Invalid IP address");
        }
        if (base.length != ipAddress.length) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "IP address version should be the same");
        }
        if (prefixLength == 0) {
            return true;
        }
        BigInteger cidrPrefix = new BigInteger(base).shiftRight(baseLength - prefixLength);
        BigInteger addressPrefix = new BigInteger(ipAddress).shiftRight(baseLength - prefixLength);
        return cidrPrefix.equals(addressPrefix);
    }

    private static boolean isValidIpV6Cidr(int prefixLength) {
        return prefixLength >= 0 && prefixLength <= 128;
    }

    private static boolean isValidIpV4Cidr(byte[] address, int prefix) {
        long mask = 0xFFFFFFFFL >>> prefix;
        return ((long)Ints.fromByteArray((byte[])address) & mask) == 0L;
    }
}

