/*
 * Decompiled with CFR 0.152.
 */
package io.trino.security;

import com.google.common.base.MoreObjects;
import io.trino.Session;
import io.trino.spi.QueryId;
import io.trino.spi.security.Identity;
import io.trino.spi.security.SystemSecurityContext;
import io.trino.transaction.TransactionId;
import java.util.Objects;
import java.util.Optional;

public class SecurityContext {
    private final TransactionId transactionId;
    private final Identity identity;
    private final QueryId queryId;

    public static SecurityContext of(Session session) {
        Objects.requireNonNull(session, "session is null");
        return new SecurityContext(session.getRequiredTransactionId(), session.getIdentity(), session.getQueryId());
    }

    public SecurityContext(TransactionId transactionId, Identity identity, QueryId queryId) {
        this.transactionId = Objects.requireNonNull(transactionId, "transactionId is null");
        this.identity = Objects.requireNonNull(identity, "identity is null");
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
    }

    public TransactionId getTransactionId() {
        return this.transactionId;
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public SystemSecurityContext toSystemSecurityContext() {
        return new SystemSecurityContext(this.identity, Optional.of(this.queryId));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityContext that = (SecurityContext)o;
        return Objects.equals(this.transactionId, that.transactionId) && Objects.equals(this.identity, that.identity) && Objects.equals(this.queryId, that.queryId);
    }

    public int hashCode() {
        return Objects.hash(this.transactionId, this.identity, this.queryId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("identity", (Object)this.identity).add("queryId", (Object)this.queryId).toString();
    }
}

