/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.jwt;

import io.airlift.configuration.Config;
import io.airlift.configuration.LegacyConfig;
import io.airlift.configuration.validation.FileExists;
import java.io.File;
import java.util.Optional;
import javax.validation.constraints.NotNull;

public class JwtAuthenticatorConfig {
    private String keyFile;
    private String requiredIssuer;
    private String requiredAudience;
    private String principalField = "sub";
    private Optional<String> userMappingPattern = Optional.empty();
    private Optional<File> userMappingFile = Optional.empty();

    @NotNull
    public String getKeyFile() {
        return this.keyFile;
    }

    @Config(value="http-server.authentication.jwt.key-file")
    @LegacyConfig(value={"http.authentication.jwt.key-file"})
    public JwtAuthenticatorConfig setKeyFile(String keyFile) {
        this.keyFile = keyFile;
        return this;
    }

    public String getRequiredIssuer() {
        return this.requiredIssuer;
    }

    @Config(value="http-server.authentication.jwt.required-issuer")
    @LegacyConfig(value={"http.authentication.jwt.required-issuer"})
    public JwtAuthenticatorConfig setRequiredIssuer(String requiredIssuer) {
        this.requiredIssuer = requiredIssuer;
        return this;
    }

    public String getRequiredAudience() {
        return this.requiredAudience;
    }

    @Config(value="http-server.authentication.jwt.required-audience")
    @LegacyConfig(value={"http.authentication.jwt.required-audience"})
    public JwtAuthenticatorConfig setRequiredAudience(String requiredAudience) {
        this.requiredAudience = requiredAudience;
        return this;
    }

    @NotNull
    public String getPrincipalField() {
        return this.principalField;
    }

    @Config(value="http-server.authentication.jwt.principal-field")
    public JwtAuthenticatorConfig setPrincipalField(String principalField) {
        this.principalField = principalField;
        return this;
    }

    public Optional<String> getUserMappingPattern() {
        return this.userMappingPattern;
    }

    @Config(value="http-server.authentication.jwt.user-mapping.pattern")
    public JwtAuthenticatorConfig setUserMappingPattern(String userMappingPattern) {
        this.userMappingPattern = Optional.ofNullable(userMappingPattern);
        return this;
    }

    public Optional<@FileExists File> getUserMappingFile() {
        return this.userMappingFile;
    }

    @Config(value="http-server.authentication.jwt.user-mapping.file")
    public JwtAuthenticatorConfig setUserMappingFile(File userMappingFile) {
        this.userMappingFile = Optional.ofNullable(userMappingFile);
        return this;
    }
}

