/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import java.time.Instant;
import java.util.Date;
import java.util.Optional;
import java.util.function.Predicate;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;

public final class NonceCookie {
    public static final String NONCE_COOKIE = "__Secure-Trino-Nonce";

    private NonceCookie() {
    }

    public static NewCookie create(String nonce, Instant tokenExpiration) {
        return new NewCookie(NONCE_COOKIE, nonce, "/oauth2/callback", null, 1, null, -1, Date.from(tokenExpiration), true, true);
    }

    public static Optional<String> read(Cookie cookie) {
        return Optional.ofNullable(cookie).map(Cookie::getValue).filter(Predicate.not(String::isBlank));
    }

    public static NewCookie delete() {
        return new NewCookie(NONCE_COOKIE, "delete", "/oauth2/callback", null, 1, null, 0, null, true, true);
    }
}

