/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.OrderBy;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.SortItem;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class NodeUtils {
    private NodeUtils() {
    }

    public static List<SortItem> getSortItemsFromOrderBy(Optional<OrderBy> orderBy) {
        return orderBy.map(OrderBy::getSortItems).orElse((List)ImmutableList.of());
    }

    public static Map<String, Expression> mapFromProperties(List<Property> properties) {
        return (Map)properties.stream().collect(ImmutableMap.toImmutableMap(property -> property.getName().getValue(), Property::getValue));
    }
}

