/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.operator.HashGenerator;
import io.trino.spi.Page;
import io.trino.spi.connector.BucketFunction;

public class HashBucketFunction
implements BucketFunction {
    private final HashGenerator generator;
    private final int bucketCount;

    public HashBucketFunction(HashGenerator generator, int bucketCount) {
        Preconditions.checkArgument((bucketCount > 0 ? 1 : 0) != 0, (Object)"partitionCount must be at least 1");
        this.generator = generator;
        this.bucketCount = bucketCount;
    }

    public int getBucket(Page page, int position) {
        return this.generator.getPartition(this.bucketCount, position, page);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("generator", (Object)this.generator).add("bucketCount", this.bucketCount).toString();
    }
}

