/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.MoreFutures;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.DynamicFilters;
import io.trino.sql.planner.DomainCoercer;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.plan.DynamicFilterId;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class LocalDynamicFiltersCollector {
    private final Session session;
    private final Map<DynamicFilterId, SettableFuture<Domain>> futures = new HashMap<DynamicFilterId, SettableFuture<Domain>>();

    public LocalDynamicFiltersCollector(Session session) {
        this.session = Objects.requireNonNull(session, "session is null");
    }

    public void register(Set<DynamicFilterId> filterIds) {
        filterIds.forEach(filterId -> Verify.verify((this.futures.put((DynamicFilterId)filterId, (SettableFuture<Domain>)SettableFuture.create()) == null ? 1 : 0) != 0, (String)"LocalDynamicFiltersCollector: duplicate filter %s", (Object)filterId));
    }

    public Set<DynamicFilterId> getRegisteredDynamicFilterIds() {
        return this.futures.keySet();
    }

    public void collectDynamicFilterDomains(Map<DynamicFilterId, Domain> dynamicFilterDomains) {
        dynamicFilterDomains.forEach((key, value) -> {
            SettableFuture<Domain> future = this.futures.get(key);
            if (future != null) {
                future.set(value);
            }
        });
    }

    public DynamicFilter createDynamicFilter(List<DynamicFilters.Descriptor> descriptors, Map<Symbol, ColumnHandle> columnsMap, TypeProvider typeProvider, Metadata metadata, TypeOperators typeOperators) {
        Multimap<DynamicFilterId, DynamicFilters.Descriptor> descriptorMap = DynamicFilters.extractSourceSymbols(descriptors);
        List predicateFutures = (List)descriptorMap.keySet().stream().filter(this.futures.keySet()::contains).map(filterId -> Futures.transform((ListenableFuture)((ListenableFuture)Objects.requireNonNull(this.futures.get(filterId), () -> String.format("Missing dynamic filter %s", filterId))), domain -> TupleDomain.withColumnDomains((Map)((Map)descriptorMap.get(filterId).stream().collect(ImmutableMap.toImmutableMap(descriptor -> {
            Symbol probeSymbol = Symbol.from(descriptor.getInput());
            return Objects.requireNonNull((ColumnHandle)columnsMap.get(probeSymbol), () -> String.format("Missing probe column for %s", probeSymbol));
        }, descriptor -> {
            Type targetType = typeProvider.get(Symbol.from(descriptor.getInput()));
            Domain updatedDomain = descriptor.applyComparison((Domain)domain);
            if (!updatedDomain.getType().equals(targetType)) {
                return DomainCoercer.applySaturatedCasts(metadata, typeOperators, this.session, updatedDomain, targetType);
            }
            return updatedDomain;
        })))), (Executor)MoreExecutors.directExecutor())).collect(ImmutableList.toImmutableList());
        Set columnsCovered = (Set)descriptorMap.values().stream().map(DynamicFilters.Descriptor::getInput).map(Symbol::from).map(probeSymbol -> Objects.requireNonNull((ColumnHandle)columnsMap.get(probeSymbol), () -> "Missing probe column for " + probeSymbol)).collect(ImmutableSet.toImmutableSet());
        return new TableSpecificDynamicFilter(columnsCovered, predicateFutures);
    }

    private static class TableSpecificDynamicFilter
    implements DynamicFilter {
        private final Set<ColumnHandle> columnsCovered;
        @GuardedBy(value="this")
        private CompletableFuture<?> isBlocked;
        @GuardedBy(value="this")
        private TupleDomain<ColumnHandle> currentPredicate;
        @GuardedBy(value="this")
        private int futuresLeft;

        private TableSpecificDynamicFilter(Set<ColumnHandle> columnsCovered, List<ListenableFuture<TupleDomain<ColumnHandle>>> predicateFutures) {
            this.columnsCovered = ImmutableSet.copyOf((Collection)Objects.requireNonNull(columnsCovered, "columnsCovered is null"));
            this.futuresLeft = predicateFutures.size();
            this.isBlocked = predicateFutures.isEmpty() ? NOT_BLOCKED : new CompletableFuture();
            this.currentPredicate = TupleDomain.all();
            predicateFutures.stream().forEach(future -> MoreFutures.addSuccessCallback((ListenableFuture)future, this::update, (Executor)MoreExecutors.directExecutor()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update(TupleDomain<ColumnHandle> predicate) {
            CompletableFuture<?> currentFuture;
            TableSpecificDynamicFilter tableSpecificDynamicFilter = this;
            synchronized (tableSpecificDynamicFilter) {
                --this.futuresLeft;
                Verify.verify((this.futuresLeft >= 0 ? 1 : 0) != 0);
                this.currentPredicate = this.currentPredicate.intersect(predicate);
                currentFuture = this.isBlocked;
                this.isBlocked = this.isComplete() ? NOT_BLOCKED : new CompletableFuture();
            }
            Verify.verify((boolean)currentFuture.complete(null));
        }

        public Set<ColumnHandle> getColumnsCovered() {
            return this.columnsCovered;
        }

        public synchronized CompletableFuture<?> isBlocked() {
            return MoreFutures.unmodifiableFuture(this.isBlocked);
        }

        public synchronized boolean isComplete() {
            return this.futuresLeft == 0;
        }

        public synchronized boolean isAwaitable() {
            return this.futuresLeft > 0;
        }

        public synchronized TupleDomain<ColumnHandle> getCurrentPredicate() {
            return this.currentPredicate;
        }
    }
}

