/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.Maps;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ProjectOffPushDownRule;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class PruneAggregationColumns
extends ProjectOffPushDownRule<AggregationNode> {
    public PruneAggregationColumns() {
        super(Patterns.aggregation());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(Rule.Context context, AggregationNode aggregationNode, Set<Symbol> referencedOutputs) {
        Map prunedAggregations = Maps.filterKeys(aggregationNode.getAggregations(), referencedOutputs::contains);
        if (prunedAggregations.size() == aggregationNode.getAggregations().size()) {
            return Optional.empty();
        }
        return Optional.of(new AggregationNode(aggregationNode.getId(), aggregationNode.getSource(), prunedAggregations, aggregationNode.getGroupingSets(), aggregationNode.getPreGroupedSymbols(), aggregationNode.getStep(), aggregationNode.getHashSymbol(), aggregationNode.getGroupIdSymbol()));
    }
}

