/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ProjectOffPushDownRule;
import io.trino.sql.planner.iterative.rule.Util;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TopNRankingNode;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class PruneTopNRankingColumns
extends ProjectOffPushDownRule<TopNRankingNode> {
    public PruneTopNRankingColumns() {
        super(Patterns.topNRanking());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(Rule.Context context, TopNRankingNode topNRankingNode, Set<Symbol> referencedOutputs) {
        Set requiredInputs = (Set)Streams.concat((Stream[])new Stream[]{referencedOutputs.stream().filter(symbol -> !symbol.equals(topNRankingNode.getRankingSymbol())), topNRankingNode.getPartitionBy().stream(), topNRankingNode.getOrderingScheme().getOrderBy().stream(), topNRankingNode.getHashSymbol().stream()}).collect(ImmutableSet.toImmutableSet());
        return Util.restrictChildOutputs(context.getIdAllocator(), topNRankingNode, requiredInputs);
    }
}

