/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ProjectOffPushDownRule;
import io.trino.sql.planner.iterative.rule.Util;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.WindowNode;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class PruneWindowColumns
extends ProjectOffPushDownRule<WindowNode> {
    public PruneWindowColumns() {
        super(Patterns.window());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(Rule.Context context, WindowNode windowNode, Set<Symbol> referencedOutputs) {
        Map referencedFunctions = Maps.filterKeys(windowNode.getWindowFunctions(), referencedOutputs::contains);
        if (referencedFunctions.isEmpty()) {
            return Optional.of(windowNode.getSource());
        }
        ImmutableSet.Builder referencedInputs = ImmutableSet.builder().addAll(windowNode.getSource().getOutputSymbols().stream().filter(referencedOutputs::contains).iterator()).addAll(windowNode.getPartitionBy());
        windowNode.getOrderingScheme().ifPresent(orderingScheme -> orderingScheme.getOrderBy().forEach(arg_0 -> ((ImmutableSet.Builder)referencedInputs).add(arg_0)));
        windowNode.getHashSymbol().ifPresent(arg_0 -> ((ImmutableSet.Builder)referencedInputs).add(arg_0));
        for (WindowNode.Function windowFunction : referencedFunctions.values()) {
            referencedInputs.addAll(SymbolsExtractor.extractUnique(windowFunction));
        }
        WindowNode prunedWindowNode = new WindowNode(windowNode.getId(), Util.restrictOutputs(context.getIdAllocator(), windowNode.getSource(), (Set<Symbol>)referencedInputs.build()).orElse(windowNode.getSource()), windowNode.getSpecification(), referencedFunctions, windowNode.getHashSymbol(), windowNode.getPrePartitionedInputs(), windowNode.getPreSortedOrderPrefix());
        if (((PlanNode)prunedWindowNode).getOutputSymbols().size() == windowNode.getOutputSymbols().size()) {
            return Optional.empty();
        }
        return Optional.of(prunedWindowNode);
    }
}

