/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.sql.planner.iterative.rule.ExpressionRewriteRuleSet;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.DataType;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.GenericDataType;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.RowDataType;
import java.util.List;

public class PushCastIntoRow
extends ExpressionRewriteRuleSet {
    public PushCastIntoRow() {
        super((expression, context) -> ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Rewriter(), (Expression)expression, (Object)false));
    }

    private static class Rewriter
    extends ExpressionRewriter<Boolean> {
        private Rewriter() {
        }

        public Expression rewriteCast(Cast node, Boolean inRowCast, ExpressionTreeRewriter<Boolean> treeRewriter) {
            Expression value;
            if (!(node.getType() instanceof RowDataType)) {
                return treeRewriter.defaultRewrite((Expression)node, (Object)false);
            }
            RowDataType type = (RowDataType)node.getType();
            if ((inRowCast.booleanValue() || type.getFields().stream().allMatch(field -> field.getName().isEmpty())) && (value = treeRewriter.rewrite(node.getExpression(), (Object)true)) instanceof Row) {
                Row row = (Row)value;
                ImmutableList.Builder items = ImmutableList.builder();
                for (int i = 0; i < row.getItems().size(); ++i) {
                    Expression item = (Expression)row.getItems().get(i);
                    DataType itemType = ((RowDataType.Field)type.getFields().get(i)).getType();
                    if (!(itemType instanceof GenericDataType) || !((GenericDataType)itemType).getName().getValue().equalsIgnoreCase("unknown")) {
                        item = new Cast(item, itemType, node.isSafe(), node.isTypeOnly());
                    }
                    items.add((Object)item);
                }
                return new Row((List)items.build());
            }
            return treeRewriter.defaultRewrite((Expression)node, (Object)true);
        }
    }
}

