/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.optimizations.QueryCardinalityUtil;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.NullLiteral;
import java.util.List;

public class ReplaceRedundantJoinWithProject
implements Rule<JoinNode> {
    private static final Pattern<JoinNode> PATTERN = Patterns.join();

    @Override
    public Pattern<JoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(JoinNode node, Captures captures, Rule.Context context) {
        boolean leftSourceEmpty = QueryCardinalityUtil.isAtMost(node.getLeft(), context.getLookup(), 0L);
        boolean rightSourceEmpty = QueryCardinalityUtil.isAtMost(node.getRight(), context.getLookup(), 0L);
        switch (node.getType()) {
            case INNER: {
                return Rule.Result.empty();
            }
            case LEFT: {
                if (leftSourceEmpty || !rightSourceEmpty) break;
                return Rule.Result.ofPlanNode(ReplaceRedundantJoinWithProject.appendNulls(node.getLeft(), node.getLeftOutputSymbols(), node.getRightOutputSymbols(), context.getIdAllocator(), context.getSymbolAllocator()));
            }
            case RIGHT: {
                if (!leftSourceEmpty || rightSourceEmpty) break;
                return Rule.Result.ofPlanNode(ReplaceRedundantJoinWithProject.appendNulls(node.getRight(), node.getRightOutputSymbols(), node.getLeftOutputSymbols(), context.getIdAllocator(), context.getSymbolAllocator()));
            }
            case FULL: {
                if (leftSourceEmpty && !rightSourceEmpty) {
                    return Rule.Result.ofPlanNode(ReplaceRedundantJoinWithProject.appendNulls(node.getRight(), node.getRightOutputSymbols(), node.getLeftOutputSymbols(), context.getIdAllocator(), context.getSymbolAllocator()));
                }
                if (leftSourceEmpty || !rightSourceEmpty) break;
                return Rule.Result.ofPlanNode(ReplaceRedundantJoinWithProject.appendNulls(node.getLeft(), node.getLeftOutputSymbols(), node.getRightOutputSymbols(), context.getIdAllocator(), context.getSymbolAllocator()));
            }
        }
        return Rule.Result.empty();
    }

    private static ProjectNode appendNulls(PlanNode source, List<Symbol> sourceOutputs, List<Symbol> nullSymbols, PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator) {
        Assignments.Builder assignments = Assignments.builder().putIdentities(sourceOutputs);
        nullSymbols.stream().forEach(symbol -> assignments.put((Symbol)symbol, (Expression)new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType(symbolAllocator.getTypes().get((Symbol)symbol)))));
        return new ProjectNode(idAllocator.getNextId(), source, assignments.build());
    }
}

