/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.rowpattern.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import io.trino.sql.planner.rowpattern.ir.IrRowPatternVisitor;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class IrConcatenation
extends IrRowPattern {
    private final List<IrRowPattern> patterns;

    @JsonCreator
    public IrConcatenation(List<IrRowPattern> patterns) {
        this.patterns = Objects.requireNonNull(patterns, "patterns is null");
        Preconditions.checkArgument((patterns.size() >= 2 ? 1 : 0) != 0, (String)"pattern concatenation must have at least 2 elements (actual: %s)", (int)patterns.size());
    }

    @JsonProperty
    public List<IrRowPattern> getPatterns() {
        return this.patterns;
    }

    @Override
    public <R, C> R accept(IrRowPatternVisitor<R, C> visitor, C context) {
        return visitor.visitIrConcatenation(this, context);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IrConcatenation o = (IrConcatenation)obj;
        return Objects.equals(this.patterns, o.patterns);
    }

    public int hashCode() {
        return Objects.hash(this.patterns);
    }

    public String toString() {
        return this.patterns.stream().map(Object::toString).collect(Collectors.joining(" ", "(", ")"));
    }
}

