/*
 * Decompiled with CFR 0.152.
 */
package io.trino.transaction;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import java.util.UUID;

public final class TransactionId {
    private final UUID uuid;

    private TransactionId(UUID uuid) {
        this.uuid = Objects.requireNonNull(uuid, "uuid is null");
    }

    public static TransactionId create() {
        return new TransactionId(UUID.randomUUID());
    }

    @JsonCreator
    public static TransactionId valueOf(String value) {
        return new TransactionId(UUID.fromString(value));
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TransactionId other = (TransactionId)obj;
        return Objects.equals(this.uuid, other.uuid);
    }

    @JsonValue
    public String toString() {
        return this.uuid.toString();
    }
}

