/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.airlift.jcodings.Encoding;
import io.airlift.jcodings.specific.NonStrictUTF8Encoding;
import io.airlift.joni.Matcher;
import io.airlift.joni.Regex;
import io.airlift.joni.Syntax;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.Chars;
import io.trino.type.JoniRegexp;
import io.trino.util.Failures;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

public final class LikeFunctions {
    public static final String LIKE_PATTERN_FUNCTION_NAME = "$like_pattern";
    private static final Syntax SYNTAX = new Syntax(0x800006, 0, 0, 0, new Syntax.MetaCharTable(92, 0, 0, 0, 0, 0));

    private LikeFunctions() {
    }

    @ScalarFunction(value="like", hidden=true)
    @LiteralParameters(value={"x"})
    @SqlType(value="boolean")
    public static boolean likeChar(@LiteralParameter(value="x") Long x, @SqlType(value="char(x)") Slice value, @SqlType(value="LikePattern") JoniRegexp pattern) {
        return LikeFunctions.likeVarchar(Chars.padSpaces((Slice)value, (int)x.intValue()), pattern);
    }

    @ScalarFunction(value="like", hidden=true)
    @LiteralParameters(value={"x"})
    @SqlType(value="boolean")
    public static boolean likeVarchar(@SqlType(value="varchar(x)") Slice value, @SqlType(value="LikePattern") JoniRegexp pattern) {
        Matcher matcher;
        int offset;
        if (value.hasByteArray()) {
            offset = value.byteArrayOffset();
            matcher = pattern.regex().matcher(value.byteArray(), offset, offset + value.length());
        } else {
            offset = 0;
            matcher = pattern.matcher(value.getBytes());
        }
        return matcher.match(offset, offset + value.length(), 0) != -1;
    }

    @ScalarFunction(value="$like_pattern", hidden=true)
    @LiteralParameters(value={"x"})
    @SqlType(value="LikePattern")
    public static JoniRegexp likePattern(@SqlType(value="varchar(x)") Slice pattern) {
        return LikeFunctions.compileLikePattern(pattern);
    }

    public static JoniRegexp compileLikePattern(Slice pattern) {
        return LikeFunctions.likePattern(pattern.toStringUtf8(), '0', false);
    }

    @ScalarFunction(value="$like_pattern", hidden=true)
    @LiteralParameters(value={"x", "y"})
    @SqlType(value="LikePattern")
    public static JoniRegexp likePattern(@SqlType(value="varchar(x)") Slice pattern, @SqlType(value="varchar(y)") Slice escape) {
        return LikeFunctions.likePattern(pattern.toStringUtf8(), LikeFunctions.getEscapeChar(escape), true);
    }

    public static boolean isLikePattern(Slice pattern, Optional<Slice> escape) {
        return LikeFunctions.patternConstantPrefixBytes(pattern, escape) < pattern.length();
    }

    public static int patternConstantPrefixBytes(Slice pattern, Optional<Slice> escape) {
        int position;
        int currentChar;
        int escapeChar = LikeFunctions.getEscapeCharacter(escape).map(c -> c.charValue()).orElse(-1);
        boolean escaped = false;
        for (position = 0; position < pattern.length(); position += SliceUtf8.lengthOfCodePoint((int)currentChar)) {
            currentChar = SliceUtf8.getCodePointAt((Slice)pattern, (int)position);
            if (!escaped && currentChar == escapeChar) {
                escaped = true;
                continue;
            }
            if (escaped) {
                LikeFunctions.checkEscape(currentChar == 37 || currentChar == 95 || currentChar == escapeChar);
                escaped = false;
                continue;
            }
            if (currentChar != 37 && currentChar != 95) continue;
            return position;
        }
        LikeFunctions.checkEscape(!escaped);
        return position;
    }

    public static Slice unescapeLiteralLikePattern(Slice pattern, Optional<Slice> escape) {
        int lengthOfCodePoint;
        if (escape.isEmpty()) {
            return pattern;
        }
        int escapeChar = LikeFunctions.getEscapeCharacter(escape).map(c -> c.charValue()).orElse(-1);
        DynamicSliceOutput output = new DynamicSliceOutput(pattern.length());
        boolean escaped = false;
        for (int position = 0; position < pattern.length(); position += lengthOfCodePoint) {
            int currentChar = SliceUtf8.getCodePointAt((Slice)pattern, (int)position);
            lengthOfCodePoint = SliceUtf8.lengthOfCodePoint((int)currentChar);
            if (!escaped && currentChar == escapeChar) {
                escaped = true;
                continue;
            }
            output.writeBytes(pattern, position, lengthOfCodePoint);
            escaped = false;
        }
        LikeFunctions.checkEscape(!escaped);
        return output.slice();
    }

    private static Optional<Character> getEscapeCharacter(Optional<Slice> escape) {
        if (escape.isEmpty()) {
            return Optional.empty();
        }
        String stringEscape = escape.get().toStringUtf8();
        Failures.checkCondition(stringEscape.length() == 1, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Escape string must be a single character", new Object[0]);
        return Optional.of(Character.valueOf(stringEscape.charAt(0)));
    }

    private static void checkEscape(boolean condition) {
        Failures.checkCondition(condition, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Escape character must be followed by '%%', '_' or the escape character itself", new Object[0]);
    }

    private static JoniRegexp likePattern(String patternString, char escapeChar, boolean shouldEscape) {
        StringBuilder regex = new StringBuilder(patternString.length() * 2);
        regex.append('^');
        boolean escaped = false;
        block7: for (char currentChar : patternString.toCharArray()) {
            LikeFunctions.checkEscape(!escaped || currentChar == '%' || currentChar == '_' || currentChar == escapeChar);
            if (shouldEscape && !escaped && currentChar == escapeChar) {
                escaped = true;
                continue;
            }
            switch (currentChar) {
                case '%': {
                    regex.append(escaped ? "%" : ".*");
                    escaped = false;
                    continue block7;
                }
                case '_': {
                    regex.append(escaped ? "_" : ".");
                    escaped = false;
                    continue block7;
                }
                default: {
                    switch (currentChar) {
                        case '$': 
                        case '*': 
                        case '.': 
                        case '\\': 
                        case '^': {
                            regex.append('\\');
                        }
                    }
                    regex.append(currentChar);
                    escaped = false;
                }
            }
        }
        LikeFunctions.checkEscape(!escaped);
        regex.append('$');
        byte[] bytes = regex.toString().getBytes(StandardCharsets.UTF_8);
        Regex joniRegex = new Regex(bytes, 0, bytes.length, 4, (Encoding)NonStrictUTF8Encoding.INSTANCE, SYNTAX);
        return new JoniRegexp(Slices.wrappedBuffer((byte[])bytes), joniRegex);
    }

    private static char getEscapeChar(Slice escape) {
        String escapeString = escape.toStringUtf8();
        if (escapeString.isEmpty()) {
            return '\uffff';
        }
        if (escapeString.length() == 1) {
            return escapeString.charAt(0);
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Escape string must be a single character");
    }
}

