/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.EntryProcessor;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.bookkeeper.mledger.util.ManagedLedgerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedLedgerReplayTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ManagedLedgerReplayTask.class);
    private final String name;
    private final Executor executor;
    private final int maxEntriesPerRead;
    private int numEntriesProcessed = 0;

    public CompletableFuture<Optional<Position>> replay(ManagedCursor cursor, EntryProcessor processor) {
        try {
            this.numEntriesProcessed = 0;
            cursor.setAlwaysInactive();
            if (!cursor.hasMoreEntries()) {
                return CompletableFuture.completedFuture(Optional.empty());
            }
            return this.readAndProcess(cursor, null, processor);
        }
        catch (Throwable throwable) {
            return CompletableFuture.failedFuture(throwable);
        }
    }

    private CompletableFuture<Optional<Position>> readAndProcess(ManagedCursor cursor, Position lastProcessedPosition, EntryProcessor processor) {
        return ManagedLedgerUtils.readEntries(cursor, this.maxEntriesPerRead, PositionImpl.LATEST).thenComposeAsync(entries -> {
            try {
                CompletableFuture<Optional<Position>> completableFuture;
                Position processedPosition = lastProcessedPosition;
                for (Entry entry : entries) {
                    Position position = entry.getPosition();
                    ByteBuf buffer = entry.getDataBuffer();
                    try {
                        processor.process(position, buffer);
                    }
                    catch (Throwable throwable) {
                        log.error("[{}] Failed to process entry {}", new Object[]{this.name, position, throwable});
                        CompletableFuture<Optional<Position>> completableFuture2 = CompletableFuture.completedFuture(Optional.ofNullable(processedPosition));
                        entries.forEach(Entry::release);
                        return completableFuture2;
                    }
                    ++this.numEntriesProcessed;
                    processedPosition = position;
                }
                if (cursor.hasMoreEntries()) {
                    completableFuture = this.readAndProcess(cursor, processedPosition, processor);
                    return completableFuture;
                }
                completableFuture = CompletableFuture.completedFuture(Optional.ofNullable(processedPosition));
                return completableFuture;
            }
            finally {
                entries.forEach(Entry::release);
            }
        }, this.executor);
    }

    @Generated
    public ManagedLedgerReplayTask(String name, Executor executor, int maxEntriesPerRead) {
        this.name = name;
        this.executor = executor;
        this.maxEntriesPerRead = maxEntriesPerRead;
    }

    @Generated
    public int getNumEntriesProcessed() {
        return this.numEntriesProcessed;
    }
}

