/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.cli.commands.bookie;

import com.beust.jcommander.Parameter;
import com.google.common.util.concurrent.UncheckedExecutionException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.stream.LongStream;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.proto.BookieClientImpl;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.bookkeeper.util.EntryFormatter;
import org.apache.bookkeeper.util.LedgerIdFormatter;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadLedgerCommand
extends BookieCommand<ReadLedgerFlags> {
    private static final Logger LOG = LoggerFactory.getLogger(ReadLedgerCommand.class);
    private static final String NAME = "readledger";
    private static final String DESC = "Read a range of entries from a ledger.";
    EntryFormatter entryFormatter;
    LedgerIdFormatter ledgerIdFormatter;

    public ReadLedgerCommand() {
        this(new ReadLedgerFlags());
    }

    public ReadLedgerCommand(EntryFormatter entryFormatter, LedgerIdFormatter ledgerIdFormatter) {
        this(new ReadLedgerFlags());
        this.ledgerIdFormatter = ledgerIdFormatter;
        this.entryFormatter = entryFormatter;
    }

    private ReadLedgerCommand(ReadLedgerFlags flags) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags((CliFlags)flags).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, ReadLedgerFlags cmdFlags) {
        if (cmdFlags.ledgerIdFormatter != null && this.ledgerIdFormatter == null) {
            this.ledgerIdFormatter = LedgerIdFormatter.newLedgerIdFormatter(cmdFlags.ledgerIdFormatter, conf);
        } else if (this.ledgerIdFormatter == null) {
            this.ledgerIdFormatter = LedgerIdFormatter.newLedgerIdFormatter(conf);
        }
        if (cmdFlags.entryFormatter != null && this.entryFormatter == null) {
            this.entryFormatter = EntryFormatter.newEntryFormatter(cmdFlags.entryFormatter, conf);
        } else if (this.entryFormatter == null) {
            this.entryFormatter = EntryFormatter.newEntryFormatter(conf);
        }
        try {
            return this.readledger(conf, cmdFlags);
        }
        catch (Exception e) {
            throw new UncheckedExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    private boolean readledger(ServerConfiguration serverConf, ReadLedgerFlags flags) throws InterruptedException, BKException, IOException {
        long lastEntry = flags.lastEntryId;
        BookieId bookie = flags.bookieAddresss != null ? BookieId.parse(flags.bookieAddresss) : null;
        ClientConfiguration conf = new ClientConfiguration();
        conf.addConfiguration((Configuration)serverConf);
        try (BookKeeperAdmin bk = new BookKeeperAdmin(conf);){
            if (flags.forceRecovery) {
                try (LedgerHandle lh = bk.openLedger(flags.ledgerId);){
                    if (lastEntry == -1L || lastEntry > lh.getLastAddConfirmed()) {
                        lastEntry = lh.getLastAddConfirmed();
                    }
                }
            }
            if (bookie == null) {
                for (LedgerEntry entry : bk.readEntries(flags.ledgerId, flags.firstEntryId, lastEntry)) {
                    this.formatEntry(entry, flags.msg);
                }
            } else {
                NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup();
                OrderedExecutor executor = OrderedExecutor.newBuilder().numThreads(1).name("BookieClientScheduler").build();
                ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("BookKeeperClientSchedulerPool"));
                BookieClientImpl bookieClient = new BookieClientImpl(conf, (EventLoopGroup)eventLoopGroup, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, executor, scheduler, (StatsLogger)NullStatsLogger.INSTANCE, bk.getBookieAddressResolver());
                LongStream.range(flags.firstEntryId, lastEntry).forEach(entryId -> {
                    CompletableFuture future = new CompletableFuture();
                    bookieClient.readEntry(bookie, flags.ledgerId, entryId, (rc, ledgerId1, entryId1, buffer, ctx) -> {
                        if (rc != 0) {
                            LOG.error("Failed to read entry {} -- {}", (Object)entryId1, (Object)BKException.getMessage(rc));
                            future.completeExceptionally(BKException.create(rc));
                            return;
                        }
                        LOG.info("--------- Lid={}, Eid={} ---------", (Object)this.ledgerIdFormatter.formatLedgerId(flags.ledgerId), (Object)entryId);
                        if (flags.msg) {
                            LOG.info("Data: " + ByteBufUtil.prettyHexDump((ByteBuf)buffer));
                        }
                        future.complete(null);
                    }, null, 0);
                    try {
                        future.get();
                    }
                    catch (Exception e) {
                        LOG.error("Error future.get while reading entries from ledger {}", (Object)flags.ledgerId, (Object)e);
                    }
                });
                eventLoopGroup.shutdownGracefully();
                executor.shutdown();
                bookieClient.close();
            }
        }
        return true;
    }

    private void formatEntry(LedgerEntry entry, boolean printMsg) {
        long ledgerId = entry.getLedgerId();
        long entryId = entry.getEntryId();
        long entrySize = entry.getLength();
        LOG.info("--------- Lid={}, Eid={}, EntrySize={} ---------", new Object[]{this.ledgerIdFormatter.formatLedgerId(ledgerId), entryId, entrySize});
        if (printMsg) {
            this.entryFormatter.formatEntry(entry.getEntry());
        }
    }

    public static class ReadLedgerFlags
    extends CliFlags {
        @Parameter(names={"-m", "--msg"}, description="Print message body")
        private boolean msg;
        @Parameter(names={"-l", "--ledgerid"}, description="Ledger ID")
        private long ledgerId = -1L;
        @Parameter(names={"-fe", "--firstentryid"}, description="First Entry ID")
        private long firstEntryId = -1L;
        @Parameter(names={"-le", "--lastentryid"}, description="Last Entry ID")
        private long lastEntryId = -1L;
        @Parameter(names={"-r", "--force-recovery"}, description="Ensure the ledger is properly closed before reading")
        private boolean forceRecovery;
        @Parameter(names={"-b", "--bookie"}, description="Only read from a specific bookie")
        private String bookieAddresss;
        @Parameter(names={"-lf", "--ledgeridformatter"}, description="Set ledger id formatter")
        private String ledgerIdFormatter;
        @Parameter(names={"-ef", "--entryformatter"}, description="Set entry formatter")
        private String entryFormatter;

        public ReadLedgerFlags msg(boolean msg) {
            this.msg = msg;
            return this;
        }

        public ReadLedgerFlags ledgerId(long ledgerId) {
            this.ledgerId = ledgerId;
            return this;
        }

        public ReadLedgerFlags firstEntryId(long firstEntryId) {
            this.firstEntryId = firstEntryId;
            return this;
        }

        public ReadLedgerFlags lastEntryId(long lastEntryId) {
            this.lastEntryId = lastEntryId;
            return this;
        }

        public ReadLedgerFlags forceRecovery(boolean forceRecovery) {
            this.forceRecovery = forceRecovery;
            return this;
        }

        public ReadLedgerFlags bookieAddresss(String bookieAddresss) {
            this.bookieAddresss = bookieAddresss;
            return this;
        }

        public ReadLedgerFlags ledgerIdFormatter(String ledgerIdFormatter) {
            this.ledgerIdFormatter = ledgerIdFormatter;
            return this;
        }

        public ReadLedgerFlags entryFormatter(String entryFormatter) {
            this.entryFormatter = entryFormatter;
            return this;
        }
    }
}

