/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="SeccompProfile defines a pod/container's seccomp profile settings. Only one profile source may be set.")
public class V1SeccompProfile {
    public static final String SERIALIZED_NAME_LOCALHOST_PROFILE = "localhostProfile";
    @SerializedName(value="localhostProfile")
    private String localhostProfile;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;

    public V1SeccompProfile localhostProfile(String localhostProfile) {
        this.localhostProfile = localhostProfile;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="localhostProfile indicates a profile defined in a file on the node should be used. The profile must be preconfigured on the node to work. Must be a descending path, relative to the kubelet's configured seccomp profile location. Must only be set if type is \"Localhost\".")
    public String getLocalhostProfile() {
        return this.localhostProfile;
    }

    public void setLocalhostProfile(String localhostProfile) {
        this.localhostProfile = localhostProfile;
    }

    public V1SeccompProfile type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="type indicates which kind of seccomp profile will be applied. Valid options are:  Localhost - a profile defined in a file on the node should be used. RuntimeDefault - the container runtime default profile should be used. Unconfined - no profile should be applied.  ")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1SeccompProfile v1SeccompProfile = (V1SeccompProfile)o;
        return Objects.equals(this.localhostProfile, v1SeccompProfile.localhostProfile) && Objects.equals(this.type, v1SeccompProfile.type);
    }

    public int hashCode() {
        return Objects.hash(this.localhostProfile, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1SeccompProfile {\n");
        sb.append("    localhostProfile: ").append(this.toIndentedString(this.localhostProfile)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

