/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.joni.ast;

import io.airlift.joni.Option;
import io.airlift.joni.ast.Node;
import io.airlift.joni.ast.StateNode;
import io.airlift.joni.constants.EncloseType;

public final class EncloseNode
extends StateNode
implements EncloseType {
    public int type;
    public int regNum;
    public int option;
    public Node target;
    public int callAddr;
    public int minLength;
    public int maxLength;
    public int charLength;
    public int optCount;
    public Node containingAnchor;

    public EncloseNode(int type) {
        this.type = type;
        this.callAddr = -1;
    }

    public EncloseNode(int option, boolean isNamed) {
        this(1);
        if (isNamed) {
            this.setNamedGroup();
        }
        this.option = option;
    }

    public EncloseNode(int option, int _) {
        this(2);
        this.option = option;
    }

    public int getType() {
        return 6;
    }

    protected void setChild(Node newChild) {
        this.target = newChild;
    }

    protected Node getChild() {
        return this.target;
    }

    public void setTarget(Node tgt) {
        this.target = tgt;
        tgt.parent = this;
    }

    public String getName() {
        return "Enclose";
    }

    public String toString(int level) {
        StringBuilder value = new StringBuilder(super.toString(level));
        value.append("\n  type: " + this.typeToString());
        value.append("\n  regNum: " + this.regNum);
        value.append("\n  option: " + Option.toString(this.option));
        value.append("\n  target: " + EncloseNode.pad(this.target, level + 1));
        value.append("\n  callAddr: " + this.callAddr);
        value.append("\n  minLength: " + this.minLength);
        value.append("\n  maxLength: " + this.maxLength);
        value.append("\n  charLength: " + this.charLength);
        value.append("\n  optCount: " + this.optCount);
        return value.toString();
    }

    public String typeToString() {
        StringBuilder types = new StringBuilder();
        if (this.isStopBacktrack()) {
            types.append("STOP_BACKTRACK ");
        }
        if (this.isMemory()) {
            types.append("MEMORY ");
        }
        if (this.isOption()) {
            types.append("OPTION ");
        }
        if (this.isCondition()) {
            types.append("CONDITION ");
        }
        return types.toString();
    }

    public void setEncloseStatus(int flag) {
        this.state |= flag;
    }

    public void clearEncloseStatus(int flag) {
        this.state &= ~flag;
    }

    public boolean isMemory() {
        return (this.type & 1) != 0;
    }

    public boolean isOption() {
        return (this.type & 2) != 0;
    }

    public boolean isCondition() {
        return (this.type & 8) != 0;
    }

    public boolean isStopBacktrack() {
        return (this.type & 4) != 0;
    }
}

