/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.Slice;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import java.util.List;

public abstract class AbstractSingleRowBlock
implements Block {
    protected final int rowIndex;

    protected AbstractSingleRowBlock(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    @Override
    public final List<Block> getChildren() {
        return List.of(this.getRawFieldBlocks());
    }

    abstract Block[] getRawFieldBlocks();

    protected abstract Block getRawFieldBlock(int var1);

    private void checkFieldIndex(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid: " + position);
        }
    }

    @Override
    public boolean isNull(int position) {
        this.checkFieldIndex(position);
        return this.getRawFieldBlock(position).isNull(this.rowIndex);
    }

    @Override
    public byte getByte(int position, int offset) {
        this.checkFieldIndex(position);
        return this.getRawFieldBlock(position).getByte(this.rowIndex, offset);
    }

    @Override
    public short getShort(int position, int offset) {
        this.checkFieldIndex(position);
        return this.getRawFieldBlock(position).getShort(this.rowIndex, offset);
    }

    @Override
    public int getInt(int position, int offset) {
        this.checkFieldIndex(position);
        return this.getRawFieldBlock(position).getInt(this.rowIndex, offset);
    }

    @Override
    public long getLong(int position, int offset) {
        this.checkFieldIndex(position);
        return this.getRawFieldBlock(position).getLong(this.rowIndex, offset);
    }

    @Override
    public Slice getSlice(int position, int offset, int length) {
        this.checkFieldIndex(position);
        return this.getRawFieldBlock(position).getSlice(this.rowIndex, offset, length);
    }

    @Override
    public int getSliceLength(int position) {
        this.checkFieldIndex(position);
        return this.getRawFieldBlock(position).getSliceLength(this.rowIndex);
    }

    @Override
    public int compareTo(int position, int offset, int length, Block otherBlock, int otherPosition, int otherOffset, int otherLength) {
        this.checkFieldIndex(position);
        return this.getRawFieldBlock(position).compareTo(this.rowIndex, offset, length, otherBlock, otherPosition, otherOffset, otherLength);
    }

    @Override
    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        this.checkFieldIndex(position);
        return this.getRawFieldBlock(position).bytesEqual(this.rowIndex, offset, otherSlice, otherOffset, length);
    }

    @Override
    public int bytesCompare(int position, int offset, int length, Slice otherSlice, int otherOffset, int otherLength) {
        this.checkFieldIndex(position);
        return this.getRawFieldBlock(position).bytesCompare(this.rowIndex, offset, length, otherSlice, otherOffset, otherLength);
    }

    @Override
    public void writeBytesTo(int position, int offset, int length, BlockBuilder blockBuilder) {
        this.checkFieldIndex(position);
        this.getRawFieldBlock(position).writeBytesTo(this.rowIndex, offset, length, blockBuilder);
    }

    @Override
    public boolean equals(int position, int offset, Block otherBlock, int otherPosition, int otherOffset, int length) {
        this.checkFieldIndex(position);
        return this.getRawFieldBlock(position).equals(this.rowIndex, offset, otherBlock, otherPosition, otherOffset, length);
    }

    @Override
    public long hash(int position, int offset, int length) {
        this.checkFieldIndex(position);
        return this.getRawFieldBlock(position).hash(this.rowIndex, offset, length);
    }

    @Override
    public <T> T getObject(int position, Class<T> clazz) {
        this.checkFieldIndex(position);
        return this.getRawFieldBlock(position).getObject(this.rowIndex, clazz);
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.checkFieldIndex(position);
        this.getRawFieldBlock(position).writePositionTo(this.rowIndex, blockBuilder);
    }

    @Override
    public Block getSingleValueBlock(int position) {
        this.checkFieldIndex(position);
        return this.getRawFieldBlock(position).getSingleValueBlock(this.rowIndex);
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        this.checkFieldIndex(position);
        return this.getRawFieldBlock(position).getEstimatedDataSizeForStats(this.rowIndex);
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getPositionsSizeInBytes(boolean[] positions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block copyRegion(int position, int length) {
        throw new UnsupportedOperationException();
    }
}

