/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

public class Constraint {
    private final TupleDomain<ColumnHandle> summary;
    private final Optional<Predicate<Map<ColumnHandle, NullableValue>>> predicate;
    private final Optional<Set<ColumnHandle>> predicateColumns;

    public static Constraint alwaysTrue() {
        return new Constraint(TupleDomain.all());
    }

    public static Constraint alwaysFalse() {
        return new Constraint(TupleDomain.none(), bindings -> false, Set.of());
    }

    public Constraint(TupleDomain<ColumnHandle> summary) {
        this(summary, Optional.empty(), Optional.empty());
    }

    public Constraint(TupleDomain<ColumnHandle> summary, Predicate<Map<ColumnHandle, NullableValue>> predicate, Set<ColumnHandle> predicateColumns) {
        this(summary, Optional.of(predicate), Optional.of(predicateColumns));
    }

    private Constraint(TupleDomain<ColumnHandle> summary, Optional<Predicate<Map<ColumnHandle, NullableValue>>> predicate, Optional<Set<ColumnHandle>> predicateColumns) {
        this.summary = Objects.requireNonNull(summary, "summary is null");
        this.predicate = Objects.requireNonNull(predicate, "predicate is null");
        this.predicateColumns = Objects.requireNonNull(predicateColumns, "predicateColumns is null");
        if (predicateColumns.isPresent() && predicate.isEmpty()) {
            throw new IllegalArgumentException("predicateColumns cannot be present when predicate is not present");
        }
        if (predicateColumns.isEmpty() && predicate.isPresent()) {
            throw new IllegalArgumentException("predicate cannot be present without predicateColumns");
        }
    }

    public TupleDomain<ColumnHandle> getSummary() {
        return this.summary;
    }

    public Optional<Predicate<Map<ColumnHandle, NullableValue>>> predicate() {
        return this.predicate;
    }

    public Optional<Set<ColumnHandle>> getPredicateColumns() {
        return this.predicateColumns;
    }
}

