/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.protocol;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import lombok.Generated;

public final class FrameDecoderUtil {
    public static final String FRAME_DECODER_HANDLER = "frameDecoder";

    public static void addFrameDecoder(ChannelPipeline pipeline, int maxMessageSize) {
        pipeline.addLast(FRAME_DECODER_HANDLER, (ChannelHandler)FrameDecoderUtil.createFrameDecoder(maxMessageSize));
    }

    public static void replaceFrameDecoder(ChannelPipeline pipeline, int maxMessageSize) {
        pipeline.replace(FRAME_DECODER_HANDLER, FRAME_DECODER_HANDLER, (ChannelHandler)FrameDecoderUtil.createFrameDecoder(maxMessageSize));
    }

    public static void removeFrameDecoder(ChannelPipeline pipeline) {
        pipeline.remove(FRAME_DECODER_HANDLER);
    }

    private static LengthFieldBasedFrameDecoder createFrameDecoder(int maxMessageSize) {
        return new LengthFieldBasedFrameDecoder(maxMessageSize + 10240, 0, 4, 0, 4);
    }

    @Generated
    private FrameDecoderUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

