/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.config.v1;

import com.alibaba.fastjson2.JSON;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.config.ConfigRocksDBStorage;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.DataVersion;
import org.rocksdb.CompressionType;
import org.rocksdb.FlushOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.Statistics;
import org.rocksdb.WriteBatch;

public class RocksDBConfigManager {
    protected static final Logger BROKER_LOG = LoggerFactory.getLogger((String)"RocketmqBroker");
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    public ConfigRocksDBStorage configRocksDBStorage = null;
    private FlushOptions flushOptions = null;
    private volatile long lastFlushMemTableMicroSecond = 0L;
    private final String filePath;
    private final long memTableFlushInterval;
    private final CompressionType compressionType;
    private DataVersion kvDataVersion = new DataVersion();
    public static final byte[] KV_DATA_VERSION_COLUMN_FAMILY_NAME = "kvDataVersion".getBytes(CHARSET);
    public static final byte[] KV_DATA_VERSION_KEY = "kvDataVersionKey".getBytes(CHARSET);
    private final String defaultCF;
    private final String versionCF;

    public RocksDBConfigManager(String filePath, long memTableFlushInterval, CompressionType compressionType, String defaultCF, String versionCF) {
        this.filePath = filePath;
        this.memTableFlushInterval = memTableFlushInterval;
        this.compressionType = compressionType;
        this.defaultCF = defaultCF;
        this.versionCF = versionCF;
    }

    public RocksDBConfigManager(String filePath, long memTableFlushInterval, CompressionType compressionType) {
        this.filePath = filePath;
        this.memTableFlushInterval = memTableFlushInterval;
        this.compressionType = compressionType;
        this.defaultCF = new String(RocksDB.DEFAULT_COLUMN_FAMILY, CHARSET);
        this.versionCF = new String(KV_DATA_VERSION_COLUMN_FAMILY_NAME, CHARSET);
    }

    public boolean init(boolean readOnly) {
        this.configRocksDBStorage = ConfigRocksDBStorage.getStore((String)this.filePath, (boolean)readOnly, (CompressionType)this.compressionType);
        return this.configRocksDBStorage.start();
    }

    public boolean isLoaded() {
        return this.configRocksDBStorage != null && this.configRocksDBStorage.isLoaded();
    }

    public boolean init() {
        return this.init(false);
    }

    public boolean loadDataVersion() {
        String currDataVersionString = null;
        try {
            byte[] dataVersion = this.configRocksDBStorage.get(this.versionCF, KV_DATA_VERSION_KEY);
            if (dataVersion != null && dataVersion.length > 0) {
                currDataVersionString = new String(dataVersion, StandardCharsets.UTF_8);
            }
            this.kvDataVersion = StringUtils.isNotBlank(currDataVersionString) ? (DataVersion)JSON.parseObject(currDataVersionString, DataVersion.class) : new DataVersion();
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean loadData(BiConsumer<byte[], byte[]> biConsumer) {
        try {
            this.configRocksDBStorage.iterate(this.defaultCF, biConsumer);
        }
        catch (Exception e) {
            BROKER_LOG.error("RocksDBConfigManager loadData failed", (Throwable)e);
            return false;
        }
        this.flushOptions = new FlushOptions();
        this.flushOptions.setWaitForFlush(false);
        this.flushOptions.setAllowWriteStall(false);
        return true;
    }

    public void start() {
    }

    public boolean stop() {
        ConfigRocksDBStorage.shutdown((String)this.filePath);
        if (this.flushOptions != null) {
            this.flushOptions.close();
        }
        return true;
    }

    public void flushWAL() {
        try {
            if (!this.isLoaded()) {
                return;
            }
            if (this.configRocksDBStorage != null) {
                this.configRocksDBStorage.flushWAL();
                long now = System.currentTimeMillis();
                if (now > this.lastFlushMemTableMicroSecond + this.memTableFlushInterval) {
                    this.configRocksDBStorage.flush(this.flushOptions);
                    this.lastFlushMemTableMicroSecond = now;
                }
            }
        }
        catch (Exception e) {
            BROKER_LOG.error("kv flush WAL Failed.", (Throwable)e);
        }
    }

    public void put(byte[] keyBytes, byte[] valueBytes) throws Exception {
        this.configRocksDBStorage.put(this.defaultCF, keyBytes, keyBytes.length, valueBytes);
    }

    public void put(String cf, String key, String value) throws Exception {
        byte[] keyBytes = key.getBytes(CHARSET);
        this.configRocksDBStorage.put(cf, keyBytes, keyBytes.length, value.getBytes(CHARSET));
    }

    public void put(String cf, byte[] keyBytes, byte[] valueBytes) throws Exception {
        this.configRocksDBStorage.put(cf, keyBytes, keyBytes.length, valueBytes);
    }

    public void delete(byte[] keyBytes) throws Exception {
        this.configRocksDBStorage.delete(this.defaultCF, keyBytes);
    }

    public void updateKvDataVersion() throws Exception {
        this.kvDataVersion.nextVersion();
        this.configRocksDBStorage.put(this.versionCF, KV_DATA_VERSION_KEY, KV_DATA_VERSION_KEY.length, JSON.toJSONString((Object)this.kvDataVersion).getBytes(StandardCharsets.UTF_8));
    }

    public DataVersion getKvDataVersion() {
        return this.kvDataVersion;
    }

    public void writeBatchPutOperation(WriteBatch writeBatch, byte[] key, byte[] value) throws RocksDBException {
        this.configRocksDBStorage.writeBatchPutOperation(this.defaultCF, writeBatch, key, value);
    }

    public void batchPutWithWal(WriteBatch batch) throws Exception {
        this.configRocksDBStorage.batchPutWithWal(batch);
    }

    public Statistics getStatistics() {
        if (this.configRocksDBStorage == null) {
            return null;
        }
        return this.configRocksDBStorage.getStatistics();
    }
}

