/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.app.common.EngineType;
import org.apache.seatunnel.app.dal.dao.IJobDefinitionDao;
import org.apache.seatunnel.app.dal.dao.IJobTaskDao;
import org.apache.seatunnel.app.dal.dao.IJobVersionDao;
import org.apache.seatunnel.app.dal.entity.JobDefinition;
import org.apache.seatunnel.app.dal.entity.JobTask;
import org.apache.seatunnel.app.dal.entity.JobVersion;
import org.apache.seatunnel.app.domain.request.job.DataSourceOption;
import org.apache.seatunnel.app.domain.request.job.JobReq;
import org.apache.seatunnel.app.domain.response.PageInfo;
import org.apache.seatunnel.app.domain.response.job.JobDefinitionRes;
import org.apache.seatunnel.app.service.IJobDefinitionService;
import org.apache.seatunnel.app.service.impl.SeatunnelBaseServiceImpl;
import org.apache.seatunnel.common.constants.JobMode;
import org.apache.seatunnel.server.common.CodeGenerateUtils;
import org.apache.seatunnel.server.common.SeatunnelErrorEnum;
import org.apache.seatunnel.server.common.SeatunnelException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JobDefinitionServiceImpl
extends SeatunnelBaseServiceImpl
implements IJobDefinitionService {
    private static final String DEFAULT_VERSION = "1.0";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @Resource(name="jobDefinitionDaoImpl")
    private IJobDefinitionDao jobDefinitionDao;
    @Resource(name="jobTaskDaoImpl")
    private IJobTaskDao jobTaskDao;
    @Resource(name="jobVersionDaoImpl")
    private IJobVersionDao jobVersionDao;

    @Override
    @Transactional
    public long createJob(int userId, JobReq jobReq) throws CodeGenerateUtils.CodeGenerateException {
        this.funcPermissionCheck("project:seatunnel-task:create", userId);
        long uuid = CodeGenerateUtils.getInstance().genCode();
        this.jobDefinitionDao.add(JobDefinition.builder().id(uuid).name(jobReq.getName()).description(jobReq.getDescription()).createUserId(userId).updateUserId(userId).jobType(jobReq.getJobType().name()).build());
        this.jobVersionDao.createVersion(JobVersion.builder().jobId(uuid).createUserId(userId).updateUserId(userId).name(DEFAULT_VERSION).id(uuid).engineName(EngineType.SeaTunnel.name()).jobMode(JobMode.BATCH.name()).engineVersion("2.3.0").build());
        return uuid;
    }

    @Override
    public PageInfo<JobDefinitionRes> getJob(String name, Integer pageNo, Integer pageSize) {
        return this.getJob(name, pageNo, pageSize, null);
    }

    @Override
    public PageInfo<JobDefinitionRes> getJob(String searchName, Integer pageNo, Integer pageSize, String jobMode) {
        this.funcPermissionCheck("project:seatunnel-task:view", 0);
        if (StringUtils.isNotEmpty((CharSequence)jobMode)) {
            try {
                JobMode.valueOf((String)jobMode);
            }
            catch (Exception e) {
                throw new SeatunnelException(SeatunnelErrorEnum.ILLEGAL_STATE, new Object[]{"Unsupported JobMode"});
            }
        }
        PageInfo<JobDefinition> jobDefinitionPageInfo = this.jobDefinitionDao.getJob(searchName, pageNo, pageSize, jobMode);
        List userIds = jobDefinitionPageInfo.getData().stream().map(JobDefinition::getCreateUserId).collect(Collectors.toList());
        userIds.addAll(jobDefinitionPageInfo.getData().stream().map(JobDefinition::getUpdateUserId).collect(Collectors.toList()));
        ArrayList<JobDefinitionRes> jobDefinitionResList = new ArrayList<JobDefinitionRes>();
        for (int i = 0; i < jobDefinitionPageInfo.getData().size(); ++i) {
            JobDefinition jobDefinition = jobDefinitionPageInfo.getData().get(i);
            JobDefinitionRes jobDefinitionRes = new JobDefinitionRes();
            jobDefinitionRes.setId(jobDefinition.getId());
            jobDefinitionRes.setName(jobDefinition.getName());
            jobDefinitionRes.setDescription(jobDefinition.getDescription());
            jobDefinitionRes.setJobType(jobDefinition.getJobType());
            jobDefinitionRes.setCreateUserId(jobDefinition.getCreateUserId());
            jobDefinitionRes.setUpdateUserId(jobDefinitionRes.getUpdateUserId());
            jobDefinitionRes.setCreateTime(jobDefinition.getCreateTime());
            jobDefinitionRes.setUpdateTime(jobDefinition.getUpdateTime());
            jobDefinitionResList.add(jobDefinitionRes);
        }
        PageInfo<JobDefinitionRes> pageInfo = new PageInfo<JobDefinitionRes>();
        pageInfo.setPageNo(jobDefinitionPageInfo.getPageNo());
        pageInfo.setPageSize(jobDefinitionPageInfo.getPageSize());
        pageInfo.setTotalCount(jobDefinitionPageInfo.getTotalCount());
        pageInfo.setData(jobDefinitionResList);
        return pageInfo;
    }

    @Override
    public Map<Long, String> getJob(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.funcPermissionCheck("project:seatunnel-task:view", 0);
        List<JobDefinition> job = this.jobDefinitionDao.getJobList(name);
        if (CollectionUtils.isEmpty(job)) {
            return new HashMap<Long, String>();
        }
        HashMap<Long, String> jobDefineMap = new HashMap<Long, String>();
        job.forEach(jobDefine -> jobDefineMap.put(jobDefine.getId(), jobDefine.getName()));
        return jobDefineMap;
    }

    @Override
    public JobDefinition getJobDefinitionByJobId(long jobId) {
        this.funcPermissionCheck("project:seatunnel-task:detail", 0);
        return this.jobDefinitionDao.getJob(jobId);
    }

    @Override
    public List<JobVersion> getJobVersionByDataSourceId(long datasourceId) {
        List<Long> versionIds = this.jobTaskDao.getJobTaskByDataSourceId(datasourceId).stream().map(JobTask::getVersionId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(versionIds)) {
            return new ArrayList<JobVersion>();
        }
        return this.jobVersionDao.getVersionsByIds(versionIds);
    }

    @Override
    public boolean getUsedByDataSourceIdAndVirtualTable(long datasourceId, String tableName) {
        List options = this.jobTaskDao.getJobTaskByDataSourceId(datasourceId).stream().map(JobTask::getDataSourceOption).distinct().map(option -> {
            try {
                return StringUtils.isEmpty((CharSequence)option) ? null : (DataSourceOption)OBJECT_MAPPER.readValue(option, DataSourceOption.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return options.stream().anyMatch(option -> option.getTables().contains(tableName));
    }

    @Override
    public void deleteJob(long id) {
        this.funcPermissionCheck("project:seatunnel-task:delete", 0);
        this.jobDefinitionDao.delete(id);
    }
}

