/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.thirdparty.framework;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.source.SupportColumnProjection;
import org.apache.seatunnel.api.table.factory.FactoryUtil;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.app.domain.response.connector.ConnectorFeature;
import org.apache.seatunnel.app.domain.response.connector.ConnectorInfo;
import org.apache.seatunnel.app.dynamicforms.FormStructure;
import org.apache.seatunnel.app.thirdparty.framework.SeaTunnelOptionRuleWrapper;
import org.apache.seatunnel.common.config.Common;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.utils.FileUtils;
import org.apache.seatunnel.plugin.discovery.AbstractPluginDiscovery;
import org.apache.seatunnel.plugin.discovery.PluginIdentifier;
import org.apache.seatunnel.plugin.discovery.seatunnel.SeaTunnelSinkPluginDiscovery;

public class PluginDiscoveryUtil {
    public static List<ConnectorInfo> getAllConnectorsFromPluginMapping(PluginType pluginType) {
        Map plugins = AbstractPluginDiscovery.getAllSupportedPlugins((PluginType)pluginType);
        ArrayList<ConnectorInfo> connectorInfos = new ArrayList<ConnectorInfo>();
        plugins.forEach((plugin, artifactId) -> connectorInfos.add(new ConnectorInfo((PluginIdentifier)plugin, (String)artifactId)));
        return connectorInfos;
    }

    public static Map<PluginIdentifier, ConnectorFeature> getConnectorFeatures(PluginType pluginType) throws IOException {
        List factories;
        Common.setStarter((boolean)true);
        if (!pluginType.equals((Object)PluginType.SOURCE)) {
            throw new UnsupportedOperationException("ONLY support plugin type source");
        }
        Path path = new SeaTunnelSinkPluginDiscovery().getPluginDir();
        if (path.toFile().exists()) {
            List files = FileUtils.searchJarFiles((Path)path);
            factories = FactoryUtil.discoverFactories((ClassLoader)new URLClassLoader(files.toArray(new URL[0])));
        } else {
            factories = FactoryUtil.discoverFactories((ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        ConcurrentHashMap<PluginIdentifier, ConnectorFeature> featureMap = new ConcurrentHashMap<PluginIdentifier, ConnectorFeature>();
        factories.forEach(plugin -> {
            if (TableSourceFactory.class.isAssignableFrom(plugin.getClass())) {
                TableSourceFactory tableSourceFactory = (TableSourceFactory)plugin;
                PluginIdentifier info = PluginIdentifier.of((String)"seatunnel", (String)PluginType.SOURCE.getType(), (String)plugin.factoryIdentifier());
                featureMap.put(info, new ConnectorFeature(SupportColumnProjection.class.isAssignableFrom(tableSourceFactory.getSourceClass())));
            }
        });
        return featureMap;
    }

    public static List<ConnectorInfo> getDownloadedConnectors(@NonNull Map<PluginType, LinkedHashMap<PluginIdentifier, OptionRule>> allPlugins, @NonNull PluginType pluginType) throws IOException {
        if (allPlugins == null) {
            throw new NullPointerException("allPlugins is marked non-null but is null");
        }
        if (pluginType == null) {
            throw new NullPointerException("pluginType is marked non-null but is null");
        }
        LinkedHashMap<PluginIdentifier, OptionRule> pluginIdentifierOptionRuleLinkedHashMap = allPlugins.get(pluginType);
        if (pluginIdentifierOptionRuleLinkedHashMap == null) {
            return new ArrayList<ConnectorInfo>();
        }
        ArrayList<ConnectorInfo> connectorInfos = new ArrayList<ConnectorInfo>();
        pluginIdentifierOptionRuleLinkedHashMap.forEach((plugin, optionRule) -> connectorInfos.add(new ConnectorInfo((PluginIdentifier)plugin, null)));
        return connectorInfos;
    }

    public static List<ConnectorInfo> getTransforms(@NonNull Map<PluginType, LinkedHashMap<PluginIdentifier, OptionRule>> allPlugins) throws IOException {
        if (allPlugins == null) {
            throw new NullPointerException("allPlugins is marked non-null but is null");
        }
        LinkedHashMap<PluginIdentifier, OptionRule> pluginIdentifierOptionRuleLinkedHashMap = allPlugins.get(PluginType.TRANSFORM);
        if (pluginIdentifierOptionRuleLinkedHashMap == null) {
            return new ArrayList<ConnectorInfo>();
        }
        return pluginIdentifierOptionRuleLinkedHashMap.keySet().stream().map(t -> new ConnectorInfo((PluginIdentifier)t, null)).collect(Collectors.toList());
    }

    public static Map<PluginType, LinkedHashMap<PluginIdentifier, OptionRule>> getAllConnectors() throws IOException {
        return new SeaTunnelSinkPluginDiscovery().getAllPlugin();
    }

    public static ConcurrentMap<String, FormStructure> getDownloadedConnectorFormStructures(@NonNull Map<PluginType, LinkedHashMap<PluginIdentifier, OptionRule>> allPlugins, @NonNull PluginType pluginType) {
        if (allPlugins == null) {
            throw new NullPointerException("allPlugins is marked non-null but is null");
        }
        if (pluginType == null) {
            throw new NullPointerException("pluginType is marked non-null but is null");
        }
        LinkedHashMap<PluginIdentifier, OptionRule> pluginIdentifierOptionRuleLinkedHashMap = allPlugins.get(pluginType);
        ConcurrentHashMap<String, FormStructure> result = new ConcurrentHashMap<String, FormStructure>();
        if (pluginIdentifierOptionRuleLinkedHashMap == null) {
            return result;
        }
        pluginIdentifierOptionRuleLinkedHashMap.forEach((key, value) -> result.put(key.getPluginName(), SeaTunnelOptionRuleWrapper.wrapper(value, key.getPluginName(), pluginType)));
        return result;
    }

    public static ConcurrentMap<String, FormStructure> getTransformFormStructures(Map<PluginType, LinkedHashMap<PluginIdentifier, OptionRule>> allPlugins) {
        return PluginDiscoveryUtil.getDownloadedConnectorFormStructures(allPlugins, PluginType.TRANSFORM);
    }
}

