/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.thirdparty.framework;

import java.math.BigDecimal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.SingleChoiceOption;
import org.apache.seatunnel.api.configuration.util.Expression;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.configuration.util.RequiredOption;
import org.apache.seatunnel.app.common.SeaTunnelConnectorI18n;
import org.apache.seatunnel.app.dynamicforms.AbstractFormOption;
import org.apache.seatunnel.app.dynamicforms.FormLocale;
import org.apache.seatunnel.app.dynamicforms.FormOptionBuilder;
import org.apache.seatunnel.app.dynamicforms.FormStructure;
import org.apache.seatunnel.app.dynamicforms.FormStructureBuilder;
import org.apache.seatunnel.app.dynamicforms.validate.AbstractValidate;
import org.apache.seatunnel.app.dynamicforms.validate.ValidateBuilder;
import org.apache.seatunnel.app.thirdparty.framework.FormOptionSort;
import org.apache.seatunnel.app.thirdparty.framework.UnSupportWrapperException;
import org.apache.seatunnel.common.constants.PluginType;

public class SeaTunnelOptionRuleWrapper {
    public static FormStructure wrapper(@NonNull OptionRule optionRule, @NonNull String connectorName, @NonNull PluginType pluginType) {
        if (optionRule == null) {
            throw new NullPointerException("optionRule is marked non-null but is null");
        }
        if (connectorName == null) {
            throw new NullPointerException("connectorName is marked non-null but is null");
        }
        if (pluginType == null) {
            throw new NullPointerException("pluginType is marked non-null but is null");
        }
        return SeaTunnelOptionRuleWrapper.wrapper(optionRule.getOptionalOptions(), optionRule.getRequiredOptions(), connectorName + "[" + pluginType.getType() + "]");
    }

    public static FormStructure wrapper(@NonNull List<Option<?>> optionList, @NonNull List<RequiredOption> requiredList, @NonNull String connectorName, @NonNull PluginType pluginType) {
        if (optionList == null) {
            throw new NullPointerException("optionList is marked non-null but is null");
        }
        if (requiredList == null) {
            throw new NullPointerException("requiredList is marked non-null but is null");
        }
        if (connectorName == null) {
            throw new NullPointerException("connectorName is marked non-null but is null");
        }
        if (pluginType == null) {
            throw new NullPointerException("pluginType is marked non-null but is null");
        }
        return SeaTunnelOptionRuleWrapper.wrapper(optionList, requiredList, connectorName + "[" + pluginType.getType() + "]");
    }

    public static FormStructure wrapper(@NonNull OptionRule optionRule, @NonNull String name) {
        if (optionRule == null) {
            throw new NullPointerException("optionRule is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return SeaTunnelOptionRuleWrapper.wrapper(optionRule.getOptionalOptions(), optionRule.getRequiredOptions(), name);
    }

    public static FormStructure wrapper(@NonNull List<Option<?>> optionList, @NonNull List<RequiredOption> requiredList, @NonNull String name) {
        if (optionList == null) {
            throw new NullPointerException("optionList is marked non-null but is null");
        }
        if (requiredList == null) {
            throw new NullPointerException("requiredList is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        FormLocale locale = new FormLocale();
        List<AbstractFormOption> optionFormOptions = SeaTunnelOptionRuleWrapper.wrapperOptionOptions(name, optionList, locale);
        List<List<AbstractFormOption>> requiredFormOptions = SeaTunnelOptionRuleWrapper.wrapperRequiredOptions(name, requiredList, locale);
        FormStructureBuilder formStructureBuilder = FormStructure.builder().name(name);
        if (!CollectionUtils.isEmpty(requiredFormOptions)) {
            requiredFormOptions.forEach(list -> {
                if (CollectionUtils.isEmpty((Collection)list)) {
                    return;
                }
                formStructureBuilder.addFormOption(list.toArray(new AbstractFormOption[1]));
            });
        }
        if (!CollectionUtils.isEmpty(optionFormOptions)) {
            formStructureBuilder.addFormOption(optionFormOptions.toArray(new AbstractFormOption[1]));
        }
        formStructureBuilder.withLocale(locale);
        return FormOptionSort.sortFormStructure(formStructureBuilder.build());
    }

    private static List<AbstractFormOption> wrapperOptionOptions(@NonNull String connectorName, @NonNull List<Option<?>> optionList, FormLocale locale) {
        if (connectorName == null) {
            throw new NullPointerException("connectorName is marked non-null but is null");
        }
        if (optionList == null) {
            throw new NullPointerException("optionList is marked non-null but is null");
        }
        return optionList.stream().map(option -> SeaTunnelOptionRuleWrapper.wrapperToFormOption(connectorName, option, locale)).collect(Collectors.toList());
    }

    private static List<List<AbstractFormOption>> wrapperRequiredOptions(@NonNull String connectorName, @NonNull List<RequiredOption> requiredList, FormLocale locale) {
        if (connectorName == null) {
            throw new NullPointerException("connectorName is marked non-null but is null");
        }
        if (requiredList == null) {
            throw new NullPointerException("requiredList is marked non-null but is null");
        }
        List<List<AbstractFormOption>> formOptionsList = requiredList.stream().map(option -> {
            if (option instanceof RequiredOption.AbsolutelyRequiredOptions) {
                List collect = ((RequiredOption.AbsolutelyRequiredOptions)option).getRequiredOption().stream().map(requiredOption -> SeaTunnelOptionRuleWrapper.wrapperToFormOption(connectorName, requiredOption, locale).withValidate((AbstractValidate)ValidateBuilder.builder().nonEmptyValidateBuilder().nonEmptyValidate())).collect(Collectors.toList());
                return collect;
            }
            if (option instanceof RequiredOption.BundledRequiredOptions) {
                List bundledRequiredOptions = ((RequiredOption.BundledRequiredOptions)option).getRequiredOption();
                List bundledFields = bundledRequiredOptions.stream().map(requiredOption -> requiredOption.key()).collect(Collectors.toList());
                List collect = bundledRequiredOptions.stream().map(requiredOption -> {
                    AbstractFormOption bundledRequiredFormOption = SeaTunnelOptionRuleWrapper.wrapperToFormOption(connectorName, requiredOption, locale);
                    bundledRequiredFormOption.withValidate((AbstractValidate)ValidateBuilder.builder().unionNonEmptyValidateBuilder().fields(bundledFields.toArray(new String[1])).unionNonEmptyValidate());
                    return bundledRequiredFormOption;
                }).collect(Collectors.toList());
                return collect;
            }
            if (option instanceof RequiredOption.ExclusiveRequiredOptions) {
                List exclusiveOptions = ((RequiredOption.ExclusiveRequiredOptions)option).getExclusiveOptions();
                List exclusiveFields = exclusiveOptions.stream().map(requiredOption -> requiredOption.key()).collect(Collectors.toList());
                List collect = exclusiveOptions.stream().map(requiredOption -> {
                    AbstractFormOption exclusiveRequiredFormOption = SeaTunnelOptionRuleWrapper.wrapperToFormOption(connectorName, requiredOption, locale).withValidate((AbstractValidate)ValidateBuilder.builder().mutuallyExclusiveValidateBuilder().fields(exclusiveFields.toArray(new String[1])).mutuallyExclusiveValidate());
                    return exclusiveRequiredFormOption;
                }).collect(Collectors.toList());
                return collect;
            }
            if (option instanceof RequiredOption.ConditionalRequiredOptions) {
                RequiredOption.ConditionalRequiredOptions conditionalRequiredOptions = (RequiredOption.ConditionalRequiredOptions)option;
                String conditionKey = conditionalRequiredOptions.getExpression().getCondition().getOption().key();
                ArrayList<String> expectValueList = new ArrayList<String>();
                Expression expression = conditionalRequiredOptions.getExpression();
                expectValueList.add(expression.getCondition().getExpectValue().toString());
                while (expression.hasNext()) {
                    expression = expression.getNext();
                    expectValueList.add(expression.getCondition().getExpectValue().toString());
                }
                List collect = conditionalRequiredOptions.getRequiredOption().stream().map(requiredOption -> SeaTunnelOptionRuleWrapper.wrapperToFormOption(connectorName, requiredOption, locale).withShow(conditionKey, expectValueList).withValidate((AbstractValidate)ValidateBuilder.builder().nonEmptyValidateBuilder().nonEmptyValidate())).collect(Collectors.toList());
                return collect;
            }
            throw new UnSupportWrapperException(connectorName, "Unknown", option.toString());
        }).collect(Collectors.toList());
        return formOptionsList;
    }

    private static AbstractFormOption wrapperToFormOption(@NonNull String connectorName, @NonNull Option<?> option, @NonNull FormLocale locale) {
        if (connectorName == null) {
            throw new NullPointerException("connectorName is marked non-null but is null");
        }
        if (option == null) {
            throw new NullPointerException("option is marked non-null but is null");
        }
        if (locale == null) {
            throw new NullPointerException("locale is marked non-null but is null");
        }
        if (Boolean.class.equals((Object)option.typeReference().getType())) {
            return SeaTunnelOptionRuleWrapper.selectInput(connectorName, option, Arrays.asList(new ImmutablePair((Object)"true", (Object)true), new ImmutablePair((Object)"false", (Object)false)), locale);
        }
        if (Double.class.equals((Object)option.typeReference().getType()) || Duration.class.equals((Object)option.typeReference().getType()) || Float.class.equals((Object)option.typeReference().getType()) || Integer.class.equals((Object)option.typeReference().getType()) || Long.class.equals((Object)option.typeReference().getType()) || BigDecimal.class.equals((Object)option.typeReference().getType()) || String.class.equals((Object)option.typeReference().getType())) {
            if (option.key().toLowerCase(Locale.ROOT).equals("password")) {
                return SeaTunnelOptionRuleWrapper.passwordInput(connectorName, option, locale);
            }
            if (option.defaultValue() != null && option.defaultValue().toString().contains("\n")) {
                return SeaTunnelOptionRuleWrapper.textareaInput(connectorName, option, locale);
            }
            return SeaTunnelOptionRuleWrapper.textInput(connectorName, option, locale);
        }
        if (option.typeReference().getType().getTypeName().startsWith("java.util.List") || option.typeReference().getType().getTypeName().startsWith("java.util.Map") || option.typeReference().getType().getTypeName().startsWith("org.apache.seatunnel.api.configuration.Options")) {
            return SeaTunnelOptionRuleWrapper.textareaInput(connectorName, option, locale);
        }
        if (SingleChoiceOption.class.isAssignableFrom(option.getClass())) {
            List optionValues = ((SingleChoiceOption)option).getOptionValues();
            List<ImmutablePair> staticSelectOptions = optionValues.stream().map(o -> new ImmutablePair((Object)o.toString(), (Object)o.toString())).collect(Collectors.toList());
            return SeaTunnelOptionRuleWrapper.selectInput(connectorName, option, staticSelectOptions, locale);
        }
        if (((Class)option.typeReference().getType()).isEnum()) {
            T[] enumConstants = ((Class)option.typeReference().getType()).getEnumConstants();
            List<ImmutablePair> staticSelectOptions = Arrays.stream(enumConstants).map(o -> new ImmutablePair((Object)o.toString(), (Object)o.toString())).collect(Collectors.toList());
            return SeaTunnelOptionRuleWrapper.selectInput(connectorName, option, staticSelectOptions, locale);
        }
        if (((Class)option.typeReference().getType()).getTypeName().startsWith("org.apache.seatunnel")) {
            return SeaTunnelOptionRuleWrapper.textareaInput(connectorName, option, locale);
        }
        throw new UnSupportWrapperException(connectorName, option.key(), option.typeReference().getType().getTypeName());
    }

    private static boolean enableLabelI18n(String connectorName, String optionI18nKey, FormLocale locale) {
        String realConnectorName = connectorName;
        if (connectorName.contains("[")) {
            realConnectorName = connectorName.substring(0, connectorName.indexOf("["));
        }
        boolean labelEnableI18n = false;
        if (SeaTunnelConnectorI18n.CONNECTOR_I18N_CONFIG_ZH.hasPath(realConnectorName) && SeaTunnelConnectorI18n.CONNECTOR_I18N_CONFIG_ZH.getConfig(realConnectorName).hasPath(optionI18nKey)) {
            locale.addZhCN(optionI18nKey, SeaTunnelConnectorI18n.CONNECTOR_I18N_CONFIG_ZH.getConfig(realConnectorName).getString(optionI18nKey));
            labelEnableI18n = true;
        }
        if (SeaTunnelConnectorI18n.CONNECTOR_I18N_CONFIG_EN.hasPath(realConnectorName) && SeaTunnelConnectorI18n.CONNECTOR_I18N_CONFIG_EN.getConfig(realConnectorName).hasPath(optionI18nKey)) {
            locale.addEnUS(optionI18nKey, SeaTunnelConnectorI18n.CONNECTOR_I18N_CONFIG_EN.getConfig(realConnectorName).getString(optionI18nKey));
            labelEnableI18n = true;
        }
        return labelEnableI18n;
    }

    private static AbstractFormOption selectInput(String connectorName, @NonNull Option<?> option, List<ImmutablePair> staticSelectOptions, FormLocale locale) {
        if (option == null) {
            throw new NullPointerException("option is marked non-null but is null");
        }
        FormOptionBuilder builder = FormOptionBuilder.builder();
        String i18nOptionKey = option.key().replace(".", "_").replace("-", "_");
        builder = SeaTunnelOptionRuleWrapper.enableLabelI18n(connectorName, i18nOptionKey, locale) ? builder.withI18nLabel(i18nOptionKey) : builder.withLabel(option.key());
        FormOptionBuilder.StaticSelectOptionBuilder staticSelectOptionBuilder = builder.withField(option.key()).staticSelectOptionBuilder();
        for (ImmutablePair selectOption : staticSelectOptions) {
            if (SeaTunnelOptionRuleWrapper.enableLabelI18n(connectorName, selectOption.getLeft().toString(), locale)) {
                staticSelectOptionBuilder.addI18nSelectOptions(new ImmutablePair[]{selectOption});
                continue;
            }
            staticSelectOptionBuilder.addSelectOptions(new ImmutablePair[]{selectOption});
        }
        AbstractFormOption abstractFormOption = staticSelectOptionBuilder.formStaticSelectOption().withDefaultValue(option.defaultValue() == null ? null : option.defaultValue().toString());
        String placeholderI18nOptionKey = i18nOptionKey + "_description";
        abstractFormOption = SeaTunnelOptionRuleWrapper.enableLabelI18n(connectorName, placeholderI18nOptionKey, locale) ? abstractFormOption.withI18nPlaceholder(placeholderI18nOptionKey) : abstractFormOption.withPlaceholder(option.getDescription());
        return abstractFormOption;
    }

    private static AbstractFormOption passwordInput(String connectorName, @NonNull Option<?> option, FormLocale locale) {
        if (option == null) {
            throw new NullPointerException("option is marked non-null but is null");
        }
        FormOptionBuilder builder = FormOptionBuilder.builder();
        String i18nOptionKey = option.key().replace(".", "_").replace("-", "_");
        builder = SeaTunnelOptionRuleWrapper.enableLabelI18n(connectorName, i18nOptionKey, locale) ? builder.withI18nLabel(i18nOptionKey) : builder.withLabel(option.key());
        AbstractFormOption abstractFormOption = builder.withField(option.key()).inputOptionBuilder().formPasswordInputOption().withDefaultValue(option.defaultValue());
        String placeholderI18nOptionKey = i18nOptionKey + "_description";
        abstractFormOption = SeaTunnelOptionRuleWrapper.enableLabelI18n(connectorName, placeholderI18nOptionKey, locale) ? abstractFormOption.withI18nPlaceholder(placeholderI18nOptionKey) : abstractFormOption.withPlaceholder(option.getDescription());
        return abstractFormOption;
    }

    private static AbstractFormOption textInput(String connectorName, @NonNull Option<?> option, FormLocale locale) {
        if (option == null) {
            throw new NullPointerException("option is marked non-null but is null");
        }
        FormOptionBuilder builder = FormOptionBuilder.builder();
        String i18nOptionKey = option.key().replace(".", "_").replace("-", "_");
        String placeholderI18nOptionKey = i18nOptionKey + "_description";
        builder = SeaTunnelOptionRuleWrapper.enableLabelI18n(connectorName, i18nOptionKey, locale) ? builder.withI18nLabel(i18nOptionKey) : builder.withLabel(option.key());
        AbstractFormOption abstractFormOption = builder.withField(option.key()).inputOptionBuilder().formTextInputOption().withDefaultValue(option.defaultValue());
        abstractFormOption = SeaTunnelOptionRuleWrapper.enableLabelI18n(connectorName, placeholderI18nOptionKey, locale) ? abstractFormOption.withI18nPlaceholder(placeholderI18nOptionKey) : abstractFormOption.withPlaceholder(option.getDescription());
        return abstractFormOption;
    }

    private static AbstractFormOption textareaInput(String connectorName, @NonNull Option<?> option, FormLocale locale) {
        if (option == null) {
            throw new NullPointerException("option is marked non-null but is null");
        }
        FormOptionBuilder builder = FormOptionBuilder.builder();
        String i18nOptionKey = option.key().replace(".", "_").replace("-", "_");
        String placeholderI18nOptionKey = i18nOptionKey + "_description";
        builder = SeaTunnelOptionRuleWrapper.enableLabelI18n(connectorName, i18nOptionKey, locale) ? builder.withI18nLabel(i18nOptionKey) : builder.withLabel(option.key());
        AbstractFormOption abstractFormOption = builder.withField(option.key()).inputOptionBuilder().formTextareaInputOption().withClearable().withDefaultValue(option.defaultValue());
        abstractFormOption = SeaTunnelOptionRuleWrapper.enableLabelI18n(connectorName, placeholderI18nOptionKey, locale) ? abstractFormOption.withI18nPlaceholder(placeholderI18nOptionKey) : abstractFormOption.withPlaceholder(option.getDescription());
        return abstractFormOption;
    }
}

