/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Objects;
import org.apache.seatunnel.shade.com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.AnnotationIntrospector;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.BeanProperty;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JavaType;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ser.std.CollectionSerializer;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ser.std.StdSerializer;

public abstract class StaticListSerializerBase<T extends Collection<?>>
extends StdSerializer<T>
implements ContextualSerializer {
    protected final Boolean _unwrapSingle;

    protected StaticListSerializerBase(Class<?> cls) {
        super(cls, false);
        this._unwrapSingle = null;
    }

    protected StaticListSerializerBase(StaticListSerializerBase<?> src, Boolean unwrapSingle) {
        super(src);
        this._unwrapSingle = unwrapSingle;
    }

    public abstract JsonSerializer<?> _withResolved(BeanProperty var1, Boolean var2);

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializers, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value format2;
        JsonSerializer<Object> ser = null;
        Boolean unwrapSingle = null;
        if (property != null) {
            Object serDef;
            AnnotationIntrospector intr = serializers.getAnnotationIntrospector();
            AnnotatedMember m3 = property.getMember();
            if (m3 != null && (serDef = intr.findContentSerializer(m3)) != null) {
                ser = serializers.serializerInstance(m3, serDef);
            }
        }
        if ((format2 = this.findFormatOverrides(serializers, property, this.handledType())) != null) {
            unwrapSingle = format2.getFeature(JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
        }
        if ((ser = this.findContextualConvertingSerializer(serializers, property, ser)) == null) {
            ser = serializers.findContentValueSerializer(String.class, property);
        }
        if (this.isDefaultSerializer(ser)) {
            if (Objects.equals(unwrapSingle, this._unwrapSingle)) {
                return this;
            }
            return this._withResolved(property, unwrapSingle);
        }
        return new CollectionSerializer(serializers.constructType((Type)((Object)String.class)), true, null, ser);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, T value) {
        return value == null || value.size() == 0;
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("array", true).set("items", this.contentSchema());
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            this.acceptContentVisitor(v2);
        }
    }

    protected abstract JsonNode contentSchema();

    protected abstract void acceptContentVisitor(JsonArrayFormatVisitor var1) throws JsonMappingException;

    @Override
    public abstract void serializeWithType(T var1, JsonGenerator var2, SerializerProvider var3, TypeSerializer var4) throws IOException;
}

