/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.app.domain.request.connector.BusinessMode;
import org.apache.seatunnel.app.domain.request.job.Edge;
import org.apache.seatunnel.app.domain.request.job.JobConfig;
import org.apache.seatunnel.app.domain.request.job.JobCreateReq;
import org.apache.seatunnel.app.domain.request.job.JobDAG;
import org.apache.seatunnel.app.domain.request.job.JobReq;
import org.apache.seatunnel.app.domain.request.job.JobTaskInfo;
import org.apache.seatunnel.app.domain.request.job.PluginConfig;
import org.apache.seatunnel.app.domain.response.job.JobConfigRes;
import org.apache.seatunnel.app.domain.response.job.JobRes;
import org.apache.seatunnel.app.service.IJobConfigService;
import org.apache.seatunnel.app.service.IJobDefinitionService;
import org.apache.seatunnel.app.service.IJobService;
import org.apache.seatunnel.app.service.IJobTaskService;
import org.apache.seatunnel.common.constants.JobMode;
import org.apache.seatunnel.server.common.CodeGenerateUtils;
import org.apache.seatunnel.server.common.ParamValidationException;
import org.apache.seatunnel.server.common.SeatunnelErrorEnum;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JobServiceImpl
implements IJobService {
    @Resource
    private IJobDefinitionService jobService;
    @Resource
    private IJobTaskService jobTaskService;
    @Resource
    private IJobConfigService jobConfigService;

    @Override
    @Transactional
    public long createJob(int userId, JobCreateReq jobCreateRequest) throws JsonProcessingException {
        JobReq jobDefinition = this.getJobDefinition(jobCreateRequest.getJobConfig());
        long jobId = this.jobService.createJob(userId, jobDefinition);
        List<PluginConfig> pluginConfig = jobCreateRequest.getPluginConfigs();
        HashMap<String, String> pluginNameVsPluginId = new HashMap<String, String>();
        if (pluginConfig != null) {
            for (PluginConfig config : pluginConfig) {
                String pluginId = String.valueOf(CodeGenerateUtils.getInstance().genCode());
                config.setPluginId(pluginId);
                this.jobTaskService.saveSingleTask(jobId, config);
                pluginNameVsPluginId.put(config.getName(), pluginId);
            }
        }
        this.jobConfigService.updateJobConfig(userId, jobId, jobCreateRequest.getJobConfig());
        JobDAG jobDAG = jobCreateRequest.getJobDAG();
        List<Edge> edges = jobDAG.getEdges();
        for (Edge edge : edges) {
            edge.setInputPluginId((String)pluginNameVsPluginId.get(edge.getInputPluginId()));
            edge.setTargetPluginId((String)pluginNameVsPluginId.get(edge.getTargetPluginId()));
        }
        this.jobTaskService.saveJobDAG(jobId, jobDAG);
        return jobId;
    }

    private JobReq getJobDefinition(JobConfig jobConfig) {
        JobReq jobReq;
        block6: {
            jobReq = new JobReq();
            if (StringUtils.isEmpty((CharSequence)jobConfig.getName())) {
                throw new ParamValidationException(SeatunnelErrorEnum.PARAM_CAN_NOT_BE_NULL, new Object[]{"name"});
            }
            jobReq.setName(jobConfig.getName());
            if (StringUtils.isEmpty((CharSequence)jobConfig.getDescription())) {
                throw new ParamValidationException(SeatunnelErrorEnum.PARAM_CAN_NOT_BE_NULL, new Object[]{"description"});
            }
            jobReq.setDescription(jobConfig.getDescription());
            try {
                JobMode jobMode = JobMode.valueOf((String)((String)jobConfig.getEnv().get("job.mode")));
                if (JobMode.BATCH == jobMode) {
                    jobReq.setJobType(BusinessMode.DATA_INTEGRATION);
                    break block6;
                }
                if (JobMode.STREAMING == jobMode) {
                    jobReq.setJobType(BusinessMode.DATA_REPLICA);
                    break block6;
                }
                throw new ParamValidationException(SeatunnelErrorEnum.INVALID_PARAM, new Object[]{"job.mode", "job.mode should be either BATCH or STREAMING"});
            }
            catch (Exception e) {
                throw new ParamValidationException(SeatunnelErrorEnum.INVALID_PARAM, new Object[]{"job.mode", "job.mode should be either BATCH or STREAMING"});
            }
        }
        return jobReq;
    }

    @Override
    public void updateJob(Integer userId, long jobVersionId, JobCreateReq jobCreateReq) throws JsonProcessingException {
        this.jobConfigService.updateJobConfig(userId, jobVersionId, jobCreateReq.getJobConfig());
        List<PluginConfig> pluginConfigs = jobCreateReq.getPluginConfigs();
        if (pluginConfigs != null) {
            for (PluginConfig pluginConfig : pluginConfigs) {
                this.jobTaskService.saveSingleTask(jobVersionId, pluginConfig);
            }
        }
        this.jobTaskService.saveJobDAG(jobVersionId, jobCreateReq.getJobDAG());
    }

    @Override
    public JobRes getJob(Integer userId, long jobVersionId) throws JsonProcessingException {
        JobConfigRes jobConfig = this.jobConfigService.getJobConfig(jobVersionId);
        JobTaskInfo taskConfig = this.jobTaskService.getTaskConfig(jobVersionId);
        return new JobRes(jobConfig, taskConfig.getPlugins(), new JobDAG(taskConfig.getEdges()));
    }
}

