/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.util.RebaseDateTime$;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.package$;
import org.apache.spark.util.Utils$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

public final class GeoDataSourceUtils$ {
    public static final GeoDataSourceUtils$ MODULE$ = new GeoDataSourceUtils$();
    private static final String PARQUET_REBASE_MODE_IN_READ = MODULE$.firstAvailableConf((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"spark.sql.parquet.datetimeRebaseModeInRead", "spark.sql.legacy.parquet.datetimeRebaseModeInRead"}));
    private static final String PARQUET_REBASE_MODE_IN_WRITE = MODULE$.firstAvailableConf((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"spark.sql.parquet.datetimeRebaseModeInWrite", "spark.sql.legacy.parquet.datetimeRebaseModeInWrite"}));
    private static final String PARQUET_INT96_REBASE_MODE_IN_READ = MODULE$.firstAvailableConf((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"spark.sql.parquet.int96RebaseModeInRead", "spark.sql.legacy.parquet.int96RebaseModeInRead", "spark.sql.legacy.parquet.datetimeRebaseModeInRead"}));
    private static final String PARQUET_INT96_REBASE_MODE_IN_WRITE = MODULE$.firstAvailableConf((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"spark.sql.parquet.int96RebaseModeInWrite", "spark.sql.legacy.parquet.int96RebaseModeInWrite", "spark.sql.legacy.parquet.datetimeRebaseModeInWrite"}));

    public String PARQUET_REBASE_MODE_IN_READ() {
        return PARQUET_REBASE_MODE_IN_READ;
    }

    public String PARQUET_REBASE_MODE_IN_WRITE() {
        return PARQUET_REBASE_MODE_IN_WRITE;
    }

    public String PARQUET_INT96_REBASE_MODE_IN_READ() {
        return PARQUET_INT96_REBASE_MODE_IN_READ;
    }

    public String PARQUET_INT96_REBASE_MODE_IN_WRITE() {
        return PARQUET_INT96_REBASE_MODE_IN_WRITE;
    }

    private String firstAvailableConf(Seq<String> confs) {
        return (String)confs.find((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)GeoDataSourceUtils$.$anonfun$firstAvailableConf$1(c))).get();
    }

    public Enumeration.Value datetimeRebaseMode(Function1<String, String> lookupFileMeta, String modeByConfig) {
        if (Utils$.MODULE$.isTesting()) {
            String string = SQLConf$.MODULE$.get().getConfString("spark.test.forceNoRebase", "");
            String string2 = "true";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
            }
        }
        return (Enumeration.Value)Option$.MODULE$.apply(lookupFileMeta.apply((Object)package$.MODULE$.SPARK_VERSION_METADATA_KEY())).map((Function1 & Serializable)version -> {
            if (StringOps$.MODULE$.$less$extension(Predef$.MODULE$.augmentString(version), "3.0.0") || lookupFileMeta.apply((Object)"org.apache.spark.legacyDateTime") != null) {
                return SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
            }
            return SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
        }).getOrElse((Function0 & Serializable)() -> SQLConf.LegacyBehaviorPolicy$.MODULE$.withName(modeByConfig));
    }

    public Enumeration.Value int96RebaseMode(Function1<String, String> lookupFileMeta, String modeByConfig) {
        if (Utils$.MODULE$.isTesting()) {
            String string = SQLConf$.MODULE$.get().getConfString("spark.test.forceNoRebase", "");
            String string2 = "true";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
            }
        }
        return (Enumeration.Value)Option$.MODULE$.apply(lookupFileMeta.apply((Object)package$.MODULE$.SPARK_VERSION_METADATA_KEY())).map((Function1 & Serializable)version -> {
            if (StringOps$.MODULE$.$less$extension(Predef$.MODULE$.augmentString(version), "3.1.0") || lookupFileMeta.apply((Object)"org.apache.spark.legacyINT96") != null) {
                return SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
            }
            return SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
        }).getOrElse((Function0 & Serializable)() -> SQLConf.LegacyBehaviorPolicy$.MODULE$.withName(modeByConfig));
    }

    public Function1<Object, Object> creteDateRebaseFuncInRead(Enumeration.Value rebaseMode, String format) {
        Enumeration.Value value = rebaseMode;
        Enumeration.Value value2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return (JFunction1.mcII.sp & Serializable)days -> {
                if (days < RebaseDateTime$.MODULE$.lastSwitchJulianDay()) {
                    throw DataSourceUtils$.MODULE$.newRebaseExceptionInRead(format);
                }
                return days;
            };
        }
        Enumeration.Value value4 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return (JFunction1.mcII.sp & Serializable)days -> RebaseDateTime$.MODULE$.rebaseJulianToGregorianDays(days);
        }
        Enumeration.Value value6 = SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return (JFunction1.mcII.sp & Serializable)x -> BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)x)));
        }
        throw new MatchError((Object)value);
    }

    public Function1<Object, Object> creteDateRebaseFuncInWrite(Enumeration.Value rebaseMode, String format) {
        Enumeration.Value value = rebaseMode;
        Enumeration.Value value2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return (JFunction1.mcII.sp & Serializable)days -> {
                if (days < RebaseDateTime$.MODULE$.lastSwitchGregorianDay()) {
                    throw DataSourceUtils$.MODULE$.newRebaseExceptionInWrite(format);
                }
                return days;
            };
        }
        Enumeration.Value value4 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return (JFunction1.mcII.sp & Serializable)days -> RebaseDateTime$.MODULE$.rebaseGregorianToJulianDays(days);
        }
        Enumeration.Value value6 = SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return (JFunction1.mcII.sp & Serializable)x -> BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)x)));
        }
        throw new MatchError((Object)value);
    }

    public Function1<Object, Object> creteTimestampRebaseFuncInRead(Enumeration.Value rebaseMode, String format) {
        Enumeration.Value value = rebaseMode;
        Enumeration.Value value2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return (JFunction1.mcJJ.sp & Serializable)micros -> {
                if (micros < RebaseDateTime$.MODULE$.lastSwitchJulianTs()) {
                    throw DataSourceUtils$.MODULE$.newRebaseExceptionInRead(format);
                }
                return micros;
            };
        }
        Enumeration.Value value4 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return (JFunction1.mcJJ.sp & Serializable)micros -> RebaseDateTime$.MODULE$.rebaseJulianToGregorianMicros(micros);
        }
        Enumeration.Value value6 = SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return (JFunction1.mcJJ.sp & Serializable)x -> BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToLong((long)x)));
        }
        throw new MatchError((Object)value);
    }

    public Function1<Object, Object> creteTimestampRebaseFuncInWrite(Enumeration.Value rebaseMode, String format) {
        Enumeration.Value value = rebaseMode;
        Enumeration.Value value2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return (JFunction1.mcJJ.sp & Serializable)micros -> {
                if (micros < RebaseDateTime$.MODULE$.lastSwitchGregorianTs()) {
                    throw DataSourceUtils$.MODULE$.newRebaseExceptionInWrite(format);
                }
                return micros;
            };
        }
        Enumeration.Value value4 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return (JFunction1.mcJJ.sp & Serializable)micros -> RebaseDateTime$.MODULE$.rebaseGregorianToJulianMicros(micros);
        }
        Enumeration.Value value6 = SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return (JFunction1.mcJJ.sp & Serializable)x -> BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToLong((long)x)));
        }
        throw new MatchError((Object)value);
    }

    public static final /* synthetic */ boolean $anonfun$firstAvailableConf$1(String c) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> SQLConf$.MODULE$.get().getConfString(c)).isSuccess();
    }

    private GeoDataSourceUtils$() {
    }
}

