/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.sql.datasources.osmpbf.extractors;

import java.util.HashMap;
import org.apache.sedona.sql.datasources.osmpbf.build.Osmformat;
import org.apache.sedona.sql.datasources.osmpbf.features.TagsResolver;
import org.apache.sedona.sql.datasources.osmpbf.model.Relation;
import org.apache.sedona.sql.datasources.osmpbf.model.RelationType;

public class RelationExtractor {
    Osmformat.PrimitiveGroup primitiveGroup;
    Osmformat.StringTable stringTable;

    public RelationExtractor(Osmformat.PrimitiveGroup primitiveGroup, Osmformat.StringTable stringTable) {
        this.primitiveGroup = primitiveGroup;
        this.stringTable = stringTable;
    }

    public Relation extract(int idx) {
        Osmformat.Relation relation = this.primitiveGroup.getRelations(idx);
        return this.parse(relation);
    }

    private Relation parse(Osmformat.Relation relation) {
        if (relation == null) {
            return null;
        }
        long[] refs = this.resolveMemberIds(relation);
        String[] refTypes = this.resolveTypes(relation);
        String[] roles = this.resolveRefRoles(relation);
        HashMap<String, String> tags = TagsResolver.resolveTags(relation.getKeysCount(), relation::getKeys, relation::getVals, this.stringTable);
        return new Relation((Long)relation.getId(), tags, refs, refTypes, roles);
    }

    private String[] resolveRefRoles(Osmformat.Relation relation) {
        String[] roles = new String[relation.getRolesSidCount()];
        for (int i = 0; i < relation.getRolesSidCount(); ++i) {
            int role = relation.getRolesSid(i);
            roles[i] = this.stringTable.getS(role).toStringUtf8();
        }
        return roles;
    }

    private long[] resolveMemberIds(Osmformat.Relation relation) {
        long[] memberIds = new long[relation.getMemidsCount()];
        if (relation.getMemidsCount() != 0) {
            long firstId;
            memberIds[0] = firstId = relation.getMemids(0);
            for (int i = 1; i < relation.getMemidsCount(); ++i) {
                memberIds[i] = relation.getMemids(i) + firstId;
            }
        }
        return memberIds;
    }

    private String[] resolveTypes(Osmformat.Relation relation) {
        String[] types = new String[relation.getTypesCount()];
        for (int i = 0; i < relation.getTypesCount(); ++i) {
            Osmformat.Relation.MemberType memberType = relation.getTypes(i);
            types[i] = RelationType.fromValue(memberType.getNumber());
        }
        return types;
    }
}

