/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetOutputCommitter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.codec.CodecConfig;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.RebaseDateTime;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetFileFormatBase;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetMetaData;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetMetaData$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetSpatialFilter;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetUtils$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFilters;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFooterReader;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOutputWriter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetRowIndexUtil$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t-b\u0001\u0002\f\u0018\u0001\u0019B\u0001\u0002\u0012\u0001\u0003\u0006\u0004%\t!\u0012\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\r\")Q\n\u0001C\u0001\u001d\")Q\n\u0001C\u0001#\")!\u000b\u0001C!'\")A\f\u0001C!;\")\u0011\r\u0001C!E\")a\u000e\u0001C\u0001_\")\u0011\u000f\u0001C!e\"9\u0011\u0011\u0007\u0001\u0005B\u0005M\u0002bBA+\u0001\u0011\u0005\u0013q\u000b\u0005\b\u0003C\u0003A\u0011IAR\u0011\u001d\ty\u000b\u0001C!\u0003c;q!!/\u0018\u0011\u0003\tYL\u0002\u0004\u0017/!\u0005\u0011Q\u0018\u0005\u0007\u001b>!\t!!2\t\u000f\u0005\u001dw\u0002\"\u0001\u0002J\"9\u00111[\b\u0005\n\u0005U\u0007b\u0002B\u0003\u001f\u0011%!q\u0001\u0005\b\u0005#yA\u0011\u0002B\n\u0011%\u0011YbDA\u0001\n\u0013\u0011iB\u0001\u000bHK>\u0004\u0016M]9vKR4\u0015\u000e\\3G_Jl\u0017\r\u001e\u0006\u00031e\tq\u0001]1scV,GO\u0003\u0002\u001b7\u0005YA-\u0019;bg>,(oY3t\u0015\taR$A\u0005fq\u0016\u001cW\u000f^5p]*\u0011adH\u0001\u0004gFd'B\u0001\u0011\"\u0003\u0015\u0019\b/\u0019:l\u0015\t\u00113%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002I\u0005\u0019qN]4\u0004\u0001M9\u0001aJ\u0016/ear\u0004C\u0001\u0015*\u001b\u00059\u0012B\u0001\u0016\u0018\u0005E\u0001\u0016M]9vKR4\u0015\u000e\\3G_Jl\u0017\r\u001e\t\u0003Q1J!!L\f\u00031\u001d+w\u000eU1scV,GOR5mK\u001a{'/\\1u\u0005\u0006\u001cX\r\u0005\u00020a5\t\u0011$\u0003\u000223\tQa)\u001b7f\r>\u0014X.\u0019;\u0011\u0005M2T\"\u0001\u001b\u000b\u0005Uj\u0012aB:pkJ\u001cWm]\u0005\u0003oQ\u0012!\u0003R1uCN{WO]2f%\u0016<\u0017n\u001d;feB\u0011\u0011\bP\u0007\u0002u)\u00111hH\u0001\tS:$XM\u001d8bY&\u0011QH\u000f\u0002\b\u0019><w-\u001b8h!\ty$)D\u0001A\u0015\u0005\t\u0015!B:dC2\f\u0017BA\"A\u00051\u0019VM]5bY&T\u0018M\u00197f\u00035\u0019\b/\u0019;jC24\u0015\u000e\u001c;feV\ta\tE\u0002@\u000f&K!\u0001\u0013!\u0003\r=\u0003H/[8o!\tA#*\u0003\u0002L/\t9r)Z8QCJ\fX/\u001a;Ta\u0006$\u0018.\u00197GS2$XM]\u0001\u000fgB\fG/[1m\r&dG/\u001a:!\u0003\u0019a\u0014N\\5u}Q\u0011q\n\u0015\t\u0003Q\u0001AQ\u0001R\u0002A\u0002\u0019#\u0012aT\u0001\u0007KF,\u0018\r\\:\u0015\u0005Q;\u0006CA V\u0013\t1\u0006IA\u0004C_>dW-\u00198\t\u000ba+\u0001\u0019A-\u0002\u000b=$\b.\u001a:\u0011\u0005}R\u0016BA.A\u0005\r\te._\u0001\tQ\u0006\u001c\bnQ8eKR\ta\f\u0005\u0002@?&\u0011\u0001\r\u0011\u0002\u0004\u0013:$\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003\r\u0004\"\u0001Z6\u000f\u0005\u0015L\u0007C\u00014A\u001b\u00059'B\u00015&\u0003\u0019a$o\\8u}%\u0011!\u000eQ\u0001\u0007!J,G-\u001a4\n\u00051l'AB*ue&twM\u0003\u0002k\u0001\u0006)r/\u001b;i'B\fG/[1m!J,G-[2bi\u0016\u001cHCA(q\u0011\u0015!\u0005\u00021\u0001J\u0003-IgNZ3s'\u000eDW-\\1\u0015\rMT\u0018\u0011AA\u0006!\ryt\t\u001e\t\u0003kbl\u0011A\u001e\u0006\u0003ov\tQ\u0001^=qKNL!!\u001f<\u0003\u0015M#(/^2u)f\u0004X\rC\u0003|\u0013\u0001\u0007A0\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002~}6\tQ$\u0003\u0002\u0000;\ta1\u000b]1sWN+7o]5p]\"9\u00111A\u0005A\u0002\u0005\u0015\u0011A\u00039be\u0006lW\r^3sgB)A-a\u0002dG&\u0019\u0011\u0011B7\u0003\u00075\u000b\u0007\u000fC\u0004\u0002\u000e%\u0001\r!a\u0004\u0002\u000b\u0019LG.Z:\u0011\r\u0005E\u00111DA\u0011\u001d\u0011\t\u0019\"a\u0006\u000f\u0007\u0019\f)\"C\u0001B\u0013\r\tI\u0002Q\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti\"a\b\u0003\u0007M+\u0017OC\u0002\u0002\u001a\u0001\u0003B!a\t\u0002.5\u0011\u0011Q\u0005\u0006\u0005\u0003O\tI#\u0001\u0002gg*\u0019\u00111F\u0011\u0002\r!\fGm\\8q\u0013\u0011\ty#!\n\u0003\u0015\u0019KG.Z*uCR,8/\u0001\u0007qe\u0016\u0004\u0018M]3Xe&$X\r\u0006\u0006\u00026\u0005m\u0012QHA'\u0003#\u00022aLA\u001c\u0013\r\tI$\u0007\u0002\u0014\u001fV$\b/\u001e;Xe&$XM\u001d$bGR|'/\u001f\u0005\u0006w*\u0001\r\u0001 \u0005\b\u0003\u007fQ\u0001\u0019AA!\u0003\rQwN\u0019\t\u0005\u0003\u0007\nI%\u0004\u0002\u0002F)!\u0011qIA\u0015\u0003%i\u0017\r\u001d:fIV\u001cW-\u0003\u0003\u0002L\u0005\u0015#a\u0001&pE\"9\u0011q\n\u0006A\u0002\u0005\u0015\u0011aB8qi&|gn\u001d\u0005\u0007\u0003'R\u0001\u0019\u0001;\u0002\u0015\u0011\fG/Y*dQ\u0016l\u0017-\u0001\u0010ck&dGMU3bI\u0016\u0014x+\u001b;i!\u0006\u0014H/\u001b;j_:4\u0016\r\\;fgR\u0001\u0012\u0011LA<\u0003s\nY(a \u0002\u0004\u0006=\u0015\u0011\u0013\t\b\u007f\u0005m\u0013qLA3\u0013\r\ti\u0006\u0011\u0002\n\rVt7\r^5p]F\u00022aLA1\u0013\r\t\u0019'\u0007\u0002\u0010!\u0006\u0014H/\u001b;j_:,GMR5mKB1\u0011\u0011CA4\u0003WJA!!\u001b\u0002 \tA\u0011\n^3sCR|'\u000f\u0005\u0003\u0002n\u0005MTBAA8\u0015\r\t\t(H\u0001\tG\u0006$\u0018\r\\=ti&!\u0011QOA8\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u000bm\\\u0001\u0019\u0001?\t\r\u0005M3\u00021\u0001u\u0011\u0019\tih\u0003a\u0001i\u0006y\u0001/\u0019:uSRLwN\\*dQ\u0016l\u0017\r\u0003\u0004\u0002\u0002.\u0001\r\u0001^\u0001\u000fe\u0016\fX/\u001b:fIN\u001b\u0007.Z7b\u0011\u001d\t)i\u0003a\u0001\u0003\u000f\u000bqAZ5mi\u0016\u00148\u000f\u0005\u0004\u0002\u0012\u0005m\u0011\u0011\u0012\t\u0004g\u0005-\u0015bAAGi\t1a)\u001b7uKJDq!a\u0014\f\u0001\u0004\t)\u0001C\u0004\u0002\u0014.\u0001\r!!&\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u0003\u0002\u0018\u0006uUBAAM\u0015\u0011\tY*!\u000b\u0002\t\r|gNZ\u0005\u0005\u0003?\u000bIJA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u0010gV\u0004\bo\u001c:u\t\u0006$\u0018\rV=qKR\u0019A+!*\t\u000f\u0005\u001dF\u00021\u0001\u0002*\u0006AA-\u0019;b)f\u0004X\rE\u0002v\u0003WK1!!,w\u0005!!\u0015\r^1UsB,\u0017\u0001D:vaB|'\u000f\u001e\"bi\u000eDG#\u0002+\u00024\u0006U\u0006\"B>\u000e\u0001\u0004a\bBBA\\\u001b\u0001\u0007A/\u0001\u0004tG\",W.Y\u0001\u0015\u000f\u0016|\u0007+\u0019:rk\u0016$h)\u001b7f\r>\u0014X.\u0019;\u0011\u0005!z1#B\b\u0002@br\u0004cA \u0002B&\u0019\u00111\u0019!\u0003\r\u0005s\u0017PU3g)\t\tY,\u0001\fnKJ<WmU2iK6\f7/\u00138QCJ\fG\u000e\\3m)\u001d\u0019\u00181ZAg\u0003#Dq!a\u0001\u0012\u0001\u0004\t)\u0001C\u0004\u0002PF\u0001\r!a\u0004\u0002\u0019\u0019LG.Z:U_R{Wo\u00195\t\u000bm\f\u0002\u0019\u0001?\u0002)I,\u0017\rZ*dQ\u0016l\u0017M\u0012:p[\u001a{w\u000e^3s)%!\u0018q[At\u0003s\u0014\u0019\u0001C\u0004\u0002ZJ\u0001\r!a7\u0002\r\u0019|w\u000e^3s!\u0011\ti.a9\u000e\u0005\u0005}'\u0002BA\u0016\u0003CT!\u0001G\u0011\n\t\u0005\u0015\u0018q\u001c\u0002\u0007\r>|G/\u001a:\t\u000f\u0005%(\u00031\u0001\u0002l\u0006\u00012.Z=WC2,X-T3uC\u0012\u000bG/\u0019\t\u0007\u0003[\f9pY2\u000e\u0005\u0005=(\u0002BAy\u0003g\fA!\u001e;jY*\u0011\u0011Q_\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\n\u0005=\bbBA~%\u0001\u0007\u0011Q`\u0001\nG>tg/\u001a:uKJ\u00042\u0001KA\u0000\u0013\r\u0011\ta\u0006\u0002!\u000f\u0016|\u0007+\u0019:rk\u0016$Hk\\*qCJ\\7k\u00195f[\u0006\u001cuN\u001c<feR,'\u000fC\u0004\u0002\u0004I\u0001\r!!\u0002\u0002/\u0011,7/\u001a:jC2L'0Z*dQ\u0016l\u0017m\u0015;sS:<GcB:\u0003\n\t5!q\u0002\u0005\u0007\u0005\u0017\u0019\u0002\u0019A2\u0002\u0019M\u001c\u0007.Z7b'R\u0014\u0018N\\4\t\u000f\u0005%8\u00031\u0001\u0002l\"9\u00111A\nA\u0002\u0005\u0015\u0011\u0001\n:fa2\f7-Z$f_6,GO]=D_2,XN\\,ji\"<Um\\7fiJLX\u000b\u0012+\u0015\u000fQ\u0014)Ba\u0006\u0003\u001a!1\u0011q\u0017\u000bA\u0002QDq!!;\u0015\u0001\u0004\tY\u000fC\u0004\u0002\u0004Q\u0001\r!!\u0002\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005?\u0001BA!\t\u0003(5\u0011!1\u0005\u0006\u0005\u0005K\t\u00190\u0001\u0003mC:<\u0017\u0002\u0002B\u0015\u0005G\u0011aa\u00142kK\u000e$\b")
public class GeoParquetFileFormat
extends ParquetFileFormat
implements GeoParquetFileFormatBase {
    private final Option<GeoParquetSpatialFilter> spatialFilter;

    public static Option<StructType> mergeSchemasInParallel(scala.collection.immutable.Map<String, String> map, Seq<FileStatus> seq, SparkSession sparkSession) {
        return GeoParquetFileFormat$.MODULE$.mergeSchemasInParallel(map, seq, sparkSession);
    }

    @Override
    public String shortName() {
        return GeoParquetFileFormatBase.shortName$(this);
    }

    public Option<GeoParquetSpatialFilter> spatialFilter() {
        return this.spatialFilter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof GeoParquetFileFormat)) return false;
        Option<GeoParquetSpatialFilter> option = ((GeoParquetFileFormat)other).spatialFilter();
        Option<GeoParquetSpatialFilter> option2 = this.spatialFilter();
        if (option != null) {
            if (!option.equals(option2)) return false;
            return true;
        }
        if (option2 == null) return true;
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return new StringBuilder(10).append("GeoParquet").append(this.spatialFilter().map((Function1 & Serializable & scala.Serializable)filter -> new StringBuilder(23).append(" with spatial filter [").append(filter.simpleString()).append("]").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
    }

    @Override
    public GeoParquetFileFormat withSpatialPredicates(GeoParquetSpatialFilter spatialFilter) {
        return new GeoParquetFileFormat((Option<GeoParquetSpatialFilter>)new Some((Object)spatialFilter));
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, scala.collection.immutable.Map<String, String> parameters, Seq<FileStatus> files) {
        return GeoParquetUtils$.MODULE$.inferSchema(sparkSession, parameters, files);
    }

    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, scala.collection.immutable.Map<String, String> options, StructType dataSchema) {
        SQLConf sqlConf = sparkSession.sessionState().conf();
        ParquetOptions parquetOptions = new ParquetOptions(options, sqlConf);
        Configuration conf = ContextUtil.getConfiguration((JobContext)job);
        Class committerClass = conf.getClass(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key(), ParquetOutputCommitter.class, OutputCommitter.class);
        if (conf.get(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key()) == null) {
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Using default output committer for Parquet: ").append(ParquetOutputCommitter.class.getCanonicalName()).toString());
        } else {
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Using user defined output committer for Parquet: ").append(committerClass.getCanonicalName()).toString());
        }
        conf.setClass(SQLConf$.MODULE$.OUTPUT_COMMITTER_CLASS().key(), committerClass, OutputCommitter.class);
        job.setOutputFormatClass(ParquetOutputFormat.class);
        ParquetOutputFormat.setWriteSupportClass((Job)job, ParquetWriteSupport.class);
        ParquetWriteSupport$.MODULE$.setSchema(dataSchema, conf);
        conf.set(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key(), Boolean.toString(sqlConf.writeLegacyParquetFormat()));
        conf.set(SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key(), sqlConf.parquetOutputTimestampType().toString());
        conf.set(SQLConf$.MODULE$.PARQUET_FIELD_ID_WRITE_ENABLED().key(), Boolean.toString(sqlConf.parquetFieldIdWriteEnabled()));
        conf.set(SQLConf$.MODULE$.LEGACY_PARQUET_NANOS_AS_LONG().key(), Boolean.toString(sqlConf.legacyParquetNanosAsLong()));
        conf.set("parquet.compression", parquetOptions.compressionCodecClassName());
        if (conf.get("parquet.summary.metadata.level") == null && conf.get("parquet.enable.summary-metadata") == null) {
            conf.setEnum("parquet.summary.metadata.level", (Enum)ParquetOutputFormat.JobSummaryLevel.NONE);
        }
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel = ParquetOutputFormat.getJobSummaryLevel((Configuration)conf);
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel2 = ParquetOutputFormat.JobSummaryLevel.NONE;
        if ((jobSummaryLevel == null ? jobSummaryLevel2 != null : !jobSummaryLevel.equals(jobSummaryLevel2)) && !ParquetOutputCommitter.class.isAssignableFrom(committerClass)) {
            this.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(134).append("Committer ").append(committerClass).append(" is not a ParquetOutputCommitter and cannot").append(" create job summaries. ").append("Set Parquet option ").append("parquet.summary.metadata.level").append(" to NONE.").toString());
        }
        conf.set("parquet.write.support.class", GeoParquetWriteSupport.class.getName());
        return new OutputWriterFactory(null){

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new ParquetOutputWriter(path, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder(8).append(CodecConfig.from((TaskAttemptContext)context).getCodec().getExtension()).append(".parquet").toString();
            }
        };
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, scala.collection.immutable.Map<String, String> options, Configuration hadoopConf) {
        hadoopConf.set("parquet.read.support.class", ParquetReadSupport.class.getName());
        hadoopConf.set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), requiredSchema.json());
        hadoopConf.set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), requiredSchema.json());
        hadoopConf.set(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key(), sparkSession.sessionState().conf().sessionLocalTimeZone());
        hadoopConf.setBoolean(SQLConf$.MODULE$.NESTED_SCHEMA_PRUNING_ENABLED().key(), sparkSession.sessionState().conf().nestedSchemaPruningEnabled());
        hadoopConf.setBoolean(SQLConf$.MODULE$.CASE_SENSITIVE().key(), sparkSession.sessionState().conf().caseSensitiveAnalysis());
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), sparkSession.sessionState().conf().isParquetBinaryAsString());
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), sparkSession.sessionState().conf().isParquetINT96AsTimestamp());
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INFER_TIMESTAMP_NTZ_ENABLED().key(), sparkSession.sessionState().conf().parquetInferTimestampNTZEnabled());
        hadoopConf.setBoolean(SQLConf$.MODULE$.LEGACY_PARQUET_NANOS_AS_LONG().key(), sparkSession.sessionState().conf().legacyParquetNanosAsLong());
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        StructType resultSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        SQLConf sqlConf = sparkSession.sessionState().conf();
        boolean enableVectorizedReader = sqlConf.parquetVectorizedReaderEnabled() && resultSchema.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GeoParquetFileFormat.$anonfun$buildReaderWithPartitionValues$1(x$1)));
        boolean enableRecordFilter = sqlConf.parquetRecordFilterEnabled();
        boolean timestampConversion = sqlConf.isParquetINT96TimestampConversion();
        boolean enableParquetFilterPushDown = sqlConf.parquetFilterPushDown();
        boolean pushDownDate = sqlConf.parquetFilterPushDownDate();
        boolean pushDownTimestamp = sqlConf.parquetFilterPushDownTimestamp();
        boolean pushDownDecimal = sqlConf.parquetFilterPushDownDecimal();
        boolean parquetFilterPushDownStringPredicate = sqlConf.parquetFilterPushDownStringPredicate();
        int pushDownInFilterThreshold = sqlConf.parquetFilterPushDownInFilterThreshold();
        boolean isCaseSensitive = sqlConf.caseSensitiveAnalysis();
        ParquetOptions parquetOptions = new ParquetOptions(options, sparkSession.sessionState().conf());
        String datetimeRebaseModeInRead = parquetOptions.datetimeRebaseModeInRead();
        String int96RebaseModeInRead = parquetOptions.int96RebaseModeInRead();
        return (Function1 & Serializable & scala.Serializable)file -> {
            Iterator iterator;
            None$ none$;
            Predef$.MODULE$.assert(file.partitionValues().numFields() == partitionSchema.size());
            Path filePath = file.toPath();
            FileSplit split = new FileSplit(filePath, file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
            Configuration sharedConf = ((SerializableConfiguration)broadcastedHadoopConf.value()).value();
            FileMetaData footerFileMetaData = ParquetFooterReader.readFooter((Configuration)sharedConf, (PartitionedFile)file, (boolean)true).getFileMetaData();
            Map map = footerFileMetaData.getKeyValueMetaData();
            RebaseDateTime.RebaseSpec datetimeRebaseSpec = DataSourceUtils$.MODULE$.datetimeRebaseSpec((Function1 & Serializable & scala.Serializable)x$1 -> (String)map.get(x$1), datetimeRebaseModeInRead);
            Map map2 = footerFileMetaData.getKeyValueMetaData();
            RebaseDateTime.RebaseSpec int96RebaseSpec = DataSourceUtils$.MODULE$.int96RebaseSpec((Function1 & Serializable & scala.Serializable)x$1 -> (String)map2.get(x$1), int96RebaseModeInRead);
            if (enableParquetFilterPushDown) {
                MessageType parquetSchema = footerFileMetaData.getSchema();
                ParquetFilters parquetFilters = new ParquetFilters(parquetSchema, pushDownDate, pushDownTimestamp, pushDownDecimal, parquetFilterPushDownStringPredicate, pushDownInFilterThreshold, isCaseSensitive, datetimeRebaseSpec);
                none$ = ((TraversableOnce)filters.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Option$.MODULE$.option2Iterable(parquetFilters.createFilter(x$2)), Seq$.MODULE$.canBuildFrom())).reduceOption((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2));
            } else {
                none$ = None$.MODULE$;
            }
            None$ pushed = none$;
            boolean shouldScanFile = GeoParquetMetaData$.MODULE$.parseKeyValueMetaData(footerFileMetaData.getKeyValueMetaData()).forall((Function1 & Serializable & scala.Serializable)metadata -> BoxesRunTime.boxToBoolean((boolean)GeoParquetFileFormat.$anonfun$buildReaderWithPartitionValues$7(this, metadata)));
            if (!shouldScanFile) {
                iterator = ((IterableLike)Nil$.MODULE$).iterator();
            } else {
                ParquetRecordReader parquetRecordReader;
                None$ convertTz = timestampConversion && !GeoParquetFileFormat.isCreatedByParquetMr$1(footerFileMetaData) ? new Some((Object)DateTimeUtils$.MODULE$.getZoneId(sharedConf.get(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()))) : None$.MODULE$;
                TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
                TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(((SerializableConfiguration)broadcastedHadoopConf.value()).value(), attemptId);
                if (pushed.isDefined()) {
                    ParquetInputFormat.setFilterPredicate((Configuration)hadoopAttemptContext.getConfiguration(), (FilterPredicate)((FilterPredicate)pushed.get()));
                }
                if (enableVectorizedReader) {
                    this.logWarning((Function0 & Serializable & scala.Serializable)() -> "GeoParquet currently does not support vectorized reader. Falling back to parquet-mr");
                }
                this.logDebug((Function0 & Serializable & scala.Serializable)() -> "Falling back to parquet-mr");
                GeoParquetReadSupport readSupport = new GeoParquetReadSupport((Option<ZoneId>)convertTz, false, datetimeRebaseSpec, int96RebaseSpec, options);
                if (pushed.isDefined() && enableRecordFilter) {
                    FilterCompat.Filter parquetFilter = FilterCompat.get((FilterPredicate)((FilterPredicate)pushed.get()), null);
                    parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport, parquetFilter);
                } else {
                    parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport);
                }
                ParquetRecordReader reader = parquetRecordReader;
                RecordReader readerWithRowIndexes = ParquetRowIndexUtil$.MODULE$.addRowIndexToRecordReaderIfNeeded(reader, requiredSchema);
                RecordReaderIterator iter = new RecordReaderIterator(readerWithRowIndexes);
                try {
                    readerWithRowIndexes.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                    Seq fullSchema = (Seq)DataTypeUtils$.MODULE$.toAttributes(requiredSchema).$plus$plus((GenTraversableOnce)DataTypeUtils$.MODULE$.toAttributes(partitionSchema), Seq$.MODULE$.canBuildFrom());
                    UnsafeProjection unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
                    if (partitionSchema.length() == 0) {
                        iterator = iter.map((Function1)unsafeProjection);
                    } else {
                        JoinedRow joinedRow = new JoinedRow();
                        iterator = iter.map((Function1 & Serializable & scala.Serializable)d -> unsafeProjection.apply((InternalRow)joinedRow.apply(d, file.partitionValues())));
                    }
                }
                catch (Throwable e) {
                    iter.close();
                    throw e;
                }
            }
            return iterator;
        };
    }

    public boolean supportDataType(DataType dataType) {
        return super.supportDataType(dataType);
    }

    public boolean supportBatch(SparkSession sparkSession, StructType schema) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$buildReaderWithPartitionValues$1(StructField x$1) {
        return x$1.dataType() instanceof AtomicType;
    }

    public static final /* synthetic */ boolean $anonfun$buildReaderWithPartitionValues$7(GeoParquetFileFormat $this, GeoParquetMetaData metadata) {
        return $this.spatialFilter().forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.evaluate(metadata.columns())));
    }

    private static final boolean isCreatedByParquetMr$1(FileMetaData footerFileMetaData$1) {
        return footerFileMetaData$1.getCreatedBy().startsWith("parquet-mr");
    }

    public GeoParquetFileFormat(Option<GeoParquetSpatialFilter> spatialFilter) {
        this.spatialFilter = spatialFilter;
        GeoParquetFileFormatBase.$init$(this);
    }

    public GeoParquetFileFormat() {
        this((Option<GeoParquetSpatialFilter>)None$.MODULE$);
    }
}

