/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.jiffle.parser.node;

import java.util.Objects;
import org.apache.sedona.shaded.jiffle.parser.node.SourceWriter;
import org.apache.sedona.shaded.jiffle.parser.node.Statement;
import org.apache.sedona.shaded.jiffle.parser.node.Variable;

public class LoopInVariable
implements Statement {
    private Statement statement;
    private Variable loopVariable;
    private Variable listVariable;

    public LoopInVariable(Variable loopVariable, Variable listVariable, Statement statement) {
        this.loopVariable = loopVariable;
        this.listVariable = listVariable;
        this.statement = statement;
    }

    @Override
    public void write(SourceWriter w) {
        w.indent().append("for(Double ").append(this.loopVariable).append(" : ").append(this.listVariable);
        w.append(") {").newLine();
        w.inc();
        this.statement.write(w);
        w.dec();
        w.line("}");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoopInVariable that = (LoopInVariable)o;
        return Objects.equals(this.statement, that.statement) && Objects.equals(this.loopVariable, that.loopVariable) && Objects.equals(this.listVariable, that.listVariable);
    }

    public int hashCode() {
        return Objects.hash(this.statement, this.loopVariable, this.listVariable);
    }

    public Statement getStatement() {
        return this.statement;
    }

    public Variable getLoopVariable() {
        return this.loopVariable;
    }

    public Variable getListVariable() {
        return this.listVariable;
    }
}

