% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bounding_box.R
\name{new_bounding_box}
\alias{new_bounding_box}
\title{Construct a bounding box object.}
\usage{
new_bounding_box(sc, min_x = -Inf, max_x = Inf, min_y = -Inf, max_y = Inf)
}
\arguments{
\item{sc}{The Spark connection.}

\item{min_x}{Minimum x-value of the bounding box, can be +/- Inf.}

\item{max_x}{Maximum x-value of the bounding box, can be +/- Inf.}

\item{min_y}{Minimum y-value of the bounding box, can be +/- Inf.}

\item{max_y}{Maximum y-value of the bounding box, can be +/- Inf.}
}
\value{
A bounding box object.
}
\description{
Construct a axis-aligned rectangular bounding box object.
}
\examples{
library(sparklyr)
library(apache.sedona)

sc <- spark_connect(master = "spark://HOST:PORT")
bb <- new_bounding_box(sc, -1, 1, -1, 1)

}
