/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.sedona.sql.datasources.osmpbf.iterators;

import java.io.IOException;
import java.util.Iterator;
import java.util.zip.DataFormatException;
import org.apache.sedona.sql.datasources.osmpbf.TruncatedStream;
import org.apache.sedona.sql.datasources.osmpbf.model.OSMEntity;

public class PbfIterator implements Iterator<OSMEntity> {

  PrimitiveGroupIterator pmGroupIterator;

  BlobIterator osmEntitiesIterator;

  public PbfIterator(TruncatedStream pbfInputStream) throws DataFormatException, IOException {
    this.pmGroupIterator = new PrimitiveGroupIterator(pbfInputStream);
    osmEntitiesIterator = readNextBlock();
  }

  @Override
  public boolean hasNext() {
    return osmEntitiesIterator != null
        && (osmEntitiesIterator.hasNext() || pmGroupIterator.hasNext());
  }

  @Override
  public OSMEntity next() {
    OSMEntity nextEntity = osmEntitiesIterator.next();
    if (!osmEntitiesIterator.hasNext()) {
      try {
        osmEntitiesIterator = readNextBlock();
      } catch (DataFormatException | IOException e) {
        throw new RuntimeException(e);
      }
    }

    return nextEntity;
  }

  private BlobIterator readNextBlock() throws DataFormatException, IOException {
    if (pmGroupIterator.hasNext()) {
      BlobData next = pmGroupIterator.next();
      if (next.getHeader().getType().equals("OSMData")) {
        return new BlobIterator(next.getBlob());
      }
    }

    return null;
  }
}
