/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.vo;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.admin.model.entity.SelectorConditionDO;
import org.apache.shenyu.common.enums.OperatorEnum;
import org.apache.shenyu.common.enums.ParamTypeEnum;
import org.apache.shenyu.common.utils.DateUtils;

public class SelectorConditionVO
implements Serializable {
    private static final long serialVersionUID = -9194910149899688578L;
    private String id;
    private String selectorId;
    private String paramType;
    private String paramTypeName;
    private String operator;
    private String operatorName;
    private String paramName;
    private String paramValue;
    private String dateCreated;
    private String dateUpdated;

    public SelectorConditionVO() {
    }

    public SelectorConditionVO(String id, String selectorId, String paramType, String paramTypeName, String operator, String operatorName, String paramName, String paramValue, String dateCreated, String dateUpdated) {
        this.id = id;
        this.selectorId = selectorId;
        this.paramType = paramType;
        this.paramTypeName = paramTypeName;
        this.operator = operator;
        this.operatorName = operatorName;
        this.paramName = paramName;
        this.paramValue = paramValue;
        this.dateCreated = dateCreated;
        this.dateUpdated = dateUpdated;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSelectorId() {
        return this.selectorId;
    }

    public void setSelectorId(String selectorId) {
        this.selectorId = selectorId;
    }

    public String getParamType() {
        return this.paramType;
    }

    public void setParamType(String paramType) {
        this.paramType = paramType;
    }

    public String getParamTypeName() {
        return this.paramTypeName;
    }

    public void setParamTypeName(String paramTypeName) {
        this.paramTypeName = paramTypeName;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getParamName() {
        return this.paramName;
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public String getParamValue() {
        return this.paramValue;
    }

    public void setParamValue(String paramValue) {
        this.paramValue = paramValue;
    }

    public String getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(String dateCreated) {
        this.dateCreated = dateCreated;
    }

    public String getDateUpdated() {
        return this.dateUpdated;
    }

    public void setDateUpdated(String dateUpdated) {
        this.dateUpdated = dateUpdated;
    }

    public static SelectorConditionVO buildSelectorConditionVO(SelectorConditionDO selectorConditionDO) {
        ParamTypeEnum paramTypeEnum = ParamTypeEnum.getParamTypeEnumByName((String)selectorConditionDO.getParamType());
        OperatorEnum operatorEnum = OperatorEnum.getOperatorEnumByAlias((String)selectorConditionDO.getOperator());
        return new SelectorConditionVO(selectorConditionDO.getId(), selectorConditionDO.getSelectorId(), selectorConditionDO.getParamType(), Optional.ofNullable(paramTypeEnum).map(ParamTypeEnum::getName).orElse(selectorConditionDO.getParamType()), selectorConditionDO.getOperator(), Optional.ofNullable(operatorEnum).map(OperatorEnum::getAlias).orElse(selectorConditionDO.getOperator()), selectorConditionDO.getParamName(), selectorConditionDO.getParamValue(), DateUtils.localDateTimeToString((LocalDateTime)selectorConditionDO.getDateCreated().toLocalDateTime()), DateUtils.localDateTimeToString((LocalDateTime)selectorConditionDO.getDateUpdated().toLocalDateTime()));
    }

    public static List<SelectorConditionVO> buildSelectorConditionVOList(List<SelectorConditionDO> selectorConditionDOList) {
        if (CollectionUtils.isEmpty(selectorConditionDOList)) {
            return Lists.newArrayList();
        }
        return selectorConditionDOList.stream().map(SelectorConditionVO::buildSelectorConditionVO).collect(Collectors.toList());
    }
}

