/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.breeze.serializer;

import com.weibo.breeze.Breeze;
import com.weibo.breeze.BreezeBuffer;
import com.weibo.breeze.BreezeException;
import com.weibo.breeze.BreezeReader;
import com.weibo.breeze.BreezeWriter;
import com.weibo.breeze.message.Schema;
import com.weibo.breeze.serializer.Serializer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommonSerializer<T>
implements Serializer<T> {
    public static boolean WITH_STATIC_FIELD = false;
    private String[] names;
    private Class<T> clz;
    private Method buildMethod;
    private Object buildObject;
    private Schema schema;
    private String cleanName;

    public CommonSerializer(Class<T> clz) throws BreezeException {
        Field[] fields;
        this.checkClass(clz);
        HashMap<String, Field> target = new HashMap<String, Field>();
        for (Field field : fields = clz.getFields()) {
            if (Modifier.isFinal(field.getModifiers()) || !WITH_STATIC_FIELD && Modifier.isStatic(field.getModifiers())) continue;
            target.put(field.getName(), field);
        }
        Method[] methods = clz.getMethods();
        if (methods.length > 0) {
            List<Field> list = CommonSerializer.getAllFields(clz);
            block1: for (Field field : list) {
                if (target.containsKey(field.getName()) || Modifier.isFinal(field.getModifiers()) || !WITH_STATIC_FIELD && Modifier.isStatic(field.getModifiers())) continue;
                for (Method method : methods) {
                    if (!method.getName().equalsIgnoreCase("get" + field.getName()) && (field.getType() != Boolean.TYPE || !method.getName().equalsIgnoreCase("is" + field.getName()))) continue;
                    target.put(field.getName(), field);
                    continue block1;
                }
            }
        }
        if (target.isEmpty()) {
            throw new BreezeException("field is empty");
        }
        this.schema = new Schema();
        this.schema.setName(clz.getName()).setPrimitive(false);
        for (Map.Entry entry : target.entrySet()) {
            this.schema.putField(new Schema.Field(CommonSerializer.getHash((String)entry.getKey()), (String)entry.getKey(), ((Field)entry.getValue()).getType().getName(), (Field)entry.getValue()));
        }
        this.clz = clz;
        this.cleanName = Breeze.getCleanName(clz.getName());
        this.names = clz.getName().contains("$") ? new String[]{this.cleanName, clz.getName()} : new String[]{this.cleanName};
    }

    public CommonSerializer(Schema schema) throws BreezeException {
        if (schema == null) {
            throw new BreezeException("BreezeSchema must not null when create CommonSerializer");
        }
        try {
            this.clz = Class.forName(schema.getJavaName() != null ? schema.getJavaName() : schema.getName(), true, Schema.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new BreezeException("can not create class in CommonSerializer, class name:" + schema.getName());
        }
        this.checkClass(this.clz);
        Map<Integer, Schema.Field> fieldMap = schema.getFields();
        if (fieldMap.isEmpty()) {
            throw new BreezeException("schema field is empty");
        }
        for (Map.Entry<Integer, Schema.Field> entry : fieldMap.entrySet()) {
            try {
                entry.getValue().setField(CommonSerializer.getField(this.clz, entry.getValue().getName()));
            }
            catch (NoSuchFieldException e) {
                throw new BreezeException("can not get field from class " + this.clz.getName() + ", field:" + entry.getValue().getName());
            }
        }
        this.schema = schema;
        this.cleanName = Breeze.getCleanName(this.clz.getName());
        this.names = this.clz.getName().contains("$") ? new String[]{this.cleanName, this.clz.getName()} : new String[]{this.cleanName};
    }

    public static int getHash(String name) {
        return name.hashCode() & Integer.MAX_VALUE;
    }

    private static List<Field> getAllFields(Class clz) {
        ArrayList<Field> list = new ArrayList<Field>();
        do {
            Field[] fields = clz.getDeclaredFields();
            Collections.addAll(list, fields);
        } while ((clz = clz.getSuperclass()) != null && clz != Object.class);
        return list;
    }

    private static Field getField(Class clz, String name) throws NoSuchFieldException {
        while (true) {
            try {
                Field field = clz.getDeclaredField(name);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if ((clz = clz.getSuperclass()) != null && clz != Object.class) continue;
                throw new NoSuchFieldException();
            }
            break;
        }
    }

    @Override
    public void writeToBuf(Object obj, BreezeBuffer buffer) throws BreezeException {
        BreezeWriter.writeMessage(buffer, () -> {
            Map<Integer, Schema.Field> fieldMap = this.schema.getFields();
            for (Map.Entry<Integer, Schema.Field> entry : fieldMap.entrySet()) {
                entry.getValue().writeField(buffer, obj);
            }
        });
    }

    @Override
    public T readFromBuf(BreezeBuffer buffer) throws BreezeException {
        Object t;
        try {
            t = this.buildMethod != null ? this.buildMethod.invoke(this.buildObject, new Object[0]) : this.clz.newInstance();
        }
        catch (ReflectiveOperationException e1) {
            throw new BreezeException("CommonSerializer read fail. can not create default object. class:" + this.clz);
        }
        BreezeReader.readMessage(buffer, index -> {
            Schema.Field field = this.schema.getFieldByIndex(index);
            if (field == null) {
                BreezeReader.readObject(buffer, Object.class);
                return;
            }
            field.readField(buffer, t);
        });
        return t;
    }

    @Override
    public String[] getNames() {
        return this.names;
    }

    private void checkClass(Class<T> clz) throws BreezeException {
        if (clz == null) {
            throw new BreezeException("class must not null when create CommonSerializer");
        }
        try {
            clz.newInstance();
        }
        catch (ReflectiveOperationException e) {
            try {
                Object obj;
                Object object;
                Method method = clz.getMethod("builder", new Class[0]);
                if (Modifier.isStatic(method.getModifiers()) && (object = method.invoke(null, new Object[0])) != null && clz.isInstance(obj = (method = object.getClass().getMethod("build", new Class[0])).invoke(object, new Object[0]))) {
                    this.buildMethod = method;
                    this.buildObject = object;
                    return;
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
            throw new BreezeException("class must has constructor without arguments, or has builder like lombok.");
        }
    }
}

