/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.api.sync.RedisSetCommands;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.lettuce.LettuceClusterConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceSetCommands;
import org.springframework.data.redis.connection.util.ByteArraySet;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.util.Assert;

class LettuceClusterSetCommands
extends LettuceSetCommands {
    private final LettuceClusterConnection connection;

    LettuceClusterSetCommands(LettuceClusterConnection connection) {
        super(connection);
        this.connection = connection;
    }

    @Override
    public Boolean sMove(byte[] srcKey, byte[] destKey, byte[] value) {
        Assert.notNull((Object)srcKey, (String)"Source key must not be null");
        Assert.notNull((Object)destKey, (String)"Destination key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(srcKey, destKey)) {
            return super.sMove(srcKey, destKey, value);
        }
        if (this.connection.keyCommands().exists(srcKey).booleanValue() && this.sRem(srcKey, new byte[][]{value}) > 0L && !this.sIsMember(destKey, value).booleanValue()) {
            return LettuceConverters.toBoolean(this.sAdd(destKey, new byte[][]{value}));
        }
        return Boolean.FALSE;
    }

    @Override
    public Set<byte[]> sInter(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            return super.sInter(keys);
        }
        List nodeResult = this.connection.getClusterCommandExecutor().executeMultiKeyCommand(RedisSetCommands::smembers, Arrays.asList(keys)).resultsAsList();
        ByteArraySet result = null;
        for (Set entry : nodeResult) {
            ByteArraySet tmp = new ByteArraySet(entry);
            if (result == null) {
                result = tmp;
                continue;
            }
            result.retainAll(tmp);
            if (!result.isEmpty()) continue;
            break;
        }
        if (result == null || result.isEmpty()) {
            return Collections.emptySet();
        }
        return result.asRawSet();
    }

    @Override
    public Long sInterStore(byte[] destKey, byte[] ... keys) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null");
        Assert.notNull((Object)keys, (String)"Source keys must not be null");
        Assert.noNullElements((Object[])keys, (String)"Source keys must not contain null elements");
        byte[][] allKeys = ByteUtils.mergeArrays(destKey, keys);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            return super.sInterStore(destKey, keys);
        }
        Set<byte[]> result = this.sInter(keys);
        if (result.isEmpty()) {
            return 0L;
        }
        return this.sAdd(destKey, (byte[][])result.toArray((T[])new byte[result.size()][]));
    }

    @Override
    public Set<byte[]> sUnion(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            return super.sUnion(keys);
        }
        List nodeResult = this.connection.getClusterCommandExecutor().executeMultiKeyCommand(RedisSetCommands::smembers, Arrays.asList(keys)).resultsAsList();
        ByteArraySet result = new ByteArraySet();
        for (Set entry : nodeResult) {
            result.addAll(entry);
        }
        if (result.isEmpty()) {
            return Collections.emptySet();
        }
        return result.asRawSet();
    }

    @Override
    public Long sUnionStore(byte[] destKey, byte[] ... keys) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null");
        Assert.notNull((Object)keys, (String)"Source keys must not be null");
        Assert.noNullElements((Object[])keys, (String)"Source keys must not contain null elements");
        byte[][] allKeys = ByteUtils.mergeArrays(destKey, keys);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            return super.sUnionStore(destKey, keys);
        }
        Set<byte[]> result = this.sUnion(keys);
        if (result.isEmpty()) {
            return 0L;
        }
        return this.sAdd(destKey, (byte[][])result.toArray((T[])new byte[result.size()][]));
    }

    @Override
    public Set<byte[]> sDiff(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            return super.sDiff(keys);
        }
        byte[] source = keys[0];
        byte[][] others = (byte[][])Arrays.copyOfRange(keys, 1, keys.length);
        ByteArraySet values = new ByteArraySet(this.sMembers(source));
        List nodeResult = this.connection.getClusterCommandExecutor().executeMultiKeyCommand(RedisSetCommands::smembers, Arrays.asList(others)).resultsAsList();
        if (values.isEmpty()) {
            return Collections.emptySet();
        }
        for (Set toSubstract : nodeResult) {
            values.removeAll(toSubstract);
        }
        return values.asRawSet();
    }

    @Override
    public Long sDiffStore(byte[] destKey, byte[] ... keys) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null");
        Assert.notNull((Object)keys, (String)"Source keys must not be null");
        Assert.noNullElements((Object[])keys, (String)"Source keys must not contain null elements");
        byte[][] allKeys = ByteUtils.mergeArrays(destKey, keys);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            return super.sDiffStore(destKey, keys);
        }
        Set<byte[]> diff = this.sDiff(keys);
        if (diff.isEmpty()) {
            return 0L;
        }
        return this.sAdd(destKey, (byte[][])diff.toArray((T[])new byte[diff.size()][]));
    }
}

