/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb;

import com.google.common.base.Preconditions;
import io.grpc.Channel;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.skywalking.banyandb.common.v1.BanyandbCommon;
import org.apache.skywalking.banyandb.database.v1.BanyandbDatabase;
import org.apache.skywalking.banyandb.model.v1.BanyandbModel;
import org.apache.skywalking.banyandb.property.v1.BanyandbProperty;
import org.apache.skywalking.banyandb.stream.v1.BanyandbStream;
import org.apache.skywalking.banyandb.stream.v1.StreamServiceGrpc;
import org.apache.skywalking.banyandb.v1.client.BanyanDBClient;
import org.apache.skywalking.banyandb.v1.client.MeasureQuery;
import org.apache.skywalking.banyandb.v1.client.MeasureQueryResponse;
import org.apache.skywalking.banyandb.v1.client.MeasureWrite;
import org.apache.skywalking.banyandb.v1.client.Options;
import org.apache.skywalking.banyandb.v1.client.PropertyStore;
import org.apache.skywalking.banyandb.v1.client.StreamQuery;
import org.apache.skywalking.banyandb.v1.client.StreamQueryResponse;
import org.apache.skywalking.banyandb.v1.client.StreamWrite;
import org.apache.skywalking.banyandb.v1.client.TopNQuery;
import org.apache.skywalking.banyandb.v1.client.TopNQueryResponse;
import org.apache.skywalking.banyandb.v1.client.TraceQuery;
import org.apache.skywalking.banyandb.v1.client.TraceQueryResponse;
import org.apache.skywalking.banyandb.v1.client.TraceWrite;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.InternalException;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.InvalidArgumentException;
import org.apache.skywalking.banyandb.v1.client.util.StatusUtil;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.client.healthcheck.DelegatedHealthChecker;
import org.apache.skywalking.oap.server.library.client.healthcheck.HealthCheckable;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.HealthChecker;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageConfig;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.MetadataRegistry;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.bulk.MeasureBulkWriteProcessor;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.bulk.StreamBulkWriteProcessor;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.bulk.TraceBulkWriteProcessor;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BanyanDBStorageClient
implements Client,
HealthCheckable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BanyanDBStorageClient.class);
    private static final String[] COMPATIBLE_SERVER_API_VERSIONS = new String[]{"0.9"};
    final BanyanDBClient client;
    private final DelegatedHealthChecker healthChecker = new DelegatedHealthChecker();
    private final int flushTimeout;
    private final ModuleManager moduleManager;
    private final Options options;
    private BanyandbDatabase database;
    private HistogramMetrics propertySingleWriteHistogram;
    private HistogramMetrics propertySingleDeleteHistogram;
    private HistogramMetrics streamSingleWriteHistogram;
    private HistogramMetrics measureWriteHistogram;
    private HistogramMetrics streamWriteHistogram;
    private HistogramMetrics traceWriteHistogram;

    public BanyanDBStorageClient(ModuleManager moduleManager, BanyanDBStorageConfig config) {
        Options options = new Options();
        options.setSslTrustCAPath(config.getGlobal().getSslTrustCAPath());
        String username = config.getGlobal().getUser();
        String password = config.getGlobal().getPassword();
        if (StringUtil.isNotBlank((String)username)) {
            if (StringUtil.isBlank((String)password)) {
                throw new IllegalArgumentException("User is set, but password is not set.");
            }
            options.setUsername(username);
            options.setPassword(password);
        } else if (StringUtil.isNotBlank((String)password)) {
            throw new IllegalArgumentException("Password is set, but user is not set.");
        }
        this.client = new BanyanDBClient(config.getTargetArray(), options);
        this.flushTimeout = config.getGlobal().getFlushTimeout();
        this.options = options;
        this.moduleManager = moduleManager;
    }

    public void connect() throws Exception {
        BanyandbCommon.APIVersion apiVersion;
        this.initTelemetry();
        this.client.connect();
        Properties properties = new Properties();
        try (InputStream resourceAsStream = BanyanDBStorageClient.class.getClassLoader().getResourceAsStream("bydb.dependencies.properties");){
            if (resourceAsStream == null) {
                throw new IllegalStateException("bydb.dependencies.properties not found");
            }
            properties.load(resourceAsStream);
        }
        String expectedApiVersion = properties.getProperty("bydb.api.version");
        if (!Arrays.stream(COMPATIBLE_SERVER_API_VERSIONS).anyMatch(v -> v.equals(expectedApiVersion))) {
            throw new IllegalStateException("Inconsistent versions between bydb.dependencies.properties and codes(" + String.join((CharSequence)", ", COMPATIBLE_SERVER_API_VERSIONS) + ").");
        }
        try {
            apiVersion = this.client.getAPIVersion();
        }
        catch (BanyanDBException e) {
            Status status;
            Throwable cause = e.getCause();
            if (cause instanceof StatusRuntimeException && Status.Code.UNIMPLEMENTED.equals((Object)(status = ((StatusRuntimeException)cause).getStatus()).getCode())) {
                log.error("fail to get BanyanDB API version, server version < 0.8 is not supported.");
            }
            throw e;
        }
        boolean isCompatible = Arrays.stream(COMPATIBLE_SERVER_API_VERSIONS).anyMatch(v -> v.equals(apiVersion.getVersion()));
        String revision = apiVersion.getRevision();
        log.info("BanyanDB server API version: {}, revision: {}", (Object)apiVersion.getVersion(), (Object)revision);
        if (!isCompatible) {
            throw new IllegalStateException("Incompatible BanyanDB server API version: " + apiVersion.getVersion() + ". But accepted versions: " + String.join((CharSequence)", ", COMPATIBLE_SERVER_API_VERSIONS));
        }
    }

    public void shutdown() throws IOException {
        this.client.close();
    }

    public List<BanyandbProperty.Property> listProperties(String name) throws IOException {
        try {
            MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findManagementMetadata(name);
            BanyandbProperty.QueryResponse resp = this.client.query(BanyandbProperty.QueryRequest.newBuilder().addGroups(schema.getMetadata().getGroup()).setName(name).setLimit(Integer.MAX_VALUE).build());
            this.healthChecker.health();
            return resp.getPropertiesList();
        }
        catch (BanyanDBException ex) {
            if (ex.getStatus().equals((Object)Status.Code.NOT_FOUND)) {
                this.healthChecker.health();
                return Collections.emptyList();
            }
            this.healthChecker.unHealth((Throwable)ex);
            throw new IOException("fail to list properties", ex);
        }
    }

    public BanyandbProperty.Property queryProperty(String name, String id) throws IOException {
        try {
            MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findManagementMetadata(name);
            BanyandbProperty.QueryResponse resp = this.client.query(BanyandbProperty.QueryRequest.newBuilder().addGroups(schema.getMetadata().getGroup()).setName(name).addIds(id).build());
            this.healthChecker.health();
            if (resp.getPropertiesCount() == 0) {
                return null;
            }
            return resp.getProperties(0);
        }
        catch (BanyanDBException ex) {
            if (ex.getStatus().equals((Object)Status.Code.NOT_FOUND)) {
                this.healthChecker.health();
                return null;
            }
            this.healthChecker.unHealth((Throwable)ex);
            throw new IOException("fail to query property", ex);
        }
    }

    public BanyandbProperty.DeleteResponse deleteProperty(String name, String id) throws IOException {
        BanyandbProperty.DeleteResponse deleteResponse;
        block8: {
            HistogramMetrics.Timer timer = this.propertySingleDeleteHistogram.createTimer();
            try {
                MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findManagementMetadata(name);
                PropertyStore store = new PropertyStore((Channel)Preconditions.checkNotNull((Object)this.client.getChannel()));
                BanyandbProperty.DeleteResponse result = store.delete(schema.getMetadata().getGroup(), name, id);
                this.healthChecker.health();
                deleteResponse = result;
                if (timer == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (timer != null) {
                        try {
                            timer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BanyanDBException ex) {
                    this.healthChecker.unHealth((Throwable)ex);
                    throw new IOException("fail to delete property", ex);
                }
            }
            timer.close();
        }
        return deleteResponse;
    }

    public StreamQueryResponse query(StreamQuery q) throws IOException {
        try {
            StreamQueryResponse response = this.client.query(q);
            this.healthChecker.health();
            return response;
        }
        catch (BanyanDBException ex) {
            this.healthChecker.unHealth((Throwable)ex);
            throw new IOException("fail to query stream", ex);
        }
    }

    public MeasureQueryResponse query(MeasureQuery q) throws IOException {
        try {
            MeasureQueryResponse response = this.client.query(q);
            this.healthChecker.health();
            return response;
        }
        catch (BanyanDBException ex) {
            this.healthChecker.unHealth((Throwable)ex);
            throw new IOException("fail to query measure", ex);
        }
    }

    public TraceQueryResponse query(TraceQuery q) throws IOException {
        try {
            TraceQueryResponse response = this.client.query(q);
            this.healthChecker.health();
            return response;
        }
        catch (BanyanDBException ex) {
            this.healthChecker.unHealth((Throwable)ex);
            throw new IOException("fail to query trace", ex);
        }
    }

    public TopNQueryResponse query(TopNQuery q) throws IOException {
        try {
            TopNQueryResponse response = this.client.query(q);
            this.healthChecker.health();
            return response;
        }
        catch (BanyanDBException ex) {
            this.healthChecker.unHealth((Throwable)ex);
            throw new IOException("fail to query topn", ex);
        }
    }

    public BanyandbProperty.QueryResponse query(BanyandbProperty.QueryRequest request) throws IOException {
        try {
            BanyandbProperty.QueryResponse response = this.client.query(request);
            this.healthChecker.health();
            return response;
        }
        catch (BanyanDBException ex) {
            this.healthChecker.unHealth((Throwable)ex);
            throw new IOException("fail to query property", ex);
        }
    }

    public BanyandbProperty.ApplyResponse apply(BanyandbProperty.Property property) throws IOException {
        BanyandbProperty.ApplyResponse applyResponse;
        block8: {
            HistogramMetrics.Timer timer = this.propertySingleWriteHistogram.createTimer();
            try {
                PropertyStore store = new PropertyStore((Channel)Preconditions.checkNotNull((Object)this.client.getChannel()));
                BanyandbProperty.ApplyResponse response = store.apply(property);
                this.healthChecker.health();
                applyResponse = response;
                if (timer == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (timer != null) {
                        try {
                            timer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BanyanDBException ex) {
                    this.healthChecker.unHealth((Throwable)ex);
                    throw new IOException("fail to create property", ex);
                }
            }
            timer.close();
        }
        return applyResponse;
    }

    public BanyandbProperty.ApplyResponse apply(BanyandbProperty.Property property, BanyandbProperty.ApplyRequest.Strategy strategy) throws IOException {
        BanyandbProperty.ApplyResponse applyResponse;
        block8: {
            HistogramMetrics.Timer timer = this.propertySingleWriteHistogram.createTimer();
            try {
                PropertyStore store = new PropertyStore((Channel)Preconditions.checkNotNull((Object)this.client.getChannel()));
                BanyandbProperty.ApplyResponse response = store.apply(property, strategy);
                this.healthChecker.health();
                applyResponse = response;
                if (timer == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (timer != null) {
                        try {
                            timer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BanyanDBException ex) {
                    this.healthChecker.unHealth((Throwable)ex);
                    throw new IOException("fail to create property", ex);
                }
            }
            timer.close();
        }
        return applyResponse;
    }

    public StreamWrite createStreamWrite(String group, String name, String elementId) throws IOException {
        try {
            return this.client.createStreamWrite(group, name, elementId);
        }
        catch (BanyanDBException e) {
            throw new IOException("fail to create stream write", e);
        }
    }

    public MeasureWrite createMeasureWrite(String group, String name, long timestamp) throws IOException {
        try {
            return this.client.createMeasureWrite(group, name, timestamp);
        }
        catch (BanyanDBException e) {
            throw new IOException("fail to create measure write", e);
        }
    }

    public TraceWrite createTraceWrite(String group, String name) throws IOException {
        try {
            return this.client.createTraceWrite(group, name);
        }
        catch (BanyanDBException e) {
            throw new IOException("fail to create trace write", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> write(final StreamWrite streamWrite) {
        Preconditions.checkState((this.client.getStreamServiceStub() != null ? 1 : 0) != 0, (Object)"stream service is null");
        final HistogramMetrics.Timer timer = this.streamSingleWriteHistogram.createTimer();
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        StreamObserver writeRequestStreamObserver = ((StreamServiceGrpc.StreamServiceStub)this.client.getStreamServiceStub().withDeadlineAfter((long)this.options.getDeadline(), TimeUnit.SECONDS)).write((StreamObserver)new StreamObserver<BanyandbStream.WriteResponse>(){
            private BanyanDBException responseException;

            public void onNext(BanyandbStream.WriteResponse writeResponse) {
                BanyandbModel.Status status = StatusUtil.convertStringToStatus((String)writeResponse.getStatus());
                switch (status) {
                    case STATUS_SUCCEED: {
                        break;
                    }
                    case STATUS_INVALID_TIMESTAMP: {
                        this.responseException = new InvalidArgumentException("Invalid timestamp: " + String.valueOf(streamWrite.getTimestamp()), null, Status.Code.INVALID_ARGUMENT, false);
                        break;
                    }
                    case STATUS_NOT_FOUND: {
                        this.responseException = new InvalidArgumentException("Invalid metadata: " + String.valueOf(streamWrite.getEntityMetadata()), null, Status.Code.INVALID_ARGUMENT, false);
                        break;
                    }
                    case STATUS_EXPIRED_SCHEMA: {
                        BanyandbCommon.Metadata metadata = writeResponse.getMetadata();
                        log.warn("The schema {}.{} is expired, trying update the schema...", (Object)metadata.getGroup(), (Object)metadata.getName());
                        try {
                            BanyanDBStorageClient.this.client.updateStreamMetadataCacheFromSever(metadata.getGroup(), metadata.getName());
                        }
                        catch (BanyanDBException e) {
                            String warnMessage = String.format("Failed to refresh the stream schema %s.%s", metadata.getGroup(), metadata.getName());
                            log.warn(warnMessage, (Throwable)e);
                        }
                        this.responseException = new InvalidArgumentException("Expired revision: " + metadata.getModRevision(), null, Status.Code.INVALID_ARGUMENT, true);
                        break;
                    }
                    default: {
                        this.responseException = new InternalException(String.format("Internal error (%s) occurs in server", writeResponse.getStatus()), null, Status.Code.INTERNAL, true);
                    }
                }
            }

            public void onError(Throwable throwable) {
                timer.close();
                log.error("Error occurs in flushing streams.", throwable);
                future.completeExceptionally(throwable);
            }

            public void onCompleted() {
                timer.close();
                if (this.responseException == null) {
                    future.complete(null);
                } else {
                    future.completeExceptionally(this.responseException);
                }
            }
        });
        try {
            writeRequestStreamObserver.onNext((Object)((BanyandbStream.WriteRequest)streamWrite.build()));
        }
        finally {
            writeRequestStreamObserver.onCompleted();
        }
        return future;
    }

    public StreamBulkWriteProcessor createStreamBulkProcessor(int maxBulkSize, int flushInterval, int concurrency) {
        Preconditions.checkState((this.client.getStreamServiceStub() != null ? 1 : 0) != 0, (Object)"stream service is null");
        return new StreamBulkWriteProcessor(this.client, maxBulkSize, flushInterval, concurrency, this.flushTimeout, this.streamWriteHistogram, this.options);
    }

    public MeasureBulkWriteProcessor createMeasureBulkProcessor(int maxBulkSize, int flushInterval, int concurrency) {
        Preconditions.checkState((this.client.getMeasureServiceStub() != null ? 1 : 0) != 0, (Object)"measure service is null");
        return new MeasureBulkWriteProcessor(this.client, maxBulkSize, flushInterval, concurrency, this.flushTimeout, this.measureWriteHistogram, this.options);
    }

    public TraceBulkWriteProcessor createTraceBulkProcessor(int maxBulkSize, int flushInterval, int concurrency) {
        return new TraceBulkWriteProcessor(this.client, maxBulkSize, flushInterval, concurrency, this.flushTimeout, this.traceWriteHistogram, this.options);
    }

    public void registerChecker(HealthChecker healthChecker) {
        this.healthChecker.register(healthChecker);
    }

    private void initTelemetry() {
        MetricsCreator metricsCreator = (MetricsCreator)this.moduleManager.find("telemetry").provider().getService(MetricsCreator.class);
        if (this.propertySingleWriteHistogram == null) {
            this.propertySingleWriteHistogram = metricsCreator.createHistogramMetric("banyandb_write_latency", "BanyanDB write/update/delete latency in seconds, bulk_write include write/update", new MetricsTag.Keys(new String[]{"catalog", "operation"}), new MetricsTag.Values(new String[]{"property", "single_write"}), new double[]{0.005, 0.01, 0.025, 0.05, 0.1, 0.25, 0.5, 1.0, 2.5, 5.0, 10.0});
        }
        if (this.propertySingleDeleteHistogram == null) {
            this.propertySingleDeleteHistogram = metricsCreator.createHistogramMetric("banyandb_write_latency", "BanyanDB write/update/delete latency in seconds, bulk_write include write/update", new MetricsTag.Keys(new String[]{"catalog", "operation"}), new MetricsTag.Values(new String[]{"property", "single_delete"}), new double[]{0.005, 0.01, 0.025, 0.05, 0.1, 0.25, 0.5, 1.0, 2.5, 5.0, 10.0});
        }
        if (this.streamSingleWriteHistogram == null) {
            this.streamSingleWriteHistogram = metricsCreator.createHistogramMetric("banyandb_write_latency", "BanyanDB write/update/delete latency in seconds, bulk_write include write/update", new MetricsTag.Keys(new String[]{"catalog", "operation"}), new MetricsTag.Values(new String[]{"stream", "single_write"}), new double[]{0.005, 0.01, 0.025, 0.05, 0.1, 0.25, 0.5, 1.0, 2.5, 5.0, 10.0});
        }
        if (this.measureWriteHistogram == null) {
            this.measureWriteHistogram = metricsCreator.createHistogramMetric("banyandb_write_latency", "BanyanDB write/update/delete latency in seconds, bulk_write include write/update", new MetricsTag.Keys(new String[]{"catalog", "operation"}), new MetricsTag.Values(new String[]{"measure", "bulk_write"}), new double[]{0.005, 0.01, 0.025, 0.05, 0.1, 0.25, 0.5, 1.0, 2.5, 5.0, 10.0});
        }
        if (this.streamWriteHistogram == null) {
            this.streamWriteHistogram = metricsCreator.createHistogramMetric("banyandb_write_latency", "BanyanDB write/update/delete latency in seconds, bulk_write include write/update", new MetricsTag.Keys(new String[]{"catalog", "operation"}), new MetricsTag.Values(new String[]{"stream", "bulk_write"}), new double[]{0.005, 0.01, 0.025, 0.05, 0.1, 0.25, 0.5, 1.0, 2.5, 5.0, 10.0});
        }
        if (this.traceWriteHistogram == null) {
            this.traceWriteHistogram = metricsCreator.createHistogramMetric("banyandb_write_latency", "BanyanDB write/update/delete latency in seconds, bulk_write include write/update", new MetricsTag.Keys(new String[]{"catalog", "operation"}), new MetricsTag.Values(new String[]{"trace", "bulk_write"}), new double[]{0.005, 0.01, 0.025, 0.05, 0.1, 0.25, 0.5, 1.0, 2.5, 5.0, 10.0});
        }
    }
}

