/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.cluster.plugin.kubernetes;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.DynamicEndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.cache.Lister;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesLabelSelectorEndpointGroup
extends DynamicEndpointGroup {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KubernetesLabelSelectorEndpointGroup.class);
    private final KubernetesClient kubernetesClient;
    private final String namespace;
    private final Map<String, String> labelSelector;
    private final int port;
    private final String portName;
    private final SharedIndexInformer<Pod> podInformer;
    private final String selfUid;

    private KubernetesLabelSelectorEndpointGroup(Builder builder) {
        super(builder.selectionStrategy);
        this.kubernetesClient = builder.kubernetesClient;
        this.namespace = builder.namespace;
        this.labelSelector = builder.labelSelector;
        this.port = builder.port;
        this.portName = builder.portName;
        this.selfUid = Strings.nullToEmpty((String)builder.selfUid);
        this.podInformer = ((FilterWatchListDeletable)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(this.namespace)).withLabels(this.labelSelector)).inform((ResourceEventHandler)new PodEventHandler());
        this.updateEndpoints();
    }

    public static Builder builder(KubernetesClient kubernetesClient) {
        return new Builder(kubernetesClient);
    }

    protected void doCloseAsync(CompletableFuture<?> future) {
        if (this.podInformer != null) {
            try {
                this.podInformer.close();
                future.complete(null);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        } else {
            future.complete(null);
        }
    }

    private void updateEndpoints() {
        try {
            if (this.podInformer == null) {
                log.warn("Pod informer is not initialized yet.");
                return;
            }
            Lister podLister = new Lister(this.podInformer.getIndexer());
            List pods = podLister.namespace(this.namespace).list();
            List newEndpoints = pods.stream().filter(this::isPodReady).filter(pod -> StringUtil.isNotBlank((String)pod.getStatus().getPodIP())).filter(pod -> !pod.getMetadata().getUid().equals(this.selfUid)).map(this::createEndpoint).filter(endpoint -> endpoint != null).collect(Collectors.toList());
            log.debug("Updating endpoints to: {}", newEndpoints);
            this.setEndpoints(newEndpoints);
        }
        catch (Exception e) {
            log.error("Failed to update endpoints", (Throwable)e);
        }
    }

    private boolean isPodReady(Pod pod) {
        PodStatus podStatus = pod.getStatus();
        if (podStatus == null) {
            return false;
        }
        if (!"Running".equalsIgnoreCase(podStatus.getPhase())) {
            return false;
        }
        if (podStatus.getContainerStatuses() == null || podStatus.getContainerStatuses().isEmpty()) {
            return false;
        }
        if (podStatus.getConditions() == null || podStatus.getConditions().isEmpty()) {
            return false;
        }
        boolean allContainersReady = podStatus.getContainerStatuses().stream().allMatch(containerStatus -> containerStatus.getReady() != Boolean.FALSE);
        boolean podReadyCondition = podStatus.getConditions().stream().anyMatch(condition -> "Ready".equalsIgnoreCase(condition.getType()) && condition.getStatus() != null && condition.getStatus().equalsIgnoreCase("True"));
        return allContainersReady && podReadyCondition;
    }

    private Endpoint createEndpoint(Pod pod) {
        String podIP = pod.getStatus().getPodIP();
        if (StringUtil.isBlank((String)podIP)) {
            return null;
        }
        int targetPort = this.determineTargetPort(pod);
        if (targetPort <= 0) {
            log.warn("Could not determine target port for pod: {}", (Object)pod.getMetadata().getName());
            return null;
        }
        return Endpoint.of((String)podIP, (int)targetPort);
    }

    private int determineTargetPort(Pod pod) {
        if (this.port > 0) {
            return this.port;
        }
        if (StringUtil.isNotBlank((String)this.portName) && pod.getSpec().getContainers() != null) {
            return pod.getSpec().getContainers().stream().flatMap(container -> container.getPorts() != null ? container.getPorts().stream() : null).filter(containerPort -> this.portName.equals(containerPort.getName())).mapToInt(containerPort -> containerPort.getContainerPort()).findFirst().orElse(-1);
        }
        return -1;
    }

    public static class Builder {
        private final KubernetesClient kubernetesClient;
        private String namespace = "default";
        private Map<String, String> labelSelector = new ConcurrentHashMap<String, String>();
        private int port = -1;
        private String portName;
        private EndpointSelectionStrategy selectionStrategy = EndpointSelectionStrategy.weightedRoundRobin();
        private String selfUid;

        private Builder(KubernetesClient kubernetesClient) {
            this.kubernetesClient = kubernetesClient;
        }

        public KubernetesLabelSelectorEndpointGroup build() {
            if (this.port <= 0 && StringUtil.isBlank((String)this.portName)) {
                throw new IllegalArgumentException("Either port or portName must be specified");
            }
            if (this.labelSelector.isEmpty()) {
                throw new IllegalArgumentException("Label selector must not be empty");
            }
            return new KubernetesLabelSelectorEndpointGroup(this);
        }

        @Generated
        public KubernetesClient kubernetesClient() {
            return this.kubernetesClient;
        }

        @Generated
        public String namespace() {
            return this.namespace;
        }

        @Generated
        public Map<String, String> labelSelector() {
            return this.labelSelector;
        }

        @Generated
        public int port() {
            return this.port;
        }

        @Generated
        public String portName() {
            return this.portName;
        }

        @Generated
        public EndpointSelectionStrategy selectionStrategy() {
            return this.selectionStrategy;
        }

        @Generated
        public String selfUid() {
            return this.selfUid;
        }

        @Generated
        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Generated
        public Builder labelSelector(Map<String, String> labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        @Generated
        public Builder port(int port) {
            this.port = port;
            return this;
        }

        @Generated
        public Builder portName(String portName) {
            this.portName = portName;
            return this;
        }

        @Generated
        public Builder selectionStrategy(EndpointSelectionStrategy selectionStrategy) {
            this.selectionStrategy = selectionStrategy;
            return this;
        }

        @Generated
        public Builder selfUid(String selfUid) {
            this.selfUid = selfUid;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.port() != other.port()) {
                return false;
            }
            KubernetesClient this$kubernetesClient = this.kubernetesClient();
            KubernetesClient other$kubernetesClient = other.kubernetesClient();
            if (this$kubernetesClient == null ? other$kubernetesClient != null : !this$kubernetesClient.equals(other$kubernetesClient)) {
                return false;
            }
            String this$namespace = this.namespace();
            String other$namespace = other.namespace();
            if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
                return false;
            }
            Map<String, String> this$labelSelector = this.labelSelector();
            Map<String, String> other$labelSelector = other.labelSelector();
            if (this$labelSelector == null ? other$labelSelector != null : !((Object)this$labelSelector).equals(other$labelSelector)) {
                return false;
            }
            String this$portName = this.portName();
            String other$portName = other.portName();
            if (this$portName == null ? other$portName != null : !this$portName.equals(other$portName)) {
                return false;
            }
            EndpointSelectionStrategy this$selectionStrategy = this.selectionStrategy();
            EndpointSelectionStrategy other$selectionStrategy = other.selectionStrategy();
            if (this$selectionStrategy == null ? other$selectionStrategy != null : !this$selectionStrategy.equals(other$selectionStrategy)) {
                return false;
            }
            String this$selfUid = this.selfUid();
            String other$selfUid = other.selfUid();
            return !(this$selfUid == null ? other$selfUid != null : !this$selfUid.equals(other$selfUid));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Builder;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.port();
            KubernetesClient $kubernetesClient = this.kubernetesClient();
            result = result * 59 + ($kubernetesClient == null ? 43 : $kubernetesClient.hashCode());
            String $namespace = this.namespace();
            result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
            Map<String, String> $labelSelector = this.labelSelector();
            result = result * 59 + ($labelSelector == null ? 43 : ((Object)$labelSelector).hashCode());
            String $portName = this.portName();
            result = result * 59 + ($portName == null ? 43 : $portName.hashCode());
            EndpointSelectionStrategy $selectionStrategy = this.selectionStrategy();
            result = result * 59 + ($selectionStrategy == null ? 43 : $selectionStrategy.hashCode());
            String $selfUid = this.selfUid();
            result = result * 59 + ($selfUid == null ? 43 : $selfUid.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "KubernetesLabelSelectorEndpointGroup.Builder(kubernetesClient=" + String.valueOf(this.kubernetesClient()) + ", namespace=" + this.namespace() + ", labelSelector=" + String.valueOf(this.labelSelector()) + ", port=" + this.port() + ", portName=" + this.portName() + ", selectionStrategy=" + String.valueOf(this.selectionStrategy()) + ", selfUid=" + this.selfUid() + ")";
        }
    }

    private class PodEventHandler
    implements ResourceEventHandler<Pod> {
        private PodEventHandler() {
        }

        public void onAdd(Pod pod) {
            log.debug("Pod added: {}", (Object)pod.getMetadata().getName());
            KubernetesLabelSelectorEndpointGroup.this.updateEndpoints();
        }

        public void onUpdate(Pod oldPod, Pod newPod) {
            log.debug("Pod updated: {}, {}", (Object)newPod.getMetadata().getName(), (Object)newPod.getStatus());
            KubernetesLabelSelectorEndpointGroup.this.updateEndpoints();
        }

        public void onDelete(Pod pod, boolean deletedFinalStateUnknown) {
            log.debug("Pod deleted: {}", (Object)pod.getMetadata().getName());
            KubernetesLabelSelectorEndpointGroup.this.updateEndpoints();
        }
    }
}

