/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.io.Closeable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.OutputFormat;
import org.apache.hive.beeline.Rows;
import org.supercsv.io.CsvListWriter;
import org.supercsv.prefs.CsvPreference;

class SeparatedValuesOutputFormat
implements OutputFormat {
    public static final String DISABLE_QUOTING_FOR_SV = "disable.quoting.for.sv";
    private final BeeLine beeLine;
    private CsvPreference quotedCsvPreference;
    private CsvPreference unquotedCsvPreference;

    SeparatedValuesOutputFormat(BeeLine beeLine, char separator) {
        this.beeLine = beeLine;
        this.unquotedCsvPreference = new CsvPreference.Builder('\u0000', (int)separator, "").build();
        this.quotedCsvPreference = new CsvPreference.Builder('\"', (int)separator, "").build();
    }

    private void updateCsvPreference() {
        if (this.beeLine.getOpts().getOutputFormat().equals("dsv")) {
            char curDel = (char)this.getCsvPreference().getDelimiterChar();
            char newDel = this.beeLine.getOpts().getDelimiterForDSV();
            if (newDel != curDel) {
                if (this.isQuotingDisabled()) {
                    this.unquotedCsvPreference = new CsvPreference.Builder('\u0000', (int)newDel, "").build();
                } else {
                    this.quotedCsvPreference = new CsvPreference.Builder('\"', (int)newDel, "").build();
                }
            }
        }
    }

    @Override
    public int print(Rows rows) {
        this.updateCsvPreference();
        int count = 0;
        while (rows.hasNext()) {
            if (count == 0 && !this.beeLine.getOpts().getShowHeader()) {
                rows.next();
                ++count;
                continue;
            }
            this.printRow((Rows.Row)rows.next());
            ++count;
        }
        return count - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFormattedStr(String[] vals) {
        StringWriter strWriter = new StringWriter();
        CsvListWriter writer = new CsvListWriter((Writer)strWriter, this.getCsvPreference());
        if (vals.length > 0) {
            try {
                writer.write(vals);
            }
            catch (IOException e) {
                this.beeLine.error(e);
            }
            finally {
                IOUtils.closeStream((Closeable)writer);
            }
        }
        return strWriter.toString();
    }

    private void printRow(Rows.Row row) {
        String[] vals = row.values;
        String formattedStr = this.getFormattedStr(vals);
        this.beeLine.output(formattedStr);
    }

    private boolean isQuotingDisabled() {
        String quotingDisabledStr = System.getProperty(DISABLE_QUOTING_FOR_SV);
        if (quotingDisabledStr == null || quotingDisabledStr.isEmpty()) {
            return true;
        }
        String parsedOptionStr = quotingDisabledStr.toLowerCase();
        if (parsedOptionStr.equals("false") || parsedOptionStr.equals("true")) {
            return Boolean.parseBoolean(parsedOptionStr);
        }
        this.beeLine.error("System Property disable.quoting.for.sv is now " + parsedOptionStr + " which only accepts boolean value");
        return true;
    }

    private CsvPreference getCsvPreference() {
        if (this.isQuotingDisabled()) {
            return this.unquotedCsvPreference;
        }
        return this.quotedCsvPreference;
    }
}

