/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Abs$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.MathUtils$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerExactNumeric$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongExactNumeric$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the absolute value of the numeric or interval value.", examples="\n    Examples:\n      > SELECT _FUNC_(-1);\n       1\n      > SELECT _FUNC_(INTERVAL -'1-1' YEAR TO MONTH);\n       1-1\n  ", since="1.2.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\u0015a\u0001B\u0011#\u0001>B\u0001b\u0014\u0001\u0003\u0016\u0004%\t\u0001\u0015\u0005\t)\u0002\u0011\t\u0012)A\u0005#\"AQ\u000b\u0001BK\u0002\u0013\u0005a\u000b\u0003\u0005[\u0001\tE\t\u0015!\u0003X\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u0015Y\u0006\u0001\"\u0001a\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0011\u0015i\u0007\u0001\"\u0011o\u0011!\u0011\b\u0001#b\u0001\n\u0013\u0019\b\"\u0002>\u0001\t\u0003Z\bbBA\n\u0001\u0011E\u0013Q\u0003\u0005\b\u00037\u0001A\u0011IA\u000f\u0011\u001d\t)\u0003\u0001C)\u0003OA\u0011\"!\f\u0001\u0003\u0003%\t!a\f\t\u0013\u0005U\u0002!%A\u0005\u0002\u0005]\u0002\"CA'\u0001E\u0005I\u0011AA(\u0011%\t\u0019\u0006AA\u0001\n\u0003\n)\u0006C\u0005\u0002h\u0001\t\t\u0011\"\u0001\u0002j!I\u0011\u0011\u000f\u0001\u0002\u0002\u0013\u0005\u00111\u000f\u0005\n\u0003s\u0002\u0011\u0011!C!\u0003wB\u0011\"a\"\u0001\u0003\u0003%\t!!#\t\u0013\u00055\u0005!!A\u0005B\u0005=\u0005\"CAJ\u0001\u0005\u0005I\u0011IAK\u000f%\tILIA\u0001\u0012\u0003\tYL\u0002\u0005\"E\u0005\u0005\t\u0012AA_\u0011\u0019Y\u0016\u0004\"\u0001\u0002V\"I\u0011q[\r\u0002\u0002\u0013\u0015\u0013\u0011\u001c\u0005\n\u00037L\u0012\u0011!CA\u0003;D\u0011\"a9\u001a#\u0003%\t!a\u0014\t\u0013\u0005\u0015\u0018$!A\u0005\u0002\u0006\u001d\b\"CA}3E\u0005I\u0011AA(\u0011%\tY0GA\u0001\n\u0013\tiPA\u0002BENT!a\t\u0013\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003K\u0019\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003O!\n1a]9m\u0015\tI#&A\u0003ta\u0006\u00148N\u0003\u0002,Y\u00051\u0011\r]1dQ\u0016T\u0011!L\u0001\u0004_J<7\u0001A\n\u0007\u0001A\"tG\u0010#\u0011\u0005E\u0012T\"\u0001\u0012\n\u0005M\u0012#aD+oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005E*\u0014B\u0001\u001c#\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001\u001d<\u001d\t\t\u0014(\u0003\u0002;E\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u001f>\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!A\u000f\u0012\u0011\u0005}\u0012U\"\u0001!\u000b\u0003\u0005\u000bQa]2bY\u0006L!a\u0011!\u0003\u000fA\u0013x\u000eZ;diB\u0011Q\t\u0014\b\u0003\r.s!a\u0012&\u000e\u0003!S!!\u0013\u0018\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0015B\u0001\u001eA\u0013\tieJ\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002;\u0001\u0006)1\r[5mIV\t\u0011\u000b\u0005\u00022%&\u00111K\t\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%A\u0006gC&dwJ\\#se>\u0014X#A,\u0011\u0005}B\u0016BA-A\u0005\u001d\u0011un\u001c7fC:\fABZ1jY>sWI\u001d:pe\u0002\na\u0001P5oSRtDcA/_?B\u0011\u0011\u0007\u0001\u0005\u0006\u001f\u0016\u0001\r!\u0015\u0005\b+\u0016\u0001\n\u00111\u0001X)\ti\u0016\rC\u0003P\r\u0001\u0007\u0011+\u0001\u0006j]B,H\u000fV=qKN,\u0012\u0001\u001a\t\u0004\u000b\u0016<\u0017B\u00014O\u0005\r\u0019V-\u001d\t\u0003Q.l\u0011!\u001b\u0006\u0003U\u001a\nQ\u0001^=qKNL!\u0001\\5\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003=\u0004\"\u0001\u001b9\n\u0005EL'\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u000f9,X.\u001a:jGV\tA\u000fE\u0002Fk^L!A\u001e(\u0003\u000f9+X.\u001a:jGB\u0011q\b_\u0005\u0003s\u0002\u00131!\u00118z\u0003%!wnR3o\u0007>$W\rF\u0003}\u0003\u000b\ty\u0001E\u0002~\u0003\u0003i\u0011A \u0006\u0003\u007f\n\nqaY8eK\u001e,g.C\u0002\u0002\u0004y\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u0003\u000fQ\u0001\u0019AA\u0005\u0003\r\u0019G\u000f\u001f\t\u0004{\u0006-\u0011bAA\u0007}\nq1i\u001c3fO\u0016t7i\u001c8uKb$\bBBA\t\u0015\u0001\u0007A0\u0001\u0002fm\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u0019q/a\u0006\t\r\u0005e1\u00021\u0001x\u0003\u0015Ig\u000e];u\u000351G.\u0019;Be\u001e,X.\u001a8ugV\u0011\u0011q\u0004\t\u0005\u000b\u0006\u0005r/C\u0002\u0002$9\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\u0015o&$\bNT3x\u0007\"LG\u000eZ%oi\u0016\u0014h.\u00197\u0015\u0007u\u000bI\u0003\u0003\u0004\u0002,5\u0001\r!U\u0001\t]\u0016<8\t[5mI\u0006!1m\u001c9z)\u0015i\u0016\u0011GA\u001a\u0011\u001dye\u0002%AA\u0002ECq!\u0016\b\u0011\u0002\u0003\u0007q+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005e\"fA)\u0002<-\u0012\u0011Q\b\t\u0005\u0003\u007f\tI%\u0004\u0002\u0002B)!\u00111IA#\u0003%)hn\u00195fG.,GMC\u0002\u0002H\u0001\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\tY%!\u0011\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005E#fA,\u0002<\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0016\u0011\t\u0005e\u00131M\u0007\u0003\u00037RA!!\u0018\u0002`\u0005!A.\u00198h\u0015\t\t\t'\u0001\u0003kCZ\f\u0017\u0002BA3\u00037\u0012aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA6!\ry\u0014QN\u0005\u0004\u0003_\u0002%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA<\u0002v!I\u0011qO\n\u0002\u0002\u0003\u0007\u00111N\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005u\u0004#BA@\u0003\u000b;XBAAA\u0015\r\t\u0019\tQ\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0012\u0003\u0003\u000b\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004/\u0006-\u0005\u0002CA<+\u0005\u0005\t\u0019A<\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003/\n\t\nC\u0005\u0002xY\t\t\u00111\u0001\u0002l\u00051Q-];bYN$2aVAL\u0011!\t9hFA\u0001\u0002\u00049\bf\u0005\u0001\u0002\u001c\u0006\u0005\u00161UAT\u0003S\u000bi+a,\u00024\u0006U\u0006cA\u0019\u0002\u001e&\u0019\u0011q\u0014\u0012\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011QU\u0001L?\u001a+fjQ0)Kb\u0004(/\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011bEN|G.\u001e;fAY\fG.^3!_\u001a\u0004C\u000f[3!]VlWM]5dA=\u0014\b%\u001b8uKJ4\u0018\r\u001c\u0011wC2,XML\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u00111V\u0001w\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"j\u0013'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!c)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013J\u0014+F%Z\u000bE\nI\u0017(c5\nt\u0005I-F\u0003J\u0003Ck\u0014\u0011N\u001f:#\u0006*K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!c5\n$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005E\u0016!B\u0019/e9\u0002\u0014!B4s_V\u0004\u0018EAA\\\u0003)i\u0017\r\u001e5`MVt7m]\u0001\u0004\u0003\n\u001c\bCA\u0019\u001a'\u0015I\u0012qXAf!\u001d\t\t-a2R/vk!!a1\u000b\u0007\u0005\u0015\u0007)A\u0004sk:$\u0018.\\3\n\t\u0005%\u00171\u0019\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003BAg\u0003'l!!a4\u000b\t\u0005E\u0017qL\u0001\u0003S>L1!TAh)\t\tY,\u0001\u0005u_N#(/\u001b8h)\t\t9&A\u0003baBd\u0017\u0010F\u0003^\u0003?\f\t\u000fC\u0003P9\u0001\u0007\u0011\u000bC\u0004V9A\u0005\t\u0019A,\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002j\u0006U\b#B \u0002l\u0006=\u0018bAAw\u0001\n1q\n\u001d;j_:\u0004RaPAy#^K1!a=A\u0005\u0019!V\u000f\u001d7fe!A\u0011q\u001f\u0010\u0002\u0002\u0003\u0007Q,A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAA\u0000!\u0011\tIF!\u0001\n\t\t\r\u00111\f\u0002\u0007\u001f\nTWm\u0019;")
public class Abs
extends UnaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private Numeric<Object> numeric;
    private final Expression child;
    private final boolean failOnError;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$2() {
        return Abs$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(Abs x$0) {
        return Abs$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$2() {
        return Abs$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Expression, Object>, Abs> tupled() {
        return Abs$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, Abs>> curried() {
        return Abs$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.NumericAndAnsiInterval()}));
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    private Numeric<Object> numeric$lzycompute() {
        Abs abs = this;
        synchronized (abs) {
            if (!this.bitmap$0) {
                DataType dataType = this.dataType();
                Object object = dataType instanceof DayTimeIntervalType ? LongExactNumeric$.MODULE$ : (dataType instanceof YearMonthIntervalType ? IntegerExactNumeric$.MODULE$ : TypeUtils$.MODULE$.getNumeric(this.dataType(), this.failOnError()));
                this.numeric = object;
                this.bitmap$0 = true;
            }
        }
        return this.numeric;
    }

    private Numeric<Object> numeric() {
        return !this.bitmap$0 ? this.numeric$lzycompute() : this.numeric;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        DataType dataType = this.dataType();
        if (dataType instanceof DecimalType) {
            exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> new StringBuilder(6).append((String)c).append(".abs()").toString());
        } else {
            boolean bl = ByteType$.MODULE$.equals(dataType) ? true : ShortType$.MODULE$.equals(dataType);
            if (bl && this.failOnError()) {
                String javaBoxedType = CodeGenerator$.MODULE$.boxedType(this.dataType());
                String javaType = CodeGenerator$.MODULE$.javaType(this.dataType());
                exprCode = this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)eval -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(219).append("\n          |if (").append((String)eval).append(" == ").append(javaBoxedType).append(".MIN_VALUE) {\n          |  throw QueryExecutionErrors.unaryMinusCauseOverflowError(").append((String)eval).append(");\n          |} else if (").append((String)eval).append(" < 0) {\n          |  ").append(ev.value()).append(" = (").append(javaType).append(")-").append((String)eval).append(";\n          |} else {\n          |  ").append(ev.value()).append(" = ").append((String)eval).append(";\n          |}\n          |").toString())));
            } else {
                boolean bl2 = IntegerType$.MODULE$.equals(dataType) ? true : LongType$.MODULE$.equals(dataType);
                if (bl2 && this.failOnError()) {
                    String mathUtils = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(MathUtils$.MODULE$.getClass().getCanonicalName()), "$");
                    exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> new StringBuilder(24).append((String)c).append(" < 0 ? ").append(mathUtils).append(".negateExact(").append((String)c).append(") : ").append((String)c).toString());
                } else if (dataType instanceof AnsiIntervalType) {
                    String mathUtils = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(MathUtils$.MODULE$.getClass().getCanonicalName()), "$");
                    exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> new StringBuilder(24).append((String)c).append(" < 0 ? ").append(mathUtils).append(".negateExact(").append((String)c).append(") : ").append((String)c).toString());
                } else if (dataType instanceof NumericType) {
                    NumericType numericType = (NumericType)dataType;
                    exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> new StringBuilder(24).append("(").append(CodeGenerator$.MODULE$.javaType((DataType)numericType)).append(")(java.lang.Math.abs(").append((String)c).append("))").toString());
                } else {
                    throw new MatchError((Object)dataType);
                }
            }
        }
        return exprCode;
    }

    @Override
    public Object nullSafeEval(Object input) {
        return this.numeric().abs(input);
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child()}));
    }

    @Override
    public Abs withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public Abs copy(Expression child, boolean failOnError) {
        return new Abs(child, failOnError);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "Abs";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Abs;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            case 1: {
                string = "failOnError";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Abs)) return false;
        boolean bl = true;
        if (!bl) return false;
        Abs abs = (Abs)x$1;
        if (this.failOnError() != abs.failOnError()) return false;
        Expression expression = this.child();
        Expression expression2 = abs.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!abs.canEqual(this)) return false;
        return true;
    }

    public Abs(Expression child, boolean failOnError) {
        this.child = child;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
    }

    public Abs(Expression child) {
        this(child, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

