/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.streaming;

import java.io.Serializable;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.spark.SparkConf;
import org.apache.spark.examples.streaming.StreamingExamples$;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStream$;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.kafka010.ConsumerStrategies$;
import org.apache.spark.streaming.kafka010.KafkaUtils$;
import org.apache.spark.streaming.kafka010.LocationStrategies$;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction2;

public final class DirectKafkaWordCount$ {
    public static final DirectKafkaWordCount$ MODULE$ = new DirectKafkaWordCount$();

    public void main(String[] args) {
        Object object;
        if (args.length < 3) {
            System.err.println(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |Usage: DirectKafkaWordCount <brokers> <groupId> <topics>\n        |  <brokers> is a list of one or more Kafka brokers\n        |  <groupId> is a consumer group name to consume from topics\n        |  <topics> is a list of one or more kafka topics to consume from\n        |\n        ")));
            System.exit(1);
        }
        StreamingExamples$.MODULE$.setStreamingLogLevels();
        String[] stringArray = args;
        if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 3) != 0) {
            throw new MatchError((Object)stringArray);
        }
        String brokers = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
        String groupId = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
        String topics = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2);
        Tuple3 tuple3 = new Tuple3((Object)brokers, (Object)groupId, (Object)topics);
        Tuple3 tuple32 = tuple3;
        String brokers2 = (String)tuple32._1();
        String groupId2 = (String)tuple32._2();
        String topics2 = (String)tuple32._3();
        SparkConf sparkConf = new SparkConf().setAppName("DirectKafkaWordCount");
        StreamingContext ssc = new StreamingContext(sparkConf, Seconds$.MODULE$.apply(2L));
        Set topicsSet = Predef$.MODULE$.wrapRefArray((Object[])topics2.split(",")).toSet();
        scala.collection.immutable.Map kafkaParams = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)brokers2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group.id"), (Object)groupId2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key.deserializer"), StringDeserializer.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value.deserializer"), StringDeserializer.class)}));
        InputDStream messages = KafkaUtils$.MODULE$.createDirectStream(ssc, LocationStrategies$.MODULE$.PreferConsistent(), ConsumerStrategies$.MODULE$.Subscribe((Iterable)topicsSet, (Map)kafkaParams));
        DStream lines = messages.map((Function1 & Serializable)x$2 -> (String)x$2.value(), ClassTag$.MODULE$.apply(String.class));
        DStream words = lines.flatMap((Function1 & Serializable)x$3 -> Predef$.MODULE$.wrapRefArray((Object[])x$3.split(" ")), ClassTag$.MODULE$.apply(String.class));
        DStream wordCounts = DStream$.MODULE$.toPairDStreamFunctions(words.map((Function1 & Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToLong((long)1L)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Long(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)(JFunction2.mcJJJ.sp & Serializable)(x$4, x$5) -> x$4 + x$5);
        wordCounts.print();
        ssc.start();
        ssc.awaitTermination();
    }

    private DirectKafkaWordCount$() {
    }
}

