/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.net.URL;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.hadoop.hive.ql.exec.UDFClassLoader;
import org.apache.hadoop.hive.ql.exec.Utilities;

public class AddToClassPathAction
implements PrivilegedAction<UDFClassLoader> {
    private final ClassLoader parentLoader;
    private final Collection<String> newPaths;
    private final boolean forceNewClassLoader;

    public AddToClassPathAction(ClassLoader parentLoader, Collection<String> newPaths, boolean forceNewClassLoader) {
        this.parentLoader = parentLoader;
        this.newPaths = newPaths != null ? newPaths : Collections.EMPTY_LIST;
        this.forceNewClassLoader = forceNewClassLoader;
        if (parentLoader == null) {
            throw new IllegalArgumentException("UDFClassLoader is not designed to be a bootstrap class loader!");
        }
    }

    public AddToClassPathAction(ClassLoader parentLoader, Collection<String> newPaths) {
        this(parentLoader, newPaths, false);
    }

    @Override
    public UDFClassLoader run() {
        if (this.useExistingClassLoader()) {
            UDFClassLoader udfClassLoader = (UDFClassLoader)this.parentLoader;
            for (String path : this.newPaths) {
                udfClassLoader.addURL(Utilities.urlFromPathString(path));
            }
            return udfClassLoader;
        }
        return this.createUDFClassLoader();
    }

    private boolean useExistingClassLoader() {
        if (!this.forceNewClassLoader && this.parentLoader instanceof UDFClassLoader) {
            UDFClassLoader udfClassLoader = (UDFClassLoader)this.parentLoader;
            return !udfClassLoader.isClosed();
        }
        return false;
    }

    private UDFClassLoader createUDFClassLoader() {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : this.newPaths) {
            URL url = Utilities.urlFromPathString(path);
            if (url == null) continue;
            urls.add(url);
        }
        return new UDFClassLoader(urls.toArray(new URL[urls.size()]), this.parentLoader);
    }
}

