/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class HiveExternalCatalog$ {
    public static final HiveExternalCatalog$ MODULE$ = new HiveExternalCatalog$();
    private static final String SPARK_SQL_PREFIX = "spark.sql.";
    private static final String DATASOURCE_PREFIX = new StringBuilder(8).append(MODULE$.SPARK_SQL_PREFIX()).append("sources.").toString();
    private static final String DATASOURCE_PROVIDER = new StringBuilder(8).append(MODULE$.DATASOURCE_PREFIX()).append("provider").toString();
    private static final String DATASOURCE_SCHEMA = new StringBuilder(6).append(MODULE$.DATASOURCE_PREFIX()).append("schema").toString();
    private static final String DATASOURCE_SCHEMA_PREFIX = new StringBuilder(1).append(MODULE$.DATASOURCE_SCHEMA()).append(".").toString();
    private static final String DATASOURCE_SCHEMA_NUMPARTCOLS = new StringBuilder(11).append(MODULE$.DATASOURCE_SCHEMA_PREFIX()).append("numPartCols").toString();
    private static final String DATASOURCE_SCHEMA_NUMSORTCOLS = new StringBuilder(11).append(MODULE$.DATASOURCE_SCHEMA_PREFIX()).append("numSortCols").toString();
    private static final String DATASOURCE_SCHEMA_NUMBUCKETS = new StringBuilder(10).append(MODULE$.DATASOURCE_SCHEMA_PREFIX()).append("numBuckets").toString();
    private static final String DATASOURCE_SCHEMA_NUMBUCKETCOLS = new StringBuilder(13).append(MODULE$.DATASOURCE_SCHEMA_PREFIX()).append("numBucketCols").toString();
    private static final String DATASOURCE_SCHEMA_PART_PREFIX = new StringBuilder(5).append(MODULE$.DATASOURCE_SCHEMA_PREFIX()).append("part.").toString();
    private static final String DATASOURCE_SCHEMA_PARTCOL_PREFIX = new StringBuilder(8).append(MODULE$.DATASOURCE_SCHEMA_PREFIX()).append("partCol.").toString();
    private static final String DATASOURCE_SCHEMA_BUCKETCOL_PREFIX = new StringBuilder(10).append(MODULE$.DATASOURCE_SCHEMA_PREFIX()).append("bucketCol.").toString();
    private static final String DATASOURCE_SCHEMA_SORTCOL_PREFIX = new StringBuilder(8).append(MODULE$.DATASOURCE_SCHEMA_PREFIX()).append("sortCol.").toString();
    private static final String STATISTICS_PREFIX = new StringBuilder(11).append(MODULE$.SPARK_SQL_PREFIX()).append("statistics.").toString();
    private static final String STATISTICS_TOTAL_SIZE = new StringBuilder(9).append(MODULE$.STATISTICS_PREFIX()).append("totalSize").toString();
    private static final String STATISTICS_NUM_ROWS = new StringBuilder(7).append(MODULE$.STATISTICS_PREFIX()).append("numRows").toString();
    private static final String STATISTICS_COL_STATS_PREFIX = new StringBuilder(9).append(MODULE$.STATISTICS_PREFIX()).append("colStats.").toString();
    private static final String TABLE_PARTITION_PROVIDER = new StringBuilder(17).append(MODULE$.SPARK_SQL_PREFIX()).append("partitionProvider").toString();
    private static final String TABLE_PARTITION_PROVIDER_CATALOG = "catalog";
    private static final String TABLE_PARTITION_PROVIDER_FILESYSTEM = "filesystem";
    private static final String CREATED_SPARK_VERSION = new StringBuilder(14).append(MODULE$.SPARK_SQL_PREFIX()).append("create.version").toString();
    private static final Set<String> HIVE_GENERATED_TABLE_PROPERTIES = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"transient_lastDdlTime"}));
    private static final Set<String> HIVE_GENERATED_STORAGE_PROPERTIES = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"serialization.format"}));
    private static final StructType EMPTY_DATA_SCHEMA = new StructType().add("col", "array<string>", true, "from deserializer");

    public String SPARK_SQL_PREFIX() {
        return SPARK_SQL_PREFIX;
    }

    public String DATASOURCE_PREFIX() {
        return DATASOURCE_PREFIX;
    }

    public String DATASOURCE_PROVIDER() {
        return DATASOURCE_PROVIDER;
    }

    public String DATASOURCE_SCHEMA() {
        return DATASOURCE_SCHEMA;
    }

    public String DATASOURCE_SCHEMA_PREFIX() {
        return DATASOURCE_SCHEMA_PREFIX;
    }

    public String DATASOURCE_SCHEMA_NUMPARTCOLS() {
        return DATASOURCE_SCHEMA_NUMPARTCOLS;
    }

    public String DATASOURCE_SCHEMA_NUMSORTCOLS() {
        return DATASOURCE_SCHEMA_NUMSORTCOLS;
    }

    public String DATASOURCE_SCHEMA_NUMBUCKETS() {
        return DATASOURCE_SCHEMA_NUMBUCKETS;
    }

    public String DATASOURCE_SCHEMA_NUMBUCKETCOLS() {
        return DATASOURCE_SCHEMA_NUMBUCKETCOLS;
    }

    public String DATASOURCE_SCHEMA_PART_PREFIX() {
        return DATASOURCE_SCHEMA_PART_PREFIX;
    }

    public String DATASOURCE_SCHEMA_PARTCOL_PREFIX() {
        return DATASOURCE_SCHEMA_PARTCOL_PREFIX;
    }

    public String DATASOURCE_SCHEMA_BUCKETCOL_PREFIX() {
        return DATASOURCE_SCHEMA_BUCKETCOL_PREFIX;
    }

    public String DATASOURCE_SCHEMA_SORTCOL_PREFIX() {
        return DATASOURCE_SCHEMA_SORTCOL_PREFIX;
    }

    public String STATISTICS_PREFIX() {
        return STATISTICS_PREFIX;
    }

    public String STATISTICS_TOTAL_SIZE() {
        return STATISTICS_TOTAL_SIZE;
    }

    public String STATISTICS_NUM_ROWS() {
        return STATISTICS_NUM_ROWS;
    }

    public String STATISTICS_COL_STATS_PREFIX() {
        return STATISTICS_COL_STATS_PREFIX;
    }

    public String TABLE_PARTITION_PROVIDER() {
        return TABLE_PARTITION_PROVIDER;
    }

    public String TABLE_PARTITION_PROVIDER_CATALOG() {
        return TABLE_PARTITION_PROVIDER_CATALOG;
    }

    public String TABLE_PARTITION_PROVIDER_FILESYSTEM() {
        return TABLE_PARTITION_PROVIDER_FILESYSTEM;
    }

    public String CREATED_SPARK_VERSION() {
        return CREATED_SPARK_VERSION;
    }

    public Set<String> HIVE_GENERATED_TABLE_PROPERTIES() {
        return HIVE_GENERATED_TABLE_PROPERTIES;
    }

    public Set<String> HIVE_GENERATED_STORAGE_PROPERTIES() {
        return HIVE_GENERATED_STORAGE_PROPERTIES;
    }

    public StructType EMPTY_DATA_SCHEMA() {
        return EMPTY_DATA_SCHEMA;
    }

    private Seq<String> getColumnNamesByType(Map<String, String> props, String colType, String typeName) {
        return (Seq)Option$.MODULE$.option2Iterable(props.get((Object)new StringBuilder(32).append("spark.sql.sources.schema.num").append(StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString(colType))).append("Cols").toString())).toSeq().flatMap((Function1 & Serializable)numCols -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(numCols))).map((Function1 & Serializable)index -> HiveExternalCatalog$.$anonfun$getColumnNamesByType$2(props, colType, typeName, numCols, BoxesRunTime.unboxToInt((Object)index))));
    }

    public Seq<String> org$apache$spark$sql$hive$HiveExternalCatalog$$getPartitionColumnsFromTableProperties(CatalogTable metadata) {
        return this.getColumnNamesByType((Map<String, String>)metadata.properties(), "part", "partitioning columns");
    }

    public Option<BucketSpec> org$apache$spark$sql$hive$HiveExternalCatalog$$getBucketSpecFromTableProperties(CatalogTable metadata) {
        return metadata.properties().get((Object)this.DATASOURCE_SCHEMA_NUMBUCKETS()).map((Function1 & Serializable)numBuckets -> new BucketSpec(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(numBuckets)), MODULE$.getColumnNamesByType((Map<String, String>)metadata.properties(), "bucket", "bucketing columns"), MODULE$.getColumnNamesByType((Map<String, String>)metadata.properties(), "sort", "sorting columns")));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDatasourceTable(CatalogTable table) {
        Option provider = table.provider().orElse((Function0 & Serializable)() -> table.properties().get((Object)MODULE$.DATASOURCE_PROVIDER()));
        if (!provider.isDefined()) return false;
        Option option = provider;
        Some some = new Some((Object)DDLUtils$.MODULE$.HIVE_PROVIDER());
        if (option == null) {
            if (some == null) return false;
            return true;
        } else if (option.equals(some)) return false;
        return true;
    }

    public boolean isHiveCompatibleDataType(DataType dt) {
        boolean bl;
        block5: {
            block6: {
                while (true) {
                    DataType dataType;
                    if ((dataType = dt) instanceof AnsiIntervalType) {
                        bl = false;
                        break block5;
                    }
                    if (dataType instanceof TimestampNTZType) {
                        bl = false;
                        break block5;
                    }
                    if (dataType instanceof StructType) {
                        StructType structType = (StructType)dataType;
                        bl = structType.forall((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HiveExternalCatalog$.MODULE$.isHiveCompatibleDataType(f.dataType())));
                        break block5;
                    }
                    if (dataType instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)dataType;
                        dt = arrayType.elementType();
                        continue;
                    }
                    if (!(dataType instanceof MapType)) break block6;
                    MapType mapType = (MapType)dataType;
                    if (!this.isHiveCompatibleDataType(mapType.keyType())) break;
                    dt = mapType.valueType();
                }
                bl = false;
                break block5;
            }
            bl = true;
        }
        return bl;
    }

    public static final /* synthetic */ String $anonfun$getColumnNamesByType$2(Map props$1, String colType$1, String typeName$1, String numCols$1, int index) {
        return (String)props$1.getOrElse((Object)new StringBuilder(4).append(MODULE$.DATASOURCE_SCHEMA_PREFIX()).append(colType$1).append("Col.").append(index).toString(), (Function0 & Serializable)() -> {
            throw new AnalysisException(new StringBuilder(61).append("Corrupted ").append(typeName$1).append(" in catalog: ").append(numCols$1).append(" parts expected, but part ").append(index).append(" is missing.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
        });
    }

    private HiveExternalCatalog$() {
    }
}

