/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.util.Random;

public final class SparkTC$ {
    public static SparkTC$ MODULE$;
    private final int numEdges;
    private final int numVertices;
    private final Random rand;

    static {
        new SparkTC$();
    }

    public int numEdges() {
        return this.numEdges;
    }

    public int numVertices() {
        return this.numVertices;
    }

    public Random rand() {
        return this.rand;
    }

    public Seq<Tuple2<Object, Object>> generateGraph() {
        Set edges = Set$.MODULE$.empty();
        while (edges.size() < this.numEdges()) {
            int to;
            int from = this.rand().nextInt(this.numVertices());
            Object object = from != (to = this.rand().nextInt(this.numVertices())) ? edges.$plus$eq((Object)new Tuple2.mcII.sp(from, to)) : BoxedUnit.UNIT;
        }
        return edges.toSeq();
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("SparkTC").getOrCreate();
        int slices = args.length > 0 ? new StringOps(Predef$.MODULE$.augmentString(args[0])).toInt() : 2;
        RDD tc = spark.sparkContext().parallelize(this.generateGraph(), slices, ClassTag$.MODULE$.apply(Tuple2.class)).cache();
        RDD edges = tc.map((Function1 & java.io.Serializable & Serializable)x -> new Tuple2.mcII.sp(x._2$mcI$sp(), x._1$mcI$sp()), ClassTag$.MODULE$.apply(Tuple2.class));
        long oldCount = 0L;
        long nextCount = tc.count();
        do {
            oldCount = nextCount;
        } while ((nextCount = (tc = tc.union(RDD$.MODULE$.rddToPairRDDFunctions(tc, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).join(edges).map((Function1 & java.io.Serializable & Serializable)x -> new Tuple2.mcII.sp(((Tuple2)x._2())._2$mcI$sp(), ((Tuple2)x._2())._1$mcI$sp()), ClassTag$.MODULE$.apply(Tuple2.class))).distinct().cache()).count()) != oldCount);
        Predef$.MODULE$.println((Object)new StringBuilder(14).append("TC has ").append(tc.count()).append(" edges.").toString());
        spark.stop();
    }

    private SparkTC$() {
        MODULE$ = this;
        this.numEdges = 200;
        this.numVertices = 100;
        this.rand = new Random(42);
    }
}

