/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.Correlations;
import org.apache.spark.examples.mllib.Correlations$Params$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.stat.Statistics$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.sys.package$;
import scopt.OptionParser;
import scopt.Read$;

public final class Correlations$ {
    public static Correlations$ MODULE$;

    static {
        new Correlations$();
    }

    public void main(String[] args) {
        Correlations.Params defaultParams = new Correlations.Params(Correlations$Params$.MODULE$.apply$default$1());
        OptionParser<Correlations.Params> parser = new OptionParser<Correlations.Params>(defaultParams){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Correlations: an example app for computing correlations"}));
                this.opt("input", Read$.MODULE$.stringRead()).text(new StringBuilder(58).append("Input path to labeled examples in LIBSVM format, default: ").append(defaultParams$1.input()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> c.copy((String)x));
                this.note(new StringOps(Predef$.MODULE$.augmentString("\n        |For example, the following command runs this app on a synthetic dataset:\n        |\n        | bin/spark-submit --class org.apache.spark.examples.mllib.Correlations \\\n        |  examples/target/scala-*/spark-examples-*.jar \\\n        |  --input data/mllib/sample_linear_regression_data.txt\n        ")).stripMargin());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1(java.lang.String org.apache.spark.examples.mllib.Correlations$Params )}, serializedLambda);
            }
        };
        Option option = parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams);
        if (option instanceof Some) {
            Some some = (Some)option;
            Correlations.Params params = (Correlations.Params)some.value();
            this.run(params);
            return;
        }
        throw package$.MODULE$.exit(1);
    }

    public void run(Correlations.Params params) {
        SparkConf conf = new SparkConf().setAppName(new StringBuilder(18).append("Correlations with ").append(params).toString());
        SparkContext sc = new SparkContext(conf);
        RDD examples = MLUtils$.MODULE$.loadLibSVMFile(sc, params.input()).cache();
        Predef$.MODULE$.println((Object)new StringBuilder(22).append("Summary of data file: ").append(params.input()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(12).append(examples.count()).append(" data points").toString());
        RDD labelRDD = examples.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)x$1.label()), ClassTag$.MODULE$.Double());
        int numFeatures = ((LabeledPoint[])examples.take(1))[0].features().size();
        String corrType = "pearson";
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)new StringBuilder(45).append("Correlation (").append(corrType).append(") between label and each feature").toString());
        Predef$.MODULE$.println((Object)"Feature\tCorrelation");
        IntRef feature = IntRef.create((int)0);
        while (feature.elem < numFeatures) {
            RDD featureRDD = examples.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)Correlations$.$anonfun$run$2(feature, x$2)), ClassTag$.MODULE$.Double());
            double corr = Statistics$.MODULE$.corr(labelRDD, featureRDD);
            Predef$.MODULE$.println((Object)new StringBuilder(1).append(feature.elem).append("\t").append(corr).toString());
            ++feature.elem;
        }
        Predef$.MODULE$.println();
        sc.stop();
    }

    public static final /* synthetic */ double $anonfun$run$2(IntRef feature$1, LabeledPoint x$2) {
        return x$2.features().apply(feature$1.elem);
    }

    private Correlations$() {
        MODULE$ = this;
    }
}

