/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize.proximal;

import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.LapackException;
import breeze.linalg.Matrix;
import breeze.linalg.cholesky$;
import breeze.linalg.cholesky$ImplCholesky_DM$;
import breeze.linalg.norm$;
import breeze.linalg.operators.HasOps$;
import breeze.math.Semiring;
import breeze.math.Semiring$;
import breeze.numerics.package$;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.LBFGS;
import breeze.optimize.LBFGS$;
import breeze.optimize.OWLQN;
import breeze.optimize.linear.ConjugateGradient;
import breeze.optimize.linear.ConjugateGradient$;
import breeze.optimize.linear.NNLS;
import breeze.optimize.linear.NNLS$;
import breeze.optimize.linear.PowerMethod;
import breeze.optimize.linear.PowerMethod$;
import breeze.optimize.proximal.Constraint$;
import breeze.optimize.proximal.ProjectBox;
import breeze.optimize.proximal.ProjectPos;
import breeze.optimize.proximal.ProjectProbabilitySimplex;
import breeze.optimize.proximal.Proximal;
import breeze.optimize.proximal.ProximalL1;
import breeze.optimize.proximal.ProximalL1$;
import breeze.optimize.proximal.QpGenerator$;
import breeze.optimize.proximal.QuadraticMinimizer;
import breeze.stats.distributions.Rand;
import breeze.stats.distributions.Rand$;
import breeze.storage.Zero;
import breeze.storage.Zero$;
import dev.ludovic.netlib.blas.BLAS;
import dev.ludovic.netlib.lapack.LAPACK;
import java.io.Serializable;
import org.netlib.util.intW;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple6;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class QuadraticMinimizer$
implements scala.Serializable {
    public static QuadraticMinimizer$ MODULE$;

    static {
        new QuadraticMinimizer$();
    }

    public Proximal $lessinit$greater$default$2() {
        return null;
    }

    public DenseMatrix<Object> $lessinit$greater$default$3() {
        return null;
    }

    public DenseVector<Object> $lessinit$greater$default$4() {
        return null;
    }

    public int $lessinit$greater$default$5() {
        return -1;
    }

    public double $lessinit$greater$default$6() {
        return 1.0E-6;
    }

    public double $lessinit$greater$default$7() {
        return 1.0E-4;
    }

    public double $lessinit$greater$default$8() {
        return 1.0;
    }

    public void gemv(double alpha, DenseMatrix<Object> A, DenseVector<Object> x, double beta, DenseVector<Object> y) {
        String tStrA = A.isTranspose() ? "T" : "N";
        int mA = !A.isTranspose() ? A.rows() : A.cols();
        int nA = !A.isTranspose() ? A.rows() : A.cols();
        BLAS.getInstance().dgemv(tStrA, mA, nA, alpha, A.data$mcD$sp(), mA, x.data$mcD$sp(), 1, beta, y.data$mcD$sp(), 1);
    }

    public void dgetrs(DenseMatrix<Object> A, int[] pivot, DenseVector<Object> x) {
        int right$macro$2;
        int n = x.length();
        int left$macro$1 = A.rows();
        if (left$macro$1 != (right$macro$2 = n)) {
            throw new IllegalArgumentException(new StringBuilder(38).append("requirement failed: ").append("A.rows == n (").append(left$macro$1).append(" ").append("!=").append(" ").append(right$macro$2).append(")").toString());
        }
        int nrhs = 1;
        intW info = new intW(0);
        LAPACK.getInstance().dgetrs("No transpose", n, nrhs, A.data$mcD$sp(), 0, n, pivot, 0, x.data$mcD$sp(), 0, n, info);
        if (info.val > 0) {
            throw new LapackException("DGETRS: LU solve unsuccessful");
        }
    }

    public void dpotrs(DenseMatrix<Object> A, DenseVector<Object> x) {
        int right$macro$2;
        int n = x.length();
        int nrhs = 1;
        int left$macro$1 = A.rows();
        if (left$macro$1 != (right$macro$2 = n)) {
            throw new IllegalArgumentException(new StringBuilder(38).append("requirement failed: ").append("A.rows == n (").append(left$macro$1).append(" ").append("!=").append(" ").append(right$macro$2).append(")").toString());
        }
        intW info = new intW(0);
        LAPACK.getInstance().dpotrs("L", n, nrhs, A.data$mcD$sp(), 0, n, x.data$mcD$sp(), 0, n, info);
        if (info.val > 0) {
            throw new LapackException("DPOTRS : Leading minor of order i of A is not positive definite.");
        }
    }

    public double normColumn(DenseMatrix<Object> H) {
        DoubleRef absColSum = DoubleRef.create((double)0.0);
        DoubleRef maxColSum = DoubleRef.create((double)0.0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), H.cols()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)c -> {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), H.rows()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)r -> absColSum$1.elem += scala.math.package$.MODULE$.abs(H.apply$mcD$sp(r, c)));
            if (absColSum$1.elem > maxColSum$1.elem) {
                maxColSum$1.elem = absColSum$1.elem;
            }
            absColSum$1.elem = 0.0;
        });
        return maxColSum.elem;
    }

    public double approximateMaxEigen(DenseMatrix<Object> H) {
        PowerMethod pm = new PowerMethod(PowerMethod$.MODULE$.$lessinit$greater$default$1(), PowerMethod$.MODULE$.$lessinit$greater$default$2());
        DenseVector init = (DenseVector)DenseVector$.MODULE$.rand(H.rows(), (Rand)Rand$.MODULE$.gaussian(0.0, 1.0), ClassTag$.MODULE$.Double());
        return pm.eigen(H, init);
    }

    public double approximateMinEigen(DenseMatrix<Object> H) {
        DenseMatrix<Object> R = ((ImmutableNumericOps)cholesky$.MODULE$.apply(H, cholesky$ImplCholesky_DM$.MODULE$)).t(HasOps$.MODULE$.canTranspose_DM());
        PowerMethod pmInv = PowerMethod$.MODULE$.inverse(PowerMethod$.MODULE$.inverse$default$1(), PowerMethod$.MODULE$.inverse$default$2());
        DenseVector init = (DenseVector)DenseVector$.MODULE$.rand(H.rows(), (Rand)Rand$.MODULE$.gaussian(0.0, 1.0), ClassTag$.MODULE$.Double());
        return 1.0 / pmInv.eigen(R, init);
    }

    public QuadraticMinimizer apply(int rank2, Enumeration.Value constraint, double lambda) {
        QuadraticMinimizer quadraticMinimizer;
        Enumeration.Value value2 = constraint;
        Enumeration.Value value3 = Constraint$.MODULE$.SMOOTH();
        Enumeration.Value value4 = value2;
        if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
            quadraticMinimizer = new QuadraticMinimizer(rank2, this.$lessinit$greater$default$2(), this.$lessinit$greater$default$3(), this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7(), this.$lessinit$greater$default$8());
        } else {
            Enumeration.Value value5 = Constraint$.MODULE$.POSITIVE();
            Enumeration.Value value6 = value2;
            if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
                quadraticMinimizer = new QuadraticMinimizer(rank2, new ProjectPos(), this.$lessinit$greater$default$3(), this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7(), this.$lessinit$greater$default$8());
            } else {
                Enumeration.Value value7 = Constraint$.MODULE$.BOX();
                Enumeration.Value value8 = value2;
                if (!(value7 != null ? !value7.equals(value8) : value8 != null)) {
                    DenseVector<Object> lb = DenseVector$.MODULE$.zeros$mDc$sp(rank2, (ClassTag<Object>)ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero());
                    DenseVector<Object> ub = DenseVector$.MODULE$.ones$mDc$sp(rank2, (ClassTag<Object>)ClassTag$.MODULE$.Double(), Semiring$.MODULE$.semiringD());
                    quadraticMinimizer = new QuadraticMinimizer(rank2, new ProjectBox(lb, ub), this.$lessinit$greater$default$3(), this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7(), this.$lessinit$greater$default$8());
                } else {
                    Enumeration.Value value9 = Constraint$.MODULE$.PROBABILITYSIMPLEX();
                    Enumeration.Value value10 = value2;
                    if (!(value9 != null ? !value9.equals(value10) : value10 != null)) {
                        quadraticMinimizer = new QuadraticMinimizer(rank2, new ProjectProbabilitySimplex(lambda), this.$lessinit$greater$default$3(), this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7(), this.$lessinit$greater$default$8());
                    } else {
                        Enumeration.Value value11 = Constraint$.MODULE$.EQUALITY();
                        Enumeration.Value value12 = value2;
                        if (!(value11 != null ? !value11.equals(value12) : value12 != null)) {
                            Matrix Aeq = DenseMatrix$.MODULE$.ones$mDc$sp(1, rank2, ClassTag$.MODULE$.Double(), (Zero)Zero$.MODULE$.DoubleZero(), (Semiring)Semiring$.MODULE$.semiringD());
                            DenseVector<Object> beq = DenseVector$.MODULE$.ones$mDc$sp(1, (ClassTag<Object>)ClassTag$.MODULE$.Double(), Semiring$.MODULE$.semiringD());
                            quadraticMinimizer = new QuadraticMinimizer(rank2, new ProjectPos(), (DenseMatrix<Object>)Aeq, beq, this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7(), this.$lessinit$greater$default$8());
                        } else {
                            Enumeration.Value value13 = Constraint$.MODULE$.SPARSE();
                            Enumeration.Value value14 = value2;
                            if (!(value13 != null ? !value13.equals(value14) : value14 != null)) {
                                quadraticMinimizer = new QuadraticMinimizer(rank2, new ProximalL1(ProximalL1$.MODULE$.apply$default$1()).setLambda(lambda), this.$lessinit$greater$default$3(), this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7(), this.$lessinit$greater$default$8());
                            } else {
                                throw new MatchError((Object)value2);
                            }
                        }
                    }
                }
            }
        }
        return quadraticMinimizer;
    }

    public double apply$default$3() {
        return 1.0;
    }

    public double computeObjective(DenseMatrix<Object> h, DenseVector<Object> q, DenseVector<Object> x) {
        double res = BoxesRunTime.unboxToDouble((Object)((ImmutableNumericOps)((ImmutableNumericOps)x.t(HasOps$.MODULE$.transposeTensor(Predef$.MODULE$.$conforms()))).$times(h, HasOps$.MODULE$.impl_OpMulMatrix_DVTt_DMT_eq_DMT(HasOps$.MODULE$.impl_OpMulMatrix_DMD_DMD_eq_DMD()))).$times(x, HasOps$.MODULE$.transTimesNormalFromDot(HasOps$.MODULE$.canDotD()))) * 0.5 + BoxesRunTime.unboxToDouble((Object)q.dot(x, HasOps$.MODULE$.canDotD()));
        return res;
    }

    public DenseVector<Object> optimizeWithLBFGS(DenseVector<Object> init, DenseMatrix<Object> H, DenseVector<Object> q) {
        LBFGS<DenseVector<Object>> lbfgs = new LBFGS<DenseVector<Object>>(-1, 7, LBFGS$.MODULE$.$lessinit$greater$default$3(), DenseVector$.MODULE$.space_Double());
        FirstOrderMinimizer.State<DenseVector<Object>, Object, Object> state = lbfgs.minimizeAndReturnState(new QuadraticMinimizer.Cost(H, q), init);
        return state.x();
    }

    public void main(String[] args) {
        if (args.length < 4) {
            Predef$.MODULE$.println((Object)"Usage: QpSolver n m lambda beta");
            Predef$.MODULE$.println((Object)"Test QpSolver with a simple quadratic function of dimension n and m equalities lambda beta for elasticNet");
            throw scala.sys.package$.MODULE$.exit(1);
        }
        int problemSize = new StringOps(Predef$.MODULE$.augmentString(args[0])).toInt();
        int nequalities = new StringOps(Predef$.MODULE$.augmentString(args[1])).toInt();
        double lambda = new StringOps(Predef$.MODULE$.augmentString(args[2])).toDouble();
        double beta = new StringOps(Predef$.MODULE$.augmentString(args[3])).toDouble();
        Predef$.MODULE$.println((Object)new StringBuilder(48).append("Generating randomized QPs with rank ").append(problemSize).append(" equalities ").append(nequalities).toString());
        Tuple6<DenseMatrix<Object>, DenseVector<Object>, DenseVector<Object>, DenseVector<Object>, DenseVector<Object>, DenseMatrix<Object>> tuple6 = QpGenerator$.MODULE$.apply(problemSize, nequalities);
        if (tuple6 == null) {
            throw new MatchError(tuple6);
        }
        DenseMatrix aeq = (DenseMatrix)tuple6._1();
        DenseVector b = (DenseVector)tuple6._2();
        DenseVector bl = (DenseVector)tuple6._3();
        DenseVector bu = (DenseVector)tuple6._4();
        DenseVector q = (DenseVector)tuple6._5();
        DenseMatrix h = (DenseMatrix)tuple6._6();
        Tuple6 tuple62 = new Tuple6((Object)aeq, (Object)b, (Object)bl, (Object)bu, (Object)q, (Object)h);
        Tuple6 tuple63 = tuple62;
        DenseMatrix aeq2 = (DenseMatrix)tuple63._1();
        DenseVector b2 = (DenseVector)tuple63._2();
        DenseVector bl2 = (DenseVector)tuple63._3();
        DenseVector bu2 = (DenseVector)tuple63._4();
        DenseVector q2 = (DenseVector)tuple63._5();
        DenseMatrix h2 = (DenseMatrix)tuple63._6();
        Predef$.MODULE$.println((Object)new StringBuilder(86).append("Test QuadraticMinimizer, CG , BFGS and OWLQN with ").append(problemSize).append(" variables and ").append(nequalities).append(" equality constraints").toString());
        long luStart = System.nanoTime();
        DenseVector<Object> luResult = ((ImmutableNumericOps)h2.$bslash(q2, HasOps$.MODULE$.impl_OpSolveMatrixBy_DMD_DVD_eq_DVD())).$times$colon$times(BoxesRunTime.boxToDouble((double)-1.0), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulScalar());
        long luTime = System.nanoTime() - luStart;
        ConjugateGradient<DenseVector<Object>, DenseMatrix<Object>> cg = new ConjugateGradient<DenseVector<Object>, DenseMatrix<Object>>(ConjugateGradient$.MODULE$.$lessinit$greater$default$1(), ConjugateGradient$.MODULE$.$lessinit$greater$default$2(), ConjugateGradient$.MODULE$.$lessinit$greater$default$3(), ConjugateGradient$.MODULE$.$lessinit$greater$default$4(), DenseVector$.MODULE$.space_Double(), HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD());
        long startCg = System.nanoTime();
        DenseVector<Object> cgResult = cg.minimize(q2.$times$colon$times(BoxesRunTime.boxToDouble((double)-1.0), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulScalar()), h2);
        long cgTime = System.nanoTime() - startCg;
        QuadraticMinimizer qpSolver = new QuadraticMinimizer(problemSize, this.$lessinit$greater$default$2(), this.$lessinit$greater$default$3(), this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7(), this.$lessinit$greater$default$8());
        long qpStart = System.nanoTime();
        DenseVector<Object> result = qpSolver.minimize(h2, q2);
        long qpTime = System.nanoTime() - qpStart;
        long startBFGS = System.nanoTime();
        DenseVector<Object> bfgsResult = this.optimizeWithLBFGS((DenseVector)DenseVector$.MODULE$.rand(problemSize, (Rand)DenseVector$.MODULE$.rand$default$2(), ClassTag$.MODULE$.Double()), h2, q2);
        long bfgsTime = System.nanoTime() - startBFGS;
        Predef$.MODULE$.println((Object)new StringBuilder(27).append("||qp - lu|| norm ").append(norm$.MODULE$.apply(result.$minus(luResult, HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double()), BoxesRunTime.boxToInteger((int)2), norm$.MODULE$.fromCanNormInt(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double())))).append(" max-norm ").append(norm$.MODULE$.apply(result.$minus(luResult, HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double()), BoxesRunTime.boxToDouble((double)package$.MODULE$.inf()), norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double()))).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(27).append("||cg - lu|| norm ").append(norm$.MODULE$.apply(cgResult.$minus(luResult, HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double()), BoxesRunTime.boxToInteger((int)2), norm$.MODULE$.fromCanNormInt(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double())))).append(" max-norm ").append(norm$.MODULE$.apply(cgResult.$minus(luResult, HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double()), BoxesRunTime.boxToDouble((double)package$.MODULE$.inf()), norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double()))).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(29).append("||bfgs - lu|| norm ").append(norm$.MODULE$.apply(bfgsResult.$minus(luResult, HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double()), BoxesRunTime.boxToInteger((int)2), norm$.MODULE$.fromCanNormInt(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double())))).append(" max-norm ").append(norm$.MODULE$.apply(bfgsResult.$minus(luResult, HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double()), BoxesRunTime.boxToDouble((double)package$.MODULE$.inf()), norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double()))).toString());
        double luObj = this.computeObjective(h2, q2, luResult);
        double bfgsObj = this.computeObjective(h2, q2, bfgsResult);
        double qpObj = this.computeObjective(h2, q2, result);
        Predef$.MODULE$.println((Object)new StringBuilder(23).append("Objective lu ").append(luObj).append(" bfgs ").append(bfgsObj).append(" qp ").append(qpObj).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(34).append("dim ").append(problemSize).append(" lu ").append((double)luTime / 1000000.0).append(" ms qp ").append((double)qpTime / 1000000.0).append(" ms cg ").append((double)cgTime / 1000000.0).append(" ms bfgs ").append((double)bfgsTime / 1000000.0).append(" ms").toString());
        double lambdaL1 = lambda * beta;
        double lambdaL2 = lambda * (1.0 - beta);
        DenseMatrix<Object> regularizedGram = h2.$plus(DenseMatrix$.MODULE$.eye$mDc$sp(h2.rows(), (ClassTag<Object>)ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero(), Semiring$.MODULE$.semiringD()).$times$colon$times(BoxesRunTime.boxToDouble((double)lambdaL2), HasOps$.MODULE$.op_DM_S_Double_OpMulScalar()), HasOps$.MODULE$.op_DM_DM_Double_OpAdd());
        QuadraticMinimizer sparseQp = this.apply(h2.rows(), Constraint$.MODULE$.SPARSE(), lambdaL1);
        long sparseQpStart = System.nanoTime();
        QuadraticMinimizer.State sparseQpResult = sparseQp.minimizeAndReturnState(regularizedGram, q2);
        long sparseQpTime = System.nanoTime() - sparseQpStart;
        OWLQN<Object, DenseVector<Object>> owlqn = new OWLQN<Object, DenseVector<Object>>(-1, 7, lambdaL1, 1.0E-6, DenseVector$.MODULE$.space_Double());
        DenseVector init = (DenseVector)DenseVector$.MODULE$.rand(problemSize, (Rand)DenseVector$.MODULE$.rand$default$2(), ClassTag$.MODULE$.Double());
        long startOWLQN = System.nanoTime();
        FirstOrderMinimizer.State<Object, Object, Object> owlqnResult = owlqn.minimizeAndReturnState(new QuadraticMinimizer.Cost(regularizedGram, q2), (DenseVector<Object>)((Object)init));
        long owlqnTime = System.nanoTime() - startOWLQN;
        Predef$.MODULE$.println((Object)new StringBuilder(36).append("||owlqn - sparseqp|| norm ").append(norm$.MODULE$.apply(((ImmutableNumericOps)owlqnResult.x()).$minus(sparseQpResult.x(), HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double()), BoxesRunTime.boxToInteger((int)2), norm$.MODULE$.fromCanNormInt(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double())))).append(" inf-norm ").append(norm$.MODULE$.apply(((ImmutableNumericOps)owlqnResult.x()).$minus(sparseQpResult.x(), HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double()), BoxesRunTime.boxToDouble((double)package$.MODULE$.inf()), norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double()))).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(36).append("sparseQp ").append((double)sparseQpTime / 1000000.0).append(" ms iters ").append(sparseQpResult.iter()).append(" owlqn ").append((double)owlqnTime / 1000000.0).append(" ms iters ").append(owlqnResult.iter()).toString());
        QuadraticMinimizer posQp = this.apply(h2.rows(), Constraint$.MODULE$.POSITIVE(), 0.0);
        long posQpStart = System.nanoTime();
        QuadraticMinimizer.State posQpResult = posQp.minimizeAndReturnState(h2, q2);
        long posQpTime = System.nanoTime() - posQpStart;
        NNLS nnls = new NNLS(NNLS$.MODULE$.$lessinit$greater$default$1());
        long nnlsStart = System.nanoTime();
        NNLS.State nnlsResult = nnls.minimizeAndReturnState(h2, q2);
        long nnlsTime = System.nanoTime() - nnlsStart;
        Predef$.MODULE$.println((Object)new StringBuilder(32).append("posQp ").append((double)posQpTime / 1000000.0).append(" ms iters ").append(posQpResult.iter()).append(" nnls ").append((double)nnlsTime / 1000000.0).append(" ms iters ").append(nnlsResult.iter()).toString());
        QuadraticMinimizer boundsQp = new QuadraticMinimizer(h2.rows(), new ProjectBox(bl2, bu2), this.$lessinit$greater$default$3(), this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7(), this.$lessinit$greater$default$8());
        long boundsQpStart = System.nanoTime();
        QuadraticMinimizer.State boundsQpResult = boundsQp.minimizeAndReturnState(h2, q2);
        long boundsQpTime = System.nanoTime() - boundsQpStart;
        Predef$.MODULE$.println((Object)new StringBuilder(30).append("boundsQp ").append((double)boundsQpTime / 1000000.0).append(" ms iters ").append(boundsQpResult.iter()).append(" converged ").append(boundsQpResult.converged()).toString());
        QuadraticMinimizer qpEquality = new QuadraticMinimizer(h2.rows(), new ProjectPos(), aeq2, b2, this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7(), this.$lessinit$greater$default$8());
        long qpEqualityStart = System.nanoTime();
        QuadraticMinimizer.State qpEqualityResult = qpEquality.minimizeAndReturnState(h2, q2);
        long qpEqualityTime = System.nanoTime() - qpEqualityStart;
        Predef$.MODULE$.println((Object)new StringBuilder(33).append("Qp Equality ").append((double)qpEqualityTime / 1000000.0).append(" ms iters ").append(qpEqualityResult.iter()).append(" converged ").append(qpEqualityResult.converged()).toString());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private QuadraticMinimizer$() {
        MODULE$ = this;
    }
}

