/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.ArrayRemove$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(array, element) - Remove all elements that equal to element from array.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3, null, 3), 3);\n       [1,2,null]\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\t=b\u0001\u0002\u0011\"\u0001:B\u0001\u0002\u0014\u0001\u0003\u0016\u0004%\t!\u0014\u0005\t#\u0002\u0011\t\u0012)A\u0005\u001d\"A!\u000b\u0001BK\u0002\u0013\u0005Q\n\u0003\u0005T\u0001\tE\t\u0015!\u0003O\u0011\u0015!\u0006\u0001\"\u0001V\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u0015\t\u0007\u0001\"\u0011c\u0011\u0015\t\b\u0001\"\u0011s\u0011\u0015I\b\u0001\"\u0003[\u0011!Q\b\u0001#b\u0001\n\u0013Y\bbBA\u0007\u0001\u0011\u0005\u0013q\u0002\u0005\b\u00033\u0001A\u0011IA\u000e\u0011\u001d\t9\u0004\u0001C\u0001\u0003sAq!!\u0017\u0001\t\u0003\nY\u0006C\u0004\u0002^\u0001!\t&a\u0018\t\u0013\u0005%\u0004!!A\u0005\u0002\u0005-\u0004\"CA9\u0001E\u0005I\u0011AA:\u0011%\tI\tAI\u0001\n\u0003\t\u0019\bC\u0005\u0002\f\u0002\t\t\u0011\"\u0011\u0002\u000e\"I\u0011Q\u0014\u0001\u0002\u0002\u0013\u0005\u0011q\u0014\u0005\n\u0003O\u0003\u0011\u0011!C\u0001\u0003SC\u0011\"a,\u0001\u0003\u0003%\t%!-\t\u0013\u0005}\u0006!!A\u0005\u0002\u0005\u0005\u0007\"CAf\u0001\u0005\u0005I\u0011IAg\u000f%\t\t0IA\u0001\u0012\u0003\t\u0019P\u0002\u0005!C\u0005\u0005\t\u0012AA{\u0011\u0019!&\u0004\"\u0001\u0003\u0004!I!Q\u0001\u000e\u0002\u0002\u0013\u0015#q\u0001\u0005\n\u0005\u0013Q\u0012\u0011!CA\u0005\u0017A\u0011B!\u0005\u001b\u0003\u0003%\tIa\u0005\t\u0013\t\u0015\"$!A\u0005\n\t\u001d\"aC!se\u0006L(+Z7pm\u0016T!AI\u0012\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003I\u0015\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003M\u001d\n1a]9m\u0015\tA\u0013&A\u0003ta\u0006\u00148N\u0003\u0002+W\u00051\u0011\r]1dQ\u0016T\u0011\u0001L\u0001\u0004_J<7\u0001A\n\b\u0001=\u001ad'P\"J!\t\u0001\u0014'D\u0001\"\u0013\t\u0011\u0014E\u0001\tCS:\f'/_#yaJ,7o]5p]B\u0011\u0001\u0007N\u0005\u0003k\u0005\u0012a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003oir!\u0001\r\u001d\n\u0005e\n\u0013a\u00029bG.\fw-Z\u0005\u0003wq\u0012aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u0002:CA\u0011a(Q\u0007\u0002\u007f)\u0011\u0001)J\u0001\u0007KJ\u0014xN]:\n\u0005\t{$aD)vKJLXI\u001d:peN\u0014\u0015m]3\u0011\u0005\u0011;U\"A#\u000b\u0003\u0019\u000bQa]2bY\u0006L!\u0001S#\u0003\u000fA\u0013x\u000eZ;diB\u0011AIS\u0005\u0003\u0017\u0016\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fA\u0001\\3giV\ta\n\u0005\u00021\u001f&\u0011\u0001+\t\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!\u00027fMR\u0004\u0013!\u0002:jO\"$\u0018A\u0002:jO\"$\b%\u0001\u0004=S:LGO\u0010\u000b\u0004-^C\u0006C\u0001\u0019\u0001\u0011\u0015aU\u00011\u0001O\u0011\u0015\u0011V\u00011\u0001O\u0003!!\u0017\r^1UsB,W#A.\u0011\u0005q{V\"A/\u000b\u0005y+\u0013!\u0002;za\u0016\u001c\u0018B\u00011^\u0005!!\u0015\r^1UsB,\u0017AC5oaV$H+\u001f9fgV\t1\rE\u0002eW:t!!\u001a6\u000f\u0005\u0019LW\"A4\u000b\u0005!l\u0013A\u0002\u001fs_>$h(C\u0001G\u0013\tIT)\u0003\u0002m[\n\u00191+Z9\u000b\u0005e*\u0005C\u0001/p\u0013\t\u0001XL\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\t1\u000f\u0005\u0002uo6\tQO\u0003\u0002wG\u0005A\u0011M\\1msNL7/\u0003\u0002yk\nyA+\u001f9f\u0007\",7m\u001b*fgVdG/A\u0006fY\u0016lWM\u001c;UsB,\u0017\u0001C8sI\u0016\u0014\u0018N\\4\u0016\u0003q\u00042\u0001Z?\u0000\u0013\tqXN\u0001\u0005Pe\u0012,'/\u001b8h!\r!\u0015\u0011A\u0005\u0004\u0003\u0007)%aA!os\"\u001a!\"a\u0002\u0011\u0007\u0011\u000bI!C\u0002\u0002\f\u0015\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u000b}\f\t\"!\u0006\t\r\u0005M1\u00021\u0001\u0000\u0003\r\t'O\u001d\u0005\u0007\u0003/Y\u0001\u0019A@\u0002\u000bY\fG.^3\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA\u000f\u0003S\t\u0019\u0004\u0005\u0003\u0002 \u0005\u0015RBAA\u0011\u0015\r\t\u0019#I\u0001\bG>$WmZ3o\u0013\u0011\t9#!\t\u0003\u0011\u0015C\bO]\"pI\u0016Dq!a\u000b\r\u0001\u0004\ti#A\u0002dib\u0004B!a\b\u00020%!\u0011\u0011GA\u0011\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!!\u000e\r\u0001\u0004\ti\"\u0001\u0002fm\u0006\u0001r-\u001a8D_\u0012,gi\u001c:SKN,H\u000e\u001e\u000b\r\u0003w\tY%!\u0014\u0002P\u0005M\u0013Q\u000b\t\u0005\u0003{\t)E\u0004\u0003\u0002@\u0005\u0005\u0003C\u00014F\u0013\r\t\u0019%R\u0001\u0007!J,G-\u001a4\n\t\u0005\u001d\u0013\u0011\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\rS\tC\u0004\u0002,5\u0001\r!!\f\t\u000f\u0005UR\u00021\u0001\u0002\u001e!9\u0011\u0011K\u0007A\u0002\u0005m\u0012AC5oaV$\u0018I\u001d:bs\"9\u0011qC\u0007A\u0002\u0005m\u0002bBA,\u001b\u0001\u0007\u00111H\u0001\r]\u0016<\u0018I\u001d:bsNK'0Z\u0001\u000baJ,G\u000f^=OC6,WCAA\u001e\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0003W\u0003C\n)\u0007\u0003\u0004\u0002d=\u0001\rAT\u0001\b]\u0016<H*\u001a4u\u0011\u0019\t9g\u0004a\u0001\u001d\u0006Aa.Z<SS\u001eDG/\u0001\u0003d_BLH#\u0002,\u0002n\u0005=\u0004b\u0002'\u0011!\u0003\u0005\rA\u0014\u0005\b%B\u0001\n\u00111\u0001O\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u001e+\u00079\u000b9h\u000b\u0002\u0002zA!\u00111PAC\u001b\t\tiH\u0003\u0003\u0002\u0000\u0005\u0005\u0015!C;oG\",7m[3e\u0015\r\t\u0019)R\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAD\u0003{\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAH!\u0011\t\t*a'\u000e\u0005\u0005M%\u0002BAK\u0003/\u000bA\u0001\\1oO*\u0011\u0011\u0011T\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002H\u0005M\u0015\u0001\u00049s_\u0012,8\r^!sSRLXCAAQ!\r!\u00151U\u0005\u0004\u0003K+%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA@\u0002,\"I\u0011QV\u000b\u0002\u0002\u0003\u0007\u0011\u0011U\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005M\u0006#BA[\u0003w{XBAA\\\u0015\r\tI,R\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA_\u0003o\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u00111YAe!\r!\u0015QY\u0005\u0004\u0003\u000f,%a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003[;\u0012\u0011!a\u0001\u007f\u00061Q-];bYN$B!a1\u0002P\"A\u0011Q\u0016\r\u0002\u0002\u0003\u0007q\u0010K\n\u0001\u0003'\fI.a7\u0002`\u0006\u0005\u0018Q]At\u0003W\fi\u000fE\u00021\u0003+L1!a6\"\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!8\u0002\u001d~3UKT\"`Q\u0005\u0014(/Y=-A\u0015dW-\\3oi&\u0002S\u0006\t*f[>4X\rI1mY\u0002*G.Z7f]R\u001c\b\u0005\u001e5bi\u0002*\u0017/^1mAQ|\u0007%\u001a7f[\u0016tG\u000f\t4s_6\u0004\u0013M\u001d:bs:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003G\faK\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010K\u0019-AIb\u0003e\r\u0017!]VdG\u000e\f\u00114S1\u00023'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7Fb#\u0007\f8vY2l&\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005%\u0018aC1se\u0006LxLZ;oGN\fQa]5oG\u0016\f#!a<\u0002\u000bIrCG\f\u0019\u0002\u0017\u0005\u0013(/Y=SK6|g/\u001a\t\u0003ai\u0019BAGA|\u0013B9\u0011\u0011`A\u0000\u001d:3VBAA~\u0015\r\ti0R\u0001\beVtG/[7f\u0013\u0011\u0011\t!a?\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0002t\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u0010\u0006)\u0011\r\u001d9msR)aK!\u0004\u0003\u0010!)A*\ba\u0001\u001d\")!+\ba\u0001\u001d\u00069QO\\1qa2LH\u0003\u0002B\u000b\u0005C\u0001R\u0001\u0012B\f\u00057I1A!\u0007F\u0005\u0019y\u0005\u000f^5p]B)AI!\bO\u001d&\u0019!qD#\u0003\rQ+\b\u000f\\33\u0011!\u0011\u0019CHA\u0001\u0002\u00041\u0016a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011I\u0003\u0005\u0003\u0002\u0012\n-\u0012\u0002\u0002B\u0017\u0003'\u0013aa\u00142kK\u000e$\b")
public class ArrayRemove
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
QueryErrorsBase,
scala.Serializable {
    private transient Ordering<Object> ordering;
    private final Expression left;
    private final Expression right;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArrayRemove arrayRemove) {
        return ArrayRemove$.MODULE$.unapply(arrayRemove);
    }

    public static Function1<Tuple2<Expression, Expression>, ArrayRemove> tupled() {
        return ArrayRemove$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArrayRemove>> curried() {
        return ArrayRemove$.MODULE$.curried();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLSchema(String schema) {
        return QueryErrorsBase.toSQLSchema$(this, schema);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public DataType dataType() {
        return this.left().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType e1 = arrayType.elementType();
                boolean hasNull = arrayType.containsNull();
                Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)e1, (Object)e2);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    DataType dt = (DataType)some.value();
                    return (Seq)new .colon.colon((Object)new ArrayType(dt, hasNull), (List)new .colon.colon((Object)dt, (List)Nil$.MODULE$));
                }
                return (Seq)Nil$.MODULE$;
            }
        }
        return (Seq)Nil$.MODULE$;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            ArrayType arrayType;
            DataType e1;
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof ArrayType && DataTypeUtils$.MODULE$.sameType(e1 = (arrayType = (ArrayType)dataType).elementType(), e2)) {
                return TypeUtils$.MODULE$.checkForOrderingExpr(e2, this.prettyName());
            }
        }
        return new TypeCheckResult.DataTypeMismatch("ARRAY_FUNCTION_DIFF_TYPES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)this.toSQLType((AbstractDataType)ArrayType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leftType"), (Object)this.toSQLType((AbstractDataType)this.left().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rightType"), (Object)this.toSQLType((AbstractDataType)this.right().dataType()))}))));
    }

    private DataType elementType() {
        return ((ArrayType)this.left().dataType()).elementType();
    }

    private Ordering<Object> ordering$lzycompute() {
        ArrayRemove arrayRemove = this;
        synchronized (arrayRemove) {
            if (!this.bitmap$trans$0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.right().dataType());
                this.bitmap$trans$0 = true;
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        if (!this.bitmap$trans$0) {
            return this.ordering$lzycompute();
        }
        return this.ordering;
    }

    @Override
    public Object nullSafeEval(Object arr, Object value) {
        Object[] newArray = new Object[((ArrayData)arr).numElements()];
        IntRef pos = IntRef.create((int)0);
        ((ArrayData)arr).foreach(this.right().dataType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(i, v) -> {
            ArrayRemove.$anonfun$nullSafeEval$8(this, value, newArray, pos, BoxesRunTime.unboxToInt((Object)i), v);
            return BoxedUnit.UNIT;
        });
        return new GenericArrayData((Object[])Predef$.MODULE$.genericArrayOps((Object)newArray).slice(0, pos.elem));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(arr, value) -> {
            String numsToRemove = ctx.freshName("numsToRemove");
            String newArraySize = ctx.freshName("newArraySize");
            String i = ctx.freshName("i");
            String getValue = CodeGenerator$.MODULE$.getValue((String)arr, this.elementType(), i);
            String isEqual = ctx.genEqual(this.elementType(), (String)value, getValue);
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(211).append("\n         |int ").append(numsToRemove).append(" = 0;\n         |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append((String)arr).append(".numElements(); ").append(i).append(" ++) {\n         |  if (!").append((String)arr).append(".isNullAt(").append(i).append(") && ").append(isEqual).append(") {\n         |    ").append(numsToRemove).append(" = ").append(numsToRemove).append(" + 1;\n         |  }\n         |}\n         |int ").append(newArraySize).append(" = ").append((String)arr).append(".numElements() - ").append(numsToRemove).append(";\n         |").append(this.genCodeForResult(ctx, ev, (String)arr, (String)value, newArraySize)).append("\n       ").toString())).stripMargin();
        });
    }

    public String genCodeForResult(CodegenContext ctx, ExprCode ev, String inputArray, String value, String newArraySize) {
        String values = ctx.freshName("values");
        String i = ctx.freshName("i");
        String pos = ctx.freshName("pos");
        String getValue = CodeGenerator$.MODULE$.getValue(inputArray, this.elementType(), i);
        String isEqual = ctx.genEqual(this.elementType(), value, getValue);
        String allocation = CodeGenerator$.MODULE$.createArrayData(values, this.elementType(), newArraySize, new StringBuilder(9).append(" ").append(this.prettyName()).append(" failed.").toString());
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(values, this.elementType(), inputArray, pos, i, false);
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(297).append("\n       |").append(allocation).append("\n       |int ").append(pos).append(" = 0;\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(inputArray).append(".numElements(); ").append(i).append(" ++) {\n       |  if (").append(inputArray).append(".isNullAt(").append(i).append(")) {\n       |    ").append(values).append(".setNullAt(").append(pos).append(");\n       |    ").append(pos).append(" = ").append(pos).append(" + 1;\n       |  }\n       |  else {\n       |    if (!(").append(isEqual).append(")) {\n       |      ").append(assignment).append("\n       |      ").append(pos).append(" = ").append(pos).append(" + 1;\n       |    }\n       |  }\n       |}\n       |").append(ev.value()).append(" = ").append(values).append(";\n     ").toString())).stripMargin();
    }

    @Override
    public String prettyName() {
        return "array_remove";
    }

    @Override
    public ArrayRemove withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public ArrayRemove copy(Expression left, Expression right) {
        return new ArrayRemove(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArrayRemove";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayRemove;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayRemove)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayRemove arrayRemove = (ArrayRemove)x$1;
        Expression expression = this.left();
        Expression expression2 = arrayRemove.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arrayRemove.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arrayRemove.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$8(ArrayRemove $this, Object value$3, Object[] newArray$1, IntRef pos$1, int i, Object v) {
        if (v == null || !$this.ordering().equiv(v, value$3)) {
            newArray$1[pos$1.elem] = v;
            ++pos$1.elem;
            return;
        }
    }

    public ArrayRemove(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
    }
}

