/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.hadoop.security.AccessControlException;
import org.apache.spark.SparkUpgradeException;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.InputFileBlockHolder$;
import org.apache.spark.sql.catalyst.FileSourceOptions;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.SchemaColumnConvertNotSupportedException;
import org.apache.spark.sql.execution.datasources.v2.PartitionedFileReader;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001a4A!\u0004\b\u0001;!A1\t\u0001B\u0001B\u0003%A\t\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003V\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u001d\u0001\u0007\u00011A\u0005\n\u0005DqA\u0019\u0001A\u0002\u0013%1\r\u0003\u0004j\u0001\u0001\u0006K\u0001\u0015\u0005\u0006U\u0002!Ia\u001b\u0005\u0006_\u0002!Ia\u001b\u0005\u0006a\u0002!\t%\u001d\u0005\u0006e\u0002!\te\u001d\u0005\u0006i\u0002!\t%\u001e\u0005\u0006m\u0002!Ia\u001e\u0002\u0014\r&dW\rU1si&$\u0018n\u001c8SK\u0006$WM\u001d\u0006\u0003\u001fA\t!A\u001e\u001a\u000b\u0005E\u0011\u0012a\u00033bi\u0006\u001cx.\u001e:dKNT!a\u0005\u000b\u0002\u0013\u0015DXmY;uS>t'BA\u000b\u0017\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003/a\tQa\u001d9be.T!!\u0007\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0012aA8sO\u000e\u0001QC\u0001\u00102'\u0011\u0001qdJ\u001f\u0011\u0005\u0001*S\"A\u0011\u000b\u0005\t\u001a\u0013\u0001\u00027b]\u001eT\u0011\u0001J\u0001\u0005U\u00064\u0018-\u0003\u0002'C\t1qJ\u00196fGR\u00042\u0001K\u00170\u001b\u0005I#B\u0001\u0016,\u0003\u0011\u0011X-\u00193\u000b\u00051\"\u0012!C2p]:,7\r^8s\u0013\tq\u0013FA\bQCJ$\u0018\u000e^5p]J+\u0017\rZ3s!\t\u0001\u0014\u0007\u0004\u0001\u0005\u000bI\u0002!\u0019A\u001a\u0003\u0003Q\u000b\"\u0001\u000e\u001e\u0011\u0005UBT\"\u0001\u001c\u000b\u0003]\nQa]2bY\u0006L!!\u000f\u001c\u0003\u000f9{G\u000f[5oOB\u0011QgO\u0005\u0003yY\u00121!\u00118z!\tq\u0014)D\u0001@\u0015\t\u0001e#\u0001\u0005j]R,'O\\1m\u0013\t\u0011uHA\u0004M_\u001e<\u0017N\\4\u0002\u000fI,\u0017\rZ3sgB\u0019Q)\u0014)\u000f\u0005\u0019[eBA$K\u001b\u0005A%BA%\u001d\u0003\u0019a$o\\8u}%\tq'\u0003\u0002Mm\u00059\u0001/Y2lC\u001e,\u0017B\u0001(P\u0005!IE/\u001a:bi>\u0014(B\u0001'7!\r\t&kL\u0007\u0002\u001d%\u00111K\u0004\u0002\u0016!\u0006\u0014H/\u001b;j_:,GMR5mKJ+\u0017\rZ3s\u0003\u001dy\u0007\u000f^5p]N\u0004\"AV-\u000e\u0003]S!\u0001\u0017\u000b\u0002\u0011\r\fG/\u00197zgRL!AW,\u0003#\u0019KG.Z*pkJ\u001cWm\u00149uS>t7/\u0001\u0004=S:LGO\u0010\u000b\u0004;z{\u0006cA)\u0001_!)1i\u0001a\u0001\t\")Ak\u0001a\u0001+\u0006i1-\u001e:sK:$(+Z1eKJ,\u0012\u0001U\u0001\u0012GV\u0014(/\u001a8u%\u0016\fG-\u001a:`I\u0015\fHC\u00013h!\t)T-\u0003\u0002gm\t!QK\\5u\u0011\u001dAW!!AA\u0002A\u000b1\u0001\u001f\u00132\u00039\u0019WO\u001d:f]R\u0014V-\u00193fe\u0002\n!#[4o_J,W*[:tS:<g)\u001b7fgV\tA\u000e\u0005\u00026[&\u0011aN\u000e\u0002\b\u0005>|G.Z1o\u0003IIwM\\8sK\u000e{'O];qi\u001aKG.Z:\u0002\t9,\u0007\u0010\u001e\u000b\u0002Y\u0006\u0019q-\u001a;\u0015\u0003=\nQa\u00197pg\u0016$\u0012\u0001Z\u0001\u000eO\u0016$h*\u001a=u%\u0016\fG-\u001a:\u0015\u0003A\u0003")
public class FilePartitionReader<T>
implements PartitionReader<T>,
Logging {
    private final Iterator<PartitionedFileReader<T>> readers;
    private final FileSourceOptions options;
    private PartitionedFileReader<T> currentReader;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public CustomTaskMetric[] currentMetricsValues() {
        return super.currentMetricsValues();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private PartitionedFileReader<T> currentReader() {
        return this.currentReader;
    }

    private void currentReader_$eq(PartitionedFileReader<T> x$1) {
        this.currentReader = x$1;
    }

    private boolean ignoreMissingFiles() {
        return this.options.ignoreMissingFiles();
    }

    private boolean ignoreCorruptFiles() {
        return this.options.ignoreCorruptFiles();
    }

    public boolean next() {
        boolean bl;
        if (this.currentReader() == null) {
            if (this.readers.hasNext()) {
                try {
                    this.currentReader_$eq(this.getNextReader());
                }
                catch (Throwable throwable) {
                    boolean bl2 = false;
                    FileNotFoundException fileNotFoundException = null;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof FileNotFoundException) {
                        bl2 = true;
                        fileNotFoundException = (FileNotFoundException)throwable2;
                        if (this.ignoreMissingFiles()) {
                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Skipped missing file.", fileNotFoundException);
                            this.currentReader_$eq(null);
                        }
                    }
                    if (bl2 && !this.ignoreMissingFiles()) {
                        throw QueryExecutionErrors$.MODULE$.fileNotFoundError(fileNotFoundException);
                    }
                    if (throwable2 instanceof AccessControlException ? true : throwable2 instanceof BlockMissingException) {
                        throw throwable2;
                    }
                    if ((throwable2 instanceof RuntimeException ? true : throwable2 instanceof IOException) && this.ignoreCorruptFiles()) {
                        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Skipped the rest of the content in the corrupted file.", throwable2);
                        this.currentReader_$eq(null);
                    }
                    throw throwable;
                }
            } else {
                return false;
            }
        }
        try {
            bl = this.currentReader() != null && this.currentReader().next();
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (throwable3 instanceof SchemaColumnConvertNotSupportedException) {
                SchemaColumnConvertNotSupportedException schemaColumnConvertNotSupportedException = (SchemaColumnConvertNotSupportedException)throwable3;
                throw QueryExecutionErrors$.MODULE$.unsupportedSchemaColumnConvertError(this.currentReader().file().urlEncodedPath(), schemaColumnConvertNotSupportedException.getColumn(), schemaColumnConvertNotSupportedException.getLogicalType(), schemaColumnConvertNotSupportedException.getPhysicalType(), (Exception)schemaColumnConvertNotSupportedException);
            }
            if (throwable3 instanceof AccessControlException ? true : throwable3 instanceof BlockMissingException) {
                throw throwable3;
            }
            if ((throwable3 instanceof RuntimeException ? true : throwable3 instanceof IOException) && this.ignoreCorruptFiles()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Skipped the rest of the content in the corrupted file: ").append(this.currentReader()).toString(), throwable3);
                bl = false;
            }
            if (throwable3 instanceof SparkUpgradeException) {
                SparkUpgradeException sparkUpgradeException = (SparkUpgradeException)throwable3;
                throw sparkUpgradeException;
            }
            Option option = NonFatal$.MODULE$.unapply(throwable3);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                Throwable throwable4 = e.getCause();
                if (throwable4 instanceof SparkUpgradeException) {
                    SparkUpgradeException sparkUpgradeException = (SparkUpgradeException)throwable4;
                    throw sparkUpgradeException;
                }
                throw QueryExecutionErrors$.MODULE$.cannotReadFilesError(e, this.currentReader().file().urlEncodedPath());
            }
            throw throwable;
        }
        boolean hasNext = bl;
        if (hasNext) {
            return true;
        }
        this.close();
        this.currentReader_$eq(null);
        return this.next();
    }

    public T get() {
        return this.currentReader().get();
    }

    public void close() {
        if (this.currentReader() != null) {
            this.currentReader().close();
        }
        InputFileBlockHolder$.MODULE$.unset();
    }

    private PartitionedFileReader<T> getNextReader() {
        PartitionedFileReader reader = (PartitionedFileReader)this.readers.next();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Reading file ").append(reader).toString());
        PartitionedFile file = reader.file();
        InputFileBlockHolder$.MODULE$.set(file.urlEncodedPath(), file.start(), file.length());
        return reader;
    }

    public FilePartitionReader(Iterator<PartitionedFileReader<T>> readers, FileSourceOptions options) {
        this.readers = readers;
        this.options = options;
        Logging.$init$((Logging)this);
        this.currentReader = null;
    }
}

