/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.expression;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.PrimaryExpressionIsClassLiteralException;
import org.datanucleus.query.expression.PrimaryExpressionIsClassStaticFieldException;
import org.datanucleus.query.expression.PrimaryExpressionIsInvokeException;
import org.datanucleus.query.expression.PrimaryExpressionIsVariableException;
import org.datanucleus.query.expression.VariableExpression;
import org.datanucleus.query.symbol.PropertySymbol;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.query.symbol.SymbolTable;
import org.datanucleus.util.ClassUtils;

public class PrimaryExpression
extends Expression {
    private static final long serialVersionUID = 6725075523258882792L;
    List<String> tuples;

    public PrimaryExpression(List<String> tuples) {
        this.tuples = tuples;
    }

    public PrimaryExpression(Expression left, List<String> tuples) {
        this.left = left;
        if (left != null) {
            left.parent = this;
        }
        this.tuples = tuples;
    }

    public String getId() {
        StringBuilder str = new StringBuilder();
        for (String tuple : this.tuples) {
            if (str.length() > 0) {
                str.append('.');
            }
            str.append(tuple);
        }
        return str.toString();
    }

    public List<String> getTuples() {
        return this.tuples;
    }

    @Override
    public Symbol bind(SymbolTable symtbl) {
        block30: {
            Class symbolType2;
            if (this.left != null) {
                this.left.bind(symtbl);
            }
            if (this.left == null && symtbl.hasSymbol(this.getId())) {
                this.symbol = symtbl.getSymbol(this.getId());
                if (this.symbol.getType() == 2) {
                    throw new PrimaryExpressionIsVariableException(this.symbol.getQualifiedName());
                }
                return this.symbol;
            }
            if (this.left != null) {
                return null;
            }
            if (this.symbol == null) {
                try {
                    symbolType2 = symtbl.getSymbolResolver().getType(this.tuples);
                    this.symbol = new PropertySymbol(this.getId(), symbolType2);
                }
                catch (NucleusUserException symbolType2) {
                    // empty catch block
                }
            }
            if (this.symbol == null && symtbl.getParentSymbolTable() != null) {
                try {
                    symbolType2 = symtbl.getParentSymbolTable().getSymbolResolver().getType(this.tuples);
                    this.symbol = new PropertySymbol(this.getId(), symbolType2);
                }
                catch (NucleusUserException symbolType3) {
                    // empty catch block
                }
            }
            if (this.symbol == null) {
                String className = this.getId();
                try {
                    Class cls = symtbl.getSymbolResolver().resolveClass(className);
                    throw new PrimaryExpressionIsClassLiteralException(cls);
                }
                catch (ClassNotResolvedException cnre) {
                    if (className.indexOf(46) < 0) {
                        Class primaryCls = symtbl.getSymbolResolver().getPrimaryClass();
                        if (primaryCls == null) {
                            throw new NucleusUserException("Class name " + className + " could not be resolved");
                        }
                        try {
                            Field fld = primaryCls.getDeclaredField(className);
                            if (!Modifier.isStatic(fld.getModifiers())) {
                                throw new NucleusUserException("Identifier " + className + " is unresolved (not a static field)");
                            }
                            throw new PrimaryExpressionIsClassStaticFieldException(fld);
                        }
                        catch (NoSuchFieldException nsfe) {
                            if (symtbl.getSymbolResolver().supportsImplicitVariables() && this.left == null) {
                                throw new PrimaryExpressionIsVariableException(className);
                            }
                            throw new NucleusUserException("Class name " + className + " could not be resolved");
                        }
                    }
                    try {
                        String staticFieldName = className.substring(className.lastIndexOf(46) + 1);
                        className = className.substring(0, className.lastIndexOf(46));
                        Class cls = symtbl.getSymbolResolver().resolveClass(className);
                        try {
                            Field fld = cls.getDeclaredField(staticFieldName);
                            if (!Modifier.isStatic(fld.getModifiers())) {
                                throw new NucleusUserException("Identifier " + className + "." + staticFieldName + " is unresolved (not a static field)");
                            }
                            throw new PrimaryExpressionIsClassStaticFieldException(fld);
                        }
                        catch (NoSuchFieldException nsfe) {
                            throw new NucleusUserException("Identifier " + className + "." + staticFieldName + " is unresolved (not a static field)");
                        }
                    }
                    catch (ClassNotResolvedException cnre2) {
                        if (this.getId().indexOf(".") > 0) {
                            Iterator<String> tupleIter = this.tuples.iterator();
                            Class cls = null;
                            while (tupleIter.hasNext()) {
                                String tuple = tupleIter.next();
                                if (cls == null) {
                                    Symbol sym = symtbl.getSymbol(tuple);
                                    if (sym == null && (sym = symtbl.getSymbol("this")) == null) break;
                                    cls = sym.getValueType();
                                    continue;
                                }
                                if (cls.isArray() && tuple.equals("length") && !tupleIter.hasNext()) {
                                    PrimaryExpression primExpr = new PrimaryExpression(this.left, this.tuples.subList(0, this.tuples.size() - 1));
                                    InvokeExpression invokeExpr = new InvokeExpression((Expression)primExpr, "size", null);
                                    throw new PrimaryExpressionIsInvokeException(invokeExpr);
                                }
                                cls = ClassUtils.getClassForMemberOfClass(cls, tuple);
                            }
                            if (cls != null) {
                                // empty if block
                            }
                        }
                        if (symtbl.getSymbolResolver().supportsImplicitVariables() && this.left == null) {
                            String varName = this.tuples.remove(0);
                            VariableExpression varExpr = new VariableExpression(varName);
                            varExpr.bind(symtbl);
                            this.left = varExpr;
                            break block30;
                        }
                        throw new NucleusUserException("Cannot find type of (part of) " + this.getId() + " since symbol has no type; implicit variable?");
                    }
                }
            }
        }
        return this.symbol;
    }

    public String toString() {
        if (this.left != null) {
            return "PrimaryExpression{" + this.left + "." + this.getId() + "}" + (this.alias != null ? " AS " + this.alias : "");
        }
        return "PrimaryExpression{" + this.getId() + "}" + (this.alias != null ? " AS " + this.alias : "");
    }
}

